/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.miniclient.ApiServiceClient;
import org.miniclient.FlexibleResourceClient;
import org.miniclient.FlexibleServiceClient;
import org.miniclient.RestApiException;
import org.miniclient.RestServiceClient;
import org.miniclient.common.AuthRefreshPolicy;
import org.miniclient.common.AutoRedirectPolicy;
import org.miniclient.common.CacheControlPolicy;
import org.miniclient.common.ClientCachePolicy;
import org.miniclient.common.CrudMethodFilter;
import org.miniclient.common.RequestRetryPolicy;
import org.miniclient.core.ListResponseType;
import org.miniclient.core.StatusCode;
import org.miniclient.credential.ClientCredential;
import org.miniclient.credential.DataAccessCredential;
import org.miniclient.credential.UserCredential;
import org.miniclient.exception.MethodNotAllowedRaException;
import org.miniclient.exception.NotImplementedRaException;
import org.miniclient.exception.RestApiClientException;
import org.miniclient.exception.StatusExceptionMapper;
import org.miniclient.impl.AbstractRestServiceClient;
import org.miniclient.maker.ApiServiceClientMaker;
import org.miniclient.maker.impl.AbstractApiServiceClientMaker;

public abstract class AbstractApiServiceClient
implements ApiServiceClient,
FlexibleResourceClient,
FlexibleServiceClient {
    private static final Logger log = Logger.getLogger(AbstractApiServiceClient.class.getName());
    private final RestServiceClient restServiceClient;
    private final ApiServiceClientMaker apiServiceClientMaker = this.makeApiServiceClientMaker();
    private final CrudMethodFilter crudMethodFilter;
    private ListResponseType listResponseType;
    private AuthRefreshPolicy authRefreshPolicy;
    private RequestRetryPolicy requestRetryPolicy;
    private ClientCachePolicy clientCachePolicy;
    private CacheControlPolicy cacheControlPolicy;
    private AutoRedirectPolicy autoRedirectPolicy;

    public AbstractApiServiceClient(String resourceBaseUrl) {
        this.restServiceClient = this.makeRestClient(resourceBaseUrl);
        this.crudMethodFilter = this.makeCrudMethodFilter();
        this.authRefreshPolicy = this.makeAuthRefreshPolicy();
        this.requestRetryPolicy = this.makeRequestRetryPolicy();
        this.clientCachePolicy = this.makeClientCachePolicy();
        this.cacheControlPolicy = this.makeCacheControlPolicy();
        this.autoRedirectPolicy = this.makeAutoRedirectPolicy();
        this.init();
    }

    protected void init() {
        this.listResponseType = ListResponseType.getDefaultListResponseType();
    }

    protected RestServiceClient getRestServiceClient() {
        return this.restServiceClient;
    }

    protected FlexibleResourceClient getFlexibleRestServiceClient() {
        return (FlexibleResourceClient)((Object)this.restServiceClient);
    }

    protected ApiServiceClientMaker makeApiServiceClientMaker() {
        return AbstractApiServiceClient.createApiServiceClientMaker();
    }

    private static ApiServiceClientMaker createApiServiceClientMaker() {
        return AbstractApiServiceClientMaker.getInstance();
    }

    protected RestServiceClient makeRestClient(String resourceBaseUrl) {
        return this.apiServiceClientMaker.makeRestClient(resourceBaseUrl);
    }

    protected CrudMethodFilter makeCrudMethodFilter() {
        return this.apiServiceClientMaker.makeCrudMethodFilter();
    }

    protected AuthRefreshPolicy makeAuthRefreshPolicy() {
        return this.apiServiceClientMaker.makeAuthRefreshPolicy();
    }

    protected RequestRetryPolicy makeRequestRetryPolicy() {
        return this.apiServiceClientMaker.makeRequestRetryPolicy();
    }

    protected ClientCachePolicy makeClientCachePolicy() {
        return this.apiServiceClientMaker.makeClientCachePolicy();
    }

    protected CacheControlPolicy makeCacheControlPolicy() {
        return this.apiServiceClientMaker.makeCacheControlPolicy();
    }

    protected AutoRedirectPolicy makeAutoRedirectPolicy() {
        return this.apiServiceClientMaker.makeAutoRedirectPolicy();
    }

    public CrudMethodFilter getCrudMethodFilter() {
        return this.crudMethodFilter;
    }

    @Override
    public boolean isMethodSupported(String methodName) {
        return this.crudMethodFilter.isMethodSupported(methodName);
    }

    public ListResponseType getListResponseType() {
        return this.listResponseType;
    }

    public void setListResponseType(ListResponseType listResponseType) {
        this.listResponseType = listResponseType;
    }

    @Override
    public String getResourceBaseUrl() {
        return this.getRestServiceClient().getResourceBaseUrl();
    }

    @Override
    public ClientCredential getClientCredential() {
        return this.getRestServiceClient().getClientCredential();
    }

    @Override
    public void setClientCredential(ClientCredential clientCredential) {
        ((AbstractRestServiceClient)this.getRestServiceClient()).setClientCredential(clientCredential);
    }

    public AuthRefreshPolicy getRestServiceAuthRefreshPolicy() {
        return this.getRestServiceClient().getAuthRefreshPolicy();
    }

    public void setRestServiceAuthRefreshPolicy(AuthRefreshPolicy authRefreshPolicy) {
        this.getFlexibleRestServiceClient().setAuthRefreshPolicy(authRefreshPolicy);
    }

    public RequestRetryPolicy getRestServiceRequestRetryPolicy() {
        return this.getRestServiceClient().getRequestRetryPolicy();
    }

    public void setRestServiceRequestRetryPolicy(RequestRetryPolicy requestRetryPolicy) {
        this.getFlexibleRestServiceClient().setRequestRetryPolicy(requestRetryPolicy);
    }

    public ClientCachePolicy getRestServiceClientCachePolicy() {
        return this.getRestServiceClient().getClientCachePolicy();
    }

    public void setRestServiceClientCachePolicy(ClientCachePolicy clientCachePolicy) {
        this.getFlexibleRestServiceClient().setClientCachePolicy(clientCachePolicy);
    }

    public CacheControlPolicy getRestServiceCacheControlPolicy() {
        return this.getRestServiceClient().getCacheControlPolicy();
    }

    public void setRestServiceCacheControlPolicy(CacheControlPolicy cacheControlPolicy) {
        this.getFlexibleRestServiceClient().setCacheControlPolicy(cacheControlPolicy);
    }

    public AutoRedirectPolicy getRestServiceAutoRedirectPolicy() {
        return this.getRestServiceClient().getAutoRedirectPolicy();
    }

    public void setRestServiceAutoRedirectPolicy(AutoRedirectPolicy autoRedirectPolicy) {
        this.getFlexibleRestServiceClient().setAutoRedirectPolicy(autoRedirectPolicy);
    }

    @Override
    public Set<String> getRequiredScopes() {
        return this.getRestServiceClient().getRequiredScopes();
    }

    @Override
    public boolean requiresScope(String scope) {
        return this.getRestServiceClient().requiresScope(scope);
    }

    @Override
    public boolean isAccessAllowed(DataAccessCredential dataAccessCredential) {
        return this.getRestServiceClient().isAccessAllowed(dataAccessCredential);
    }

    @Override
    public AuthRefreshPolicy getAuthRefreshPolicy() {
        return this.authRefreshPolicy;
    }

    @Override
    public void setAuthRefreshPolicy(AuthRefreshPolicy authRefreshPolicy) {
        this.authRefreshPolicy = authRefreshPolicy;
    }

    @Override
    public RequestRetryPolicy getRequestRetryPolicy() {
        return this.requestRetryPolicy;
    }

    @Override
    public void setRequestRetryPolicy(RequestRetryPolicy requestRetryPolicy) {
        this.requestRetryPolicy = requestRetryPolicy;
    }

    @Override
    public ClientCachePolicy getClientCachePolicy() {
        return this.clientCachePolicy;
    }

    @Override
    public void setClientCachePolicy(ClientCachePolicy clientCachePolicy) {
        this.clientCachePolicy = clientCachePolicy;
    }

    @Override
    public AutoRedirectPolicy getAutoRedirectPolicy() {
        return this.autoRedirectPolicy;
    }

    @Override
    public void setAutoRedirectPolicy(AutoRedirectPolicy autoRedirectPolicy) {
        this.autoRedirectPolicy = autoRedirectPolicy;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object get(UserCredential credential, String id) throws RestApiException, IOException {
        Object object = null;
        if (!this.crudMethodFilter.isMethodSupported("get.item")) throw new MethodNotAllowedRaException("Method, get.item, not supporeted.");
        Map<String, Object> response = null;
        if (id == null) throw new RestApiClientException("Resource id is missing.");
        if (id.isEmpty()) {
            throw new RestApiClientException("Resource id is missing.");
        }
        response = this.getRestServiceClient().get(credential, id, null);
        if (response == null) throw new RestApiException("Failed to get() the resource for id = " + id);
        int statusCode = (Integer)response.get("status");
        if (StatusCode.isSuccessful(statusCode)) {
            Object payload = response.get("payload");
            return payload;
        }
        Map error = (Map)response.get("error");
        String resource = (String)response.get("resource");
        String location = (String)response.get("location");
        RestApiException exception = null;
        if (error != null) {
            String errorCode = (String)error.get("code");
            String errorMessage = (String)error.get("message");
            exception = StatusExceptionMapper.buildException(errorMessage, null, resource, statusCode, location);
            throw exception;
        } else {
            exception = new RestApiException("Unknown error: Failed to get() the resource for id = " + id);
        }
        throw exception;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<Object> list(UserCredential credential, Map<String, Object> params) throws RestApiException, IOException {
        Object var3_3 = null;
        if (!this.crudMethodFilter.isMethodSupported("get.list")) throw new MethodNotAllowedRaException("Method, get.list, not supporeted.");
        Map<String, Object> response = this.getRestServiceClient().get(credential, null, params);
        if (response == null) throw new RestApiException("Failed to get() the resources.");
        int statusCode = (Integer)response.get("status");
        if (StatusCode.isSuccessful(statusCode)) {
            void var3_8;
            Object payload = response.get("payload");
            if (payload instanceof List) {
                List objectList;
                List list = objectList = (List)payload;
                return var3_8;
            } else {
                ArrayList<Object> objectList;
                void var3_6;
                log.info("Was expecting a list type response. Invalid type returned.");
                if (this.listResponseType != null) {
                    if (this.listResponseType.equals(ListResponseType.LIST)) {
                        log.warning("The response should have been a list. Invalid type returned.");
                    } else if (payload instanceof Map) {
                        String listKey = this.listResponseType.getListKey();
                        Map objectListMap = (Map)payload;
                        if (objectListMap != null) {
                            List objectList2;
                            List list = objectList2 = (List)objectListMap.get(listKey);
                        }
                    } else {
                        log.warning("The response is neither a map nor a list. Unrecognized type returned.");
                    }
                }
                if (var3_6 != null) return var3_8;
                ArrayList<Object> arrayList = objectList = new ArrayList<Object>(Arrays.asList(payload));
            }
            return var3_8;
        } else {
            Map error = (Map)response.get("error");
            String resource = (String)response.get("resource");
            String location = (String)response.get("location");
            RestApiException exception = null;
            if (error != null) {
                String errorCode = (String)error.get("code");
                String errorMessage = (String)error.get("message");
                exception = StatusExceptionMapper.buildException(errorMessage, null, resource, statusCode, location);
                throw exception;
            } else {
                exception = new RestApiException("Unknown error: Failed to get() the resources.");
            }
            throw exception;
        }
    }

    @Override
    public List<String> keys(UserCredential credential, Map<String, Object> params) throws RestApiException, IOException {
        if (this.crudMethodFilter.isMethodSupported("get.keys")) {
            throw new NotImplementedRaException("keys() is not supported yet.");
        }
        throw new MethodNotAllowedRaException("Method, get.keys, not supporeted.");
    }

    @Override
    public Object create(UserCredential credential, Object inputData) throws RestApiException, IOException {
        return this.create(credential, inputData, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object create(UserCredential credential, Object inputData, String id) throws RestApiException, IOException {
        Object object = null;
        if (!this.crudMethodFilter.isMethodSupported("create.item")) throw new MethodNotAllowedRaException("Method, create.item, not supporeted.");
        Map<String, Object> response = null;
        response = id == null || id.isEmpty() ? this.getRestServiceClient().post(credential, inputData) : this.getRestServiceClient().put(credential, inputData, id);
        if (response == null) throw new RestApiException("Failed to post() to the resource for id = " + id);
        int statusCode = (Integer)response.get("status");
        if (StatusCode.isSuccessful(statusCode)) {
            Object payload = response.get("payload");
            return payload;
        }
        Map error = (Map)response.get("error");
        String resource = (String)response.get("resource");
        String location = (String)response.get("location");
        RestApiException exception = null;
        if (error != null) {
            String errorCode = (String)error.get("code");
            String errorMessage = (String)error.get("message");
            exception = StatusExceptionMapper.buildException(errorMessage, null, resource, statusCode, location);
            throw exception;
        } else {
            exception = new RestApiException("Unknown error: Failed to post() to the resource for id = " + id);
        }
        throw exception;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object update(UserCredential credential, Object inputData, String id) throws RestApiException, IOException {
        Object object = null;
        if (!this.crudMethodFilter.isMethodSupported("update.item")) throw new MethodNotAllowedRaException("Method, update.item, not supporeted.");
        Map<String, Object> response = null;
        if (id == null) throw new RestApiClientException("Resource id is missing.");
        if (id.isEmpty()) {
            throw new RestApiClientException("Resource id is missing.");
        }
        response = this.getRestServiceClient().put(credential, inputData, id);
        if (response == null) throw new RestApiException("Failed to put() to the resource for id = " + id);
        int statusCode = (Integer)response.get("status");
        if (StatusCode.isSuccessful(statusCode)) {
            Object payload = response.get("payload");
            return payload;
        }
        Map error = (Map)response.get("error");
        String resource = (String)response.get("resource");
        String location = (String)response.get("location");
        RestApiException exception = null;
        if (error != null) {
            String errorCode = (String)error.get("code");
            String errorMessage = (String)error.get("message");
            exception = StatusExceptionMapper.buildException(errorMessage, null, resource, statusCode, location);
            throw exception;
        } else {
            exception = new RestApiException("Unknown error: Failed to put() to the resource for id = " + id);
        }
        throw exception;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object modify(UserCredential credential, Object partialData, String id) throws RestApiException, IOException {
        Object object = null;
        if (!this.crudMethodFilter.isMethodSupported("modify.item")) throw new MethodNotAllowedRaException("Method, modify.item, not supporeted.");
        Map<String, Object> response = null;
        if (id == null) throw new RestApiClientException("Resource id is missing.");
        if (id.isEmpty()) {
            throw new RestApiClientException("Resource id is missing.");
        }
        response = this.getRestServiceClient().patch(credential, partialData, id);
        if (response == null) throw new RestApiException("Failed to put() to the resource for id = " + id);
        int statusCode = (Integer)response.get("status");
        if (StatusCode.isSuccessful(statusCode)) {
            Object payload = response.get("payload");
            return payload;
        }
        Map error = (Map)response.get("error");
        String resource = (String)response.get("resource");
        String location = (String)response.get("location");
        RestApiException exception = null;
        if (error != null) {
            String errorCode = (String)error.get("code");
            String errorMessage = (String)error.get("message");
            exception = StatusExceptionMapper.buildException(errorMessage, null, resource, statusCode, location);
            throw exception;
        } else {
            exception = new RestApiException("Unknown error: Failed to put() to the resource for id = " + id);
        }
        throw exception;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean delete(UserCredential credential, String id) throws RestApiException, IOException {
        boolean suc = false;
        if (!this.crudMethodFilter.isMethodSupported("delete.item")) throw new MethodNotAllowedRaException("Method, delete.item, not supporeted.");
        Map<String, Object> response = null;
        if (id == null) throw new RestApiClientException("Resource id is missing.");
        if (id.isEmpty()) {
            throw new RestApiClientException("Resource id is missing.");
        }
        response = this.getRestServiceClient().delete(credential, id, null);
        if (response == null) throw new RestApiException("Failed to delete() the resource for id = " + id);
        int statusCode = (Integer)response.get("status");
        if (StatusCode.isSuccessful(statusCode)) {
            return true;
        }
        Map error = (Map)response.get("error");
        String resource = (String)response.get("resource");
        String location = (String)response.get("location");
        RestApiException exception = null;
        if (error != null) {
            String errorCode = (String)error.get("code");
            String errorMessage = (String)error.get("message");
            exception = StatusExceptionMapper.buildException(errorMessage, null, resource, statusCode, location);
            throw exception;
        } else {
            exception = new RestApiException("Unknown error: Failed to delete() the resource for id = " + id);
        }
        throw exception;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int delete(UserCredential credential, Map<String, Object> params) throws RestApiException, IOException {
        int count = 0;
        if (!this.crudMethodFilter.isMethodSupported("delete.list")) throw new MethodNotAllowedRaException("Method, delete.list, not supporeted.");
        Map<String, Object> response = this.getRestServiceClient().delete(credential, null, params);
        if (response == null) throw new RestApiException("Failed to delete() the resources");
        int statusCode = (Integer)response.get("status");
        if (StatusCode.isSuccessful(statusCode)) {
            return 0;
        }
        Map error = (Map)response.get("error");
        String resource = (String)response.get("resource");
        String location = (String)response.get("location");
        RestApiException exception = null;
        if (error != null) {
            String errorCode = (String)error.get("code");
            String errorMessage = (String)error.get("message");
            exception = StatusExceptionMapper.buildException(errorMessage, null, resource, statusCode, location);
            throw exception;
        } else {
            exception = new RestApiException("Unknown error: Failed to delete() the resources");
        }
        throw exception;
    }

    public String toString() {
        return "AbstractApiServiceClient [restServiceClient=" + this.restServiceClient + ", apiServiceClientMaker=" + this.apiServiceClientMaker + ", crudMethodFilter=" + this.crudMethodFilter + ", listResponseType=" + this.listResponseType + ", authRefreshPolicy=" + this.authRefreshPolicy + ", requestRetryPolicy=" + this.requestRetryPolicy + ", clientCachePolicy=" + this.clientCachePolicy + ", autoRedirectPolicy=" + this.autoRedirectPolicy + "]";
    }

    @Override
    public CacheControlPolicy getCacheControlPolicy() {
        return null;
    }

    @Override
    public void setCacheControlPolicy(CacheControlPolicy cacheControlPolicy) {
    }
}

