/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.impl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.miniclient.ApiServiceClient;
import org.miniclient.ApiUserClient;
import org.miniclient.FlexibleResourceClient;
import org.miniclient.FlexibleUserClient;
import org.miniclient.RestApiException;
import org.miniclient.common.AuthRefreshPolicy;
import org.miniclient.common.AutoRedirectPolicy;
import org.miniclient.common.CacheControlPolicy;
import org.miniclient.common.ClientCachePolicy;
import org.miniclient.common.RequestRetryPolicy;
import org.miniclient.credential.UserCredential;
import org.miniclient.impl.AbstractApiServiceClient;
import org.miniclient.maker.ApiUserClientMaker;
import org.miniclient.maker.impl.AbstractApiUserClientMaker;

public abstract class AbstractApiUserClient
implements ApiUserClient,
FlexibleResourceClient,
FlexibleUserClient {
    private static final Logger log = Logger.getLogger(AbstractApiUserClient.class.getName());
    private ApiUserClientMaker apiUserClientMaker = this.makeApiUserClientMaker();
    private final ApiServiceClient apiServiceClient;
    private UserCredential userCredential;

    public AbstractApiUserClient(String resourceBaseUrl) {
        this(resourceBaseUrl, null);
    }

    public AbstractApiUserClient(String resourceBaseUrl, UserCredential userCredential) {
        this.apiServiceClient = this.makeServiceClient(resourceBaseUrl);
        this.init();
    }

    public AbstractApiUserClient(ApiServiceClient apiServiceClient) {
        this(apiServiceClient, null);
    }

    public AbstractApiUserClient(ApiServiceClient apiServiceClient, UserCredential userCredential) {
        this.apiServiceClient = apiServiceClient;
        this.init();
    }

    protected void init() {
    }

    protected ApiServiceClient getApiServiceClient() {
        return this.apiServiceClient;
    }

    protected FlexibleResourceClient getFlexibleApiServiceClient() {
        return (FlexibleResourceClient)((Object)this.apiServiceClient);
    }

    protected ApiUserClientMaker makeApiUserClientMaker() {
        return AbstractApiUserClient.createApiUserClientMaker();
    }

    private static ApiUserClientMaker createApiUserClientMaker() {
        return AbstractApiUserClientMaker.getInstance();
    }

    protected ApiServiceClient makeServiceClient(String resourceBaseUrl) {
        return this.apiUserClientMaker.makeServiceClient(resourceBaseUrl);
    }

    @Override
    public boolean isMethodSupported(String methodName) {
        return this.getApiServiceClient().isMethodSupported(methodName);
    }

    @Override
    public UserCredential getUserCredential() {
        return this.userCredential;
    }

    @Override
    public void setUserCredential(UserCredential userCredential) {
        this.userCredential = userCredential;
    }

    public boolean isAccessAllowed() {
        return this.getApiServiceClient().isAccessAllowed(this.userCredential);
    }

    @Override
    public String getResourceBaseUrl() {
        return this.getApiServiceClient().getResourceBaseUrl();
    }

    public AuthRefreshPolicy getRestServiceAuthRefreshPolicy() {
        return ((AbstractApiServiceClient)this.getApiServiceClient()).getRestServiceAuthRefreshPolicy();
    }

    public void setRestServiceAuthRefreshPolicy(AuthRefreshPolicy authRefreshPolicy) {
        ((AbstractApiServiceClient)this.getApiServiceClient()).setRestServiceAuthRefreshPolicy(authRefreshPolicy);
    }

    public RequestRetryPolicy getRestServiceRequestRetryPolicy() {
        return ((AbstractApiServiceClient)this.getApiServiceClient()).getRestServiceRequestRetryPolicy();
    }

    public void setRestServiceRequestRetryPolicy(RequestRetryPolicy requestRetryPolicy) {
        ((AbstractApiServiceClient)this.getApiServiceClient()).setRestServiceRequestRetryPolicy(requestRetryPolicy);
    }

    public ClientCachePolicy getRestServiceClientCachePolicy() {
        return ((AbstractApiServiceClient)this.getApiServiceClient()).getRestServiceClientCachePolicy();
    }

    public void setRestServiceClientCachePolicy(ClientCachePolicy clientCachePolicy) {
        ((AbstractApiServiceClient)this.getApiServiceClient()).setRestServiceClientCachePolicy(clientCachePolicy);
    }

    public AutoRedirectPolicy getRestServiceAutoRedirectPolicy() {
        return ((AbstractApiServiceClient)this.getApiServiceClient()).getRestServiceAutoRedirectPolicy();
    }

    public void setRestServiceAutoRedirectPolicy(AutoRedirectPolicy autoRedirectPolicy) {
        ((AbstractApiServiceClient)this.getApiServiceClient()).setRestServiceAutoRedirectPolicy(autoRedirectPolicy);
    }

    @Override
    public AuthRefreshPolicy getAuthRefreshPolicy() {
        return this.getApiServiceClient().getAuthRefreshPolicy();
    }

    @Override
    public void setAuthRefreshPolicy(AuthRefreshPolicy authRefreshPolicy) {
        this.getFlexibleApiServiceClient().setAuthRefreshPolicy(authRefreshPolicy);
    }

    @Override
    public RequestRetryPolicy getRequestRetryPolicy() {
        return this.getApiServiceClient().getRequestRetryPolicy();
    }

    @Override
    public void setRequestRetryPolicy(RequestRetryPolicy requestRetryPolicy) {
        this.getFlexibleApiServiceClient().setRequestRetryPolicy(requestRetryPolicy);
    }

    @Override
    public ClientCachePolicy getClientCachePolicy() {
        return this.getApiServiceClient().getClientCachePolicy();
    }

    @Override
    public void setClientCachePolicy(ClientCachePolicy clientCachePolicy) {
        this.getFlexibleApiServiceClient().setClientCachePolicy(clientCachePolicy);
    }

    @Override
    public CacheControlPolicy getCacheControlPolicy() {
        return this.getApiServiceClient().getCacheControlPolicy();
    }

    @Override
    public void setCacheControlPolicy(CacheControlPolicy cacheControlPolicy) {
        this.getFlexibleApiServiceClient().setCacheControlPolicy(cacheControlPolicy);
    }

    @Override
    public AutoRedirectPolicy getAutoRedirectPolicy() {
        return this.getApiServiceClient().getAutoRedirectPolicy();
    }

    @Override
    public void setAutoRedirectPolicy(AutoRedirectPolicy autoRedirectPolicy) {
        this.getFlexibleApiServiceClient().setAutoRedirectPolicy(autoRedirectPolicy);
    }

    @Override
    public Object get(String id) throws RestApiException, IOException {
        return this.getApiServiceClient().get(this.getUserCredential(), id);
    }

    @Override
    public List<Object> list(Map<String, Object> params) throws RestApiException, IOException {
        return this.getApiServiceClient().list(this.getUserCredential(), params);
    }

    @Override
    public List<String> keys(Map<String, Object> params) throws RestApiException, IOException {
        return this.getApiServiceClient().keys(this.getUserCredential(), params);
    }

    @Override
    public Object create(Object inputData) throws RestApiException, IOException {
        return this.getApiServiceClient().create(this.getUserCredential(), inputData);
    }

    @Override
    public Object create(Object inputData, String id) throws RestApiException, IOException {
        return this.getApiServiceClient().create(this.getUserCredential(), inputData, id);
    }

    @Override
    public Object update(Object inputData, String id) throws RestApiException, IOException {
        return this.getApiServiceClient().update(this.getUserCredential(), inputData, id);
    }

    @Override
    public Object modify(Object partialData, String id) throws RestApiException, IOException {
        return this.getApiServiceClient().modify(this.getUserCredential(), partialData, id);
    }

    @Override
    public boolean delete(String id) throws RestApiException, IOException {
        return this.getApiServiceClient().delete(this.getUserCredential(), id);
    }

    @Override
    public int delete(Map<String, Object> params) throws RestApiException, IOException {
        return this.getApiServiceClient().delete(this.getUserCredential(), params);
    }

    public String toString() {
        return "AbstractApiUserClient [apiUserClientMaker=" + this.apiUserClientMaker + ", apiServiceClient=" + this.apiServiceClient + ", userCredential=" + this.userCredential + "]";
    }
}

