/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.impl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.miniclient.FlexibleResourceClient;
import org.miniclient.FlexibleUserClient;
import org.miniclient.RestApiException;
import org.miniclient.RestApiServiceClient;
import org.miniclient.RestApiUserClient;
import org.miniclient.common.AuthRefreshPolicy;
import org.miniclient.common.AutoRedirectPolicy;
import org.miniclient.common.CacheControlPolicy;
import org.miniclient.common.ClientCachePolicy;
import org.miniclient.common.RequestRetryPolicy;
import org.miniclient.credential.UserCredential;

public abstract class AbstractRestApiUserClient
implements RestApiUserClient,
FlexibleResourceClient,
FlexibleUserClient {
    private static final Logger log = Logger.getLogger(AbstractRestApiUserClient.class.getName());
    private final RestApiServiceClient restApiServiceClient;
    private UserCredential authCredential;

    public AbstractRestApiUserClient(RestApiServiceClient restApiServiceClient) {
        this(restApiServiceClient, null);
    }

    public AbstractRestApiUserClient(RestApiServiceClient restApiServiceClient, UserCredential authCredential) {
        this.restApiServiceClient = restApiServiceClient;
        this.authCredential = authCredential;
        this.init();
    }

    protected void init() {
    }

    protected RestApiServiceClient getRestApiServiceClient() {
        return this.restApiServiceClient;
    }

    protected FlexibleResourceClient getFlexibleRestApiServiceClient() {
        return (FlexibleResourceClient)((Object)this.restApiServiceClient);
    }

    @Override
    public boolean isMethodSupported(String methodName) {
        return this.getRestApiServiceClient().isMethodSupported(methodName);
    }

    @Override
    public UserCredential getUserCredential() {
        return this.authCredential;
    }

    @Override
    public void setUserCredential(UserCredential userCredential) {
        this.authCredential = this.authCredential;
    }

    @Override
    public String getResourceBaseUrl() {
        return this.getRestApiServiceClient().getResourceBaseUrl();
    }

    @Override
    public AuthRefreshPolicy getAuthRefreshPolicy() {
        return this.getRestApiServiceClient().getAuthRefreshPolicy();
    }

    @Override
    public void setAuthRefreshPolicy(AuthRefreshPolicy authRefreshPolicy) {
        this.getFlexibleRestApiServiceClient().setAuthRefreshPolicy(authRefreshPolicy);
    }

    @Override
    public RequestRetryPolicy getRequestRetryPolicy() {
        return this.getRestApiServiceClient().getRequestRetryPolicy();
    }

    @Override
    public void setRequestRetryPolicy(RequestRetryPolicy requestRetryPolicy) {
        this.getFlexibleRestApiServiceClient().setRequestRetryPolicy(requestRetryPolicy);
    }

    @Override
    public ClientCachePolicy getClientCachePolicy() {
        return this.getRestApiServiceClient().getClientCachePolicy();
    }

    @Override
    public void setClientCachePolicy(ClientCachePolicy clientCachePolicy) {
        this.getFlexibleRestApiServiceClient().setClientCachePolicy(clientCachePolicy);
    }

    @Override
    public CacheControlPolicy getCacheControlPolicy() {
        return this.getRestApiServiceClient().getCacheControlPolicy();
    }

    @Override
    public void setCacheControlPolicy(CacheControlPolicy cacheControlPolicy) {
        this.getFlexibleRestApiServiceClient().setCacheControlPolicy(cacheControlPolicy);
    }

    @Override
    public AutoRedirectPolicy getAutoRedirectPolicy() {
        return this.getRestApiServiceClient().getAutoRedirectPolicy();
    }

    @Override
    public void setAutoRedirectPolicy(AutoRedirectPolicy autoRedirectPolicy) {
        this.getFlexibleRestApiServiceClient().setAutoRedirectPolicy(autoRedirectPolicy);
    }

    @Override
    public Map<String, Object> get(String id, Map<String, Object> params) throws IOException {
        return this.getRestApiServiceClient().get(this.getUserCredential(), id, params);
    }

    @Override
    public Map<String, Object> post(Object inputData) throws IOException {
        return this.getRestApiServiceClient().post(this.getUserCredential(), inputData);
    }

    @Override
    public Map<String, Object> put(Object inputData, String id) throws IOException {
        return this.getRestApiServiceClient().put(this.getUserCredential(), inputData, id);
    }

    @Override
    public Map<String, Object> patch(Object partialData, String id) throws IOException {
        return this.getRestApiServiceClient().patch(this.getUserCredential(), partialData, id);
    }

    @Override
    public Map<String, Object> delete(String id, Map<String, Object> params) throws IOException {
        return this.getRestApiServiceClient().delete(this.getUserCredential(), id, params);
    }

    @Override
    public Object get(String id) throws RestApiException, IOException {
        return this.getRestApiServiceClient().get(this.getUserCredential(), id);
    }

    @Override
    public List<Object> list(Map<String, Object> params) throws RestApiException, IOException {
        return this.getRestApiServiceClient().list(this.getUserCredential(), params);
    }

    @Override
    public List<String> keys(Map<String, Object> params) throws RestApiException, IOException {
        return this.getRestApiServiceClient().keys(this.getUserCredential(), params);
    }

    @Override
    public Object create(Object inputData) throws RestApiException, IOException {
        return this.getRestApiServiceClient().create(this.getUserCredential(), inputData);
    }

    @Override
    public Object create(Object inputData, String id) throws RestApiException, IOException {
        return this.getRestApiServiceClient().create(this.getUserCredential(), inputData, id);
    }

    @Override
    public Object update(Object inputData, String id) throws RestApiException, IOException {
        return this.getRestApiServiceClient().update(this.getUserCredential(), inputData, id);
    }

    @Override
    public Object modify(Object partialData, String id) throws RestApiException, IOException {
        return this.getRestApiServiceClient().modify(this.getUserCredential(), partialData, id);
    }

    @Override
    public boolean delete(String id) throws RestApiException, IOException {
        return this.getRestApiServiceClient().delete(this.getUserCredential(), id);
    }

    @Override
    public int delete(Map<String, Object> params) throws RestApiException, IOException {
        return this.getRestApiServiceClient().delete(this.getUserCredential(), params);
    }

    public String toString() {
        return "AbstractRestApiUserClient [restApiServiceClient=" + this.restApiServiceClient + ", authCredential=" + this.authCredential + "]";
    }
}

