/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.impl;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import org.miniclient.FlexibleResourceClient;
import org.miniclient.FlexibleServiceClient;
import org.miniclient.RestApiException;
import org.miniclient.RestServiceClient;
import org.miniclient.common.AuthRefreshPolicy;
import org.miniclient.common.AutoRedirectPolicy;
import org.miniclient.common.CacheControlPolicy;
import org.miniclient.common.ClientCachePolicy;
import org.miniclient.common.DataAccessClient;
import org.miniclient.common.HttpMethodFilter;
import org.miniclient.common.RequestRetryPolicy;
import org.miniclient.common.ResourceUrlBuilder;
import org.miniclient.core.ContentFormat;
import org.miniclient.core.StatusCode;
import org.miniclient.credential.ClientCredential;
import org.miniclient.credential.DataAccessCredential;
import org.miniclient.credential.UserCredential;
import org.miniclient.credential.impl.AbstractUserCredential;
import org.miniclient.helper.ClientDebugHelper;
import org.miniclient.impl.AbstractDataAccessClient;
import org.miniclient.maker.RestServiceClientMaker;
import org.miniclient.maker.impl.AbstractRestServiceClientMaker;
import org.miniclient.util.JsonUtil;
import org.miniclient.util.ResourceUrlUtil;
import org.miniclient.util.ResponseUtil;
import org.miniclient.util.StringUtil;

public abstract class AbstractRestServiceClient
implements RestServiceClient,
FlexibleResourceClient,
FlexibleServiceClient,
ResourceUrlBuilder {
    private static final Logger log = Logger.getLogger(AbstractRestServiceClient.class.getName());
    private final String resourceBaseUrl;
    private final ResourceUrlBuilder resourceUrlBuilder;
    private final RestServiceClientMaker restServiceClientMaker;
    private final HttpMethodFilter httpMethodFilter;
    private boolean authCredentialRequired;
    private UserCredential defaultAuthCredential;
    private ClientCredential clientCredential;
    private DataAccessClient dataAccessClient;
    private String requestFormat;
    private String responseFormat;
    private int timeoutSeconds;
    private AuthRefreshPolicy authRefreshPolicy;
    private RequestRetryPolicy requestRetryPolicy;
    private ClientCachePolicy clientCachePolicy;
    private CacheControlPolicy cacheControlPolicy;
    private AutoRedirectPolicy autoRedirectPolicy;

    public AbstractRestServiceClient(String resourceBaseUrl) {
        this.resourceBaseUrl = resourceBaseUrl;
        this.restServiceClientMaker = this.makeRestServiceClientMaker();
        this.resourceUrlBuilder = this.makeResourceUrlBuilder(resourceBaseUrl);
        this.httpMethodFilter = this.makeHttpMethodFilter();
        this.dataAccessClient = this.makeDataAccessClient();
        this.authRefreshPolicy = this.makeAuthRefreshPolicy();
        this.requestRetryPolicy = this.makeRequestRetryPolicy();
        this.clientCachePolicy = this.makeClientCachePolicy();
        this.cacheControlPolicy = this.makeCacheControlPolicy();
        this.autoRedirectPolicy = this.makeAutoRedirectPolicy();
        this.init();
    }

    protected void init() {
        this.authCredentialRequired = true;
        this.defaultAuthCredential = new AbstractUserCredential(){};
        this.clientCredential = null;
        this.requestFormat = "JSON";
        this.responseFormat = "JSON";
        this.timeoutSeconds = 10;
    }

    public ResourceUrlBuilder getResourceUrlBuilder() {
        return this.resourceUrlBuilder;
    }

    public HttpMethodFilter getHttpMethodFilter() {
        return this.httpMethodFilter;
    }

    @Override
    public boolean isMethodSupported(String methodName) {
        return this.httpMethodFilter.isMethodSupported(methodName);
    }

    @Override
    public String getResourceBaseUrl() {
        return this.resourceUrlBuilder.getResourceBaseUrl();
    }

    @Override
    public String getResourceGetUrl(String id, Map<String, Object> params) {
        return this.resourceUrlBuilder.getResourceGetUrl(id, params);
    }

    @Override
    public String getResourcePostUrl() {
        return this.resourceUrlBuilder.getResourcePostUrl();
    }

    @Override
    public String getResourcePutUrl(String id) {
        return this.resourceUrlBuilder.getResourcePutUrl(id);
    }

    @Override
    public String getResourcePatchUrl(String id) {
        return this.resourceUrlBuilder.getResourcePatchUrl(id);
    }

    @Override
    public String getResourceDeleteUrl(String id, Map<String, Object> params) {
        return this.resourceUrlBuilder.getResourceDeleteUrl(id, params);
    }

    protected RestServiceClientMaker makeRestServiceClientMaker() {
        return AbstractRestServiceClient.createRestServiceClientMaker();
    }

    private static RestServiceClientMaker createRestServiceClientMaker() {
        return AbstractRestServiceClientMaker.getInstance();
    }

    protected ResourceUrlBuilder makeResourceUrlBuilder(String resourceBaseUrl) {
        return this.restServiceClientMaker.makeResourceUrlBuilder(resourceBaseUrl);
    }

    protected HttpMethodFilter makeHttpMethodFilter() {
        return this.restServiceClientMaker.makeHttpMethodFilter();
    }

    protected DataAccessClient makeDataAccessClient() {
        return this.restServiceClientMaker.makeDataAccessClient();
    }

    protected AuthRefreshPolicy makeAuthRefreshPolicy() {
        return this.restServiceClientMaker.makeAuthRefreshPolicy();
    }

    protected RequestRetryPolicy makeRequestRetryPolicy() {
        return this.restServiceClientMaker.makeRequestRetryPolicy();
    }

    protected ClientCachePolicy makeClientCachePolicy() {
        return this.restServiceClientMaker.makeClientCachePolicy();
    }

    protected CacheControlPolicy makeCacheControlPolicy() {
        return this.restServiceClientMaker.makeCacheControlPolicy();
    }

    protected AutoRedirectPolicy makeAutoRedirectPolicy() {
        return this.restServiceClientMaker.makeAutoRedirectPolicy();
    }

    public boolean isAuthCredentialRequired() {
        return this.authCredentialRequired;
    }

    public void setAuthCredentialRequired(boolean authCredentialRequired) {
        this.authCredentialRequired = authCredentialRequired;
    }

    public UserCredential getDefaultAuthCredential() {
        return this.defaultAuthCredential;
    }

    public void setDefaultAuthCredential(UserCredential defaultAuthCredential) {
        this.defaultAuthCredential = defaultAuthCredential;
    }

    @Override
    public ClientCredential getClientCredential() {
        return this.clientCredential;
    }

    @Override
    public void setClientCredential(ClientCredential clientCredential) {
        this.clientCredential = clientCredential;
    }

    @Override
    public Set<String> getRequiredScopes() {
        return this.dataAccessClient.getRequiredScopes();
    }

    public boolean addRequiredScope(String scope) {
        return ((AbstractDataAccessClient)this.dataAccessClient).addRequiredScope(scope);
    }

    public boolean addRequiredScopes(Collection<String> scopes) {
        return ((AbstractDataAccessClient)this.dataAccessClient).addRequiredScopes(scopes);
    }

    public boolean setRequiredScopes(Collection<String> scopes) {
        return ((AbstractDataAccessClient)this.dataAccessClient).setRequiredScopes(scopes);
    }

    public boolean removeRequiredScope(String scope) {
        return ((AbstractDataAccessClient)this.dataAccessClient).removeRequiredScope(scope);
    }

    public boolean removeRequiredScopes(Collection<String> scopes) {
        return ((AbstractDataAccessClient)this.dataAccessClient).removeRequiredScopes(scopes);
    }

    public void clearRequiredScopes() {
        ((AbstractDataAccessClient)this.dataAccessClient).clearRequiredScopes();
    }

    @Override
    public boolean requiresScope(String scope) {
        return this.dataAccessClient.requiresScope(scope);
    }

    @Override
    public boolean isAccessAllowed(DataAccessCredential dataAccessCredential) {
        return this.dataAccessClient.isAccessAllowed(dataAccessCredential);
    }

    public String getRequestFormat() {
        return this.requestFormat;
    }

    public void setRequestFormat(String requestFormat) {
        this.requestFormat = requestFormat;
    }

    public String getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(String responseFormat) {
        this.responseFormat = responseFormat;
    }

    public int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(int timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    @Override
    public AuthRefreshPolicy getAuthRefreshPolicy() {
        return this.authRefreshPolicy;
    }

    @Override
    public void setAuthRefreshPolicy(AuthRefreshPolicy authRefreshPolicy) {
        this.authRefreshPolicy = authRefreshPolicy;
    }

    @Override
    public RequestRetryPolicy getRequestRetryPolicy() {
        return this.requestRetryPolicy;
    }

    @Override
    public void setRequestRetryPolicy(RequestRetryPolicy requestRetryPolicy) {
        this.requestRetryPolicy = requestRetryPolicy;
    }

    @Override
    public ClientCachePolicy getClientCachePolicy() {
        return this.clientCachePolicy;
    }

    @Override
    public void setClientCachePolicy(ClientCachePolicy clientCachePolicy) {
        this.clientCachePolicy = clientCachePolicy;
    }

    @Override
    public CacheControlPolicy getCacheControlPolicy() {
        return this.cacheControlPolicy;
    }

    @Override
    public void setCacheControlPolicy(CacheControlPolicy cacheControlPolicy) {
        this.cacheControlPolicy = cacheControlPolicy;
    }

    @Override
    public AutoRedirectPolicy getAutoRedirectPolicy() {
        return this.autoRedirectPolicy;
    }

    @Override
    public void setAutoRedirectPolicy(AutoRedirectPolicy autoRedirectPolicy) {
        this.autoRedirectPolicy = autoRedirectPolicy;
    }

    @Override
    public Map<String, Object> get(UserCredential credential, String id, Map<String, Object> params) throws IOException {
        Map<String, Object> response = null;
        if (!this.httpMethodFilter.isMethodSupported("GET")) {
            throw new UnknownServiceException("Method, GET, not supporeted.");
        }
        response = this.process("GET", credential, null, id, params);
        return response;
    }

    @Override
    public Map<String, Object> post(UserCredential credential, Object inputData) throws IOException {
        Map<String, Object> response = null;
        if (!this.httpMethodFilter.isMethodSupported("POST")) {
            throw new UnknownServiceException("Method, POST, not supporeted.");
        }
        response = this.process("POST", credential, inputData, null, null);
        return response;
    }

    @Override
    public Map<String, Object> put(UserCredential credential, Object inputData, String id) throws IOException {
        Map<String, Object> response = null;
        if (!this.httpMethodFilter.isMethodSupported("PUT")) {
            throw new UnknownServiceException("Method, PUT, not supporeted.");
        }
        response = this.process("PUT", credential, inputData, id, null);
        return response;
    }

    @Override
    public Map<String, Object> patch(UserCredential credential, Object partialData, String id) throws IOException {
        Map<String, Object> response = null;
        if (!this.httpMethodFilter.isMethodSupported("PATCH")) {
            throw new UnknownServiceException("Method, PATCH, not supporeted.");
        }
        response = this.process("PATCH", credential, partialData, id, null);
        return response;
    }

    @Override
    public Map<String, Object> delete(UserCredential credential, String id, Map<String, Object> params) throws IOException {
        Map<String, Object> response = null;
        if (!this.httpMethodFilter.isMethodSupported("DELETE")) {
            throw new UnknownServiceException("Method, DELETE, not supporeted.");
        }
        response = this.process("DELETE", credential, null, id, params);
        return response;
    }

    protected Map<String, Object> process(String method, UserCredential userCredential, Object inputData, String id, Map<String, Object> params) throws IOException {
        return this.process(method, userCredential, inputData, id, params, false);
    }

    protected Map<String, Object> process(String method, UserCredential userCredential, Object inputData, String id, Map<String, Object> params, boolean retrying) throws IOException {
        String endpointUrl = null;
        boolean doOutput = false;
        boolean doInput = false;
        String postData = null;
        switch (method) {
            case "GET": {
                endpointUrl = this.getResourceGetUrl(id, params);
                doOutput = false;
                doInput = true;
                break;
            }
            case "POST": {
                endpointUrl = this.getResourcePostUrl();
                doOutput = true;
                doInput = true;
                break;
            }
            case "PUT": {
                endpointUrl = this.getResourcePutUrl(id);
                doOutput = true;
                doInput = true;
                break;
            }
            case "PATCH": {
                endpointUrl = this.getResourcePatchUrl(id);
                doOutput = true;
                doInput = true;
                break;
            }
            case "DELETE": {
                endpointUrl = this.getResourceDeleteUrl(id, params);
                doOutput = false;
                doInput = true;
                break;
            }
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("postData = " + postData + " for endpointUrl, " + endpointUrl);
        }
        Map<String, Object> response = null;
        try {
            UserCredential refreshedUserCredential;
            String accessToken;
            URL refreshTokenEndpointURL = new URL(endpointUrl);
            HttpURLConnection conn = (HttpURLConnection)refreshTokenEndpointURL.openConnection();
            conn.setRequestMethod(method);
            conn.setConnectTimeout(this.timeoutSeconds * 1000);
            conn.setDoOutput(doOutput);
            conn.setDoInput(doInput);
            conn.setUseCaches(false);
            if (doOutput) {
                String requestContentType = ContentFormat.getCotentType(this.requestFormat);
                if (requestContentType != null) {
                    conn.setRequestProperty("Content-Type", requestContentType);
                } else {
                    log.warning("Invalid requestFormat = " + this.requestFormat);
                }
            }
            if (doInput) {
                String responseContentType = ContentFormat.getCotentType(this.responseFormat);
                if (responseContentType != null) {
                    conn.setRequestProperty("Accept", responseContentType);
                } else {
                    log.warning("Invalid responseFormat = " + this.responseFormat);
                }
            }
            int postContentLength = 0;
            if (doOutput) {
                if (this.requestFormat.equals("JSON")) {
                    try {
                        postData = JsonUtil.buildJson(inputData);
                    }
                    catch (RestApiException e) {
                        log.log(Level.WARNING, "Failed to generate the postData.", e);
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("postData = " + postData);
                    }
                } else if (this.requestFormat.equals("QUERY")) {
                    if (inputData instanceof Map) {
                        try {
                            Map inputParams = (Map)inputData;
                            postData = ResourceUrlUtil.buildQueryString(inputParams);
                        }
                        catch (ClassCastException e) {
                            log.log(Level.WARNING, "Invalid inputData for requestFormat = " + this.requestFormat + "; inputData = " + inputData, e);
                        }
                    } else {
                        log.warning("Invalid inputData for requestFormat = " + this.requestFormat + "; inputData = " + inputData);
                    }
                } else {
                    log.warning("Unsupported requestFormat = " + this.requestFormat);
                }
                if (postData != null) {
                    postContentLength = postData.getBytes("UTF8").length;
                }
            }
            if (userCredential == null) {
                userCredential = this.defaultAuthCredential;
                if (log.isLoggable(Level.INFO)) {
                    log.info("Input credential is null. Default value is used: " + this.defaultAuthCredential);
                }
            }
            if (this.authCredentialRequired && userCredential == null) {
                log.warning("Auth credential required, but credential is not set.");
            }
            if (userCredential != null) {
                boolean authRequired = userCredential.isAuthRequired();
                String authMethod = userCredential.getAuthMethod();
                if (authRequired) {
                    if (authMethod == null || authMethod.equals("None")) {
                        log.warning("Auth required, but no authMethod is set??? Something's wrong!!");
                    } else if (authMethod.equals("Basic")) {
                        String username = userCredential.getAuthToken();
                        String password = userCredential.getAuthSecret();
                        String pair = username + ":" + password;
                        byte[] pairBytes = pair.getBytes();
                        String encodedPair = DatatypeConverter.printBase64Binary((byte[])pairBytes);
                        conn.addRequestProperty("Authorization", "Basic " + encodedPair);
                    } else if (authMethod.equals("Digest")) {
                        log.warning("Unsupported auth method: " + authMethod);
                    } else if (authMethod.equals("TwoLegged") || authMethod.equals("OAuth")) {
                        String consumerKey = null;
                        String consumerSecret = null;
                        if (this.clientCredential != null) {
                            consumerKey = this.clientCredential.getClientKey();
                            consumerSecret = this.clientCredential.getClientSecret();
                        }
                        Object signature = null;
                        String OAuthHeader = null;
                        if (authMethod.equals("TwoLegged")) {
                            log.warning("Unsupported auth method: " + authMethod);
                        } else {
                            accessToken = userCredential.getAuthToken();
                            String tokenSecret = userCredential.getAuthSecret();
                            log.warning("Unsupported auth method: " + authMethod);
                        }
                        if (OAuthHeader != null) {
                            conn.addRequestProperty("Authorization", "OAuth " + OAuthHeader);
                        }
                    } else if (authMethod.equals("Bearer")) {
                        String accessToken2;
                        block124: {
                            accessToken2 = userCredential.getAuthToken();
                            Long tokenExpirationTime = userCredential.getExpirationTime();
                            if (tokenExpirationTime == null) {
                                tokenExpirationTime = 0L;
                            }
                            if (!retrying) {
                                if (this.authRefreshPolicy != null) {
                                    boolean isRefreshBefore = this.authRefreshPolicy.isRefreshBeforeRequest();
                                    if (isRefreshBefore) {
                                        long now = System.currentTimeMillis();
                                        int futureMarginSecs = this.authRefreshPolicy.getFutureMarginSeconds();
                                        long threshhold = now + (long)futureMarginSecs * 1000L;
                                        if (tokenExpirationTime < threshhold) {
                                            if (this.authRefreshPolicy.isPerformable()) {
                                                refreshedUserCredential = null;
                                                try {
                                                    Long refreshedTokenExpirationTime = null;
                                                    refreshedUserCredential = (UserCredential)this.authRefreshPolicy.perform(userCredential);
                                                    if (refreshedUserCredential != null) {
                                                        refreshedTokenExpirationTime = refreshedUserCredential.getExpirationTime();
                                                    } else {
                                                        log.warning("Failed to refresh the user credential.");
                                                    }
                                                    if (refreshedTokenExpirationTime != null && refreshedTokenExpirationTime > tokenExpirationTime) {
                                                        String newAccessToken = null;
                                                        if (refreshedUserCredential != null) {
                                                            newAccessToken = refreshedUserCredential.getAuthToken();
                                                        }
                                                        if (newAccessToken != null && !newAccessToken.isEmpty()) {
                                                            if (log.isLoggable(Level.INFO)) {
                                                                log.info("Access token refreshed. New expiration time = " + refreshedTokenExpirationTime);
                                                            }
                                                            accessToken2 = newAccessToken;
                                                        } else {
                                                            log.warning("User credential refreshed. But, failed to get the new access token.");
                                                        }
                                                        break block124;
                                                    }
                                                    log.info("User credential is not refreshed.");
                                                }
                                                catch (RestApiException e) {
                                                    log.log(Level.WARNING, "Failed to refresh userCredential", e);
                                                }
                                            } else {
                                                log.warning("User Auth refresh required, but authRefreshHandler is not implemented!");
                                            }
                                        } else if (log.isLoggable(Level.INFO)) {
                                            log.info("isRefreshBeforeRequest() == true. But, tokenExpirationTime has not reached: " + tokenExpirationTime);
                                        }
                                    } else {
                                        log.info("User Auth refresh is not required before request.");
                                    }
                                } else {
                                    log.info("authRefreshPolicy is not set.");
                                }
                            } else {
                                log.info("Skipping auth refresh because retrying == true.");
                            }
                        }
                        if (accessToken2 != null) {
                            conn.addRequestProperty("Authorization", "Bearer " + accessToken2);
                        } else {
                            log.warning("Access Token not set!");
                        }
                    } else {
                        log.warning("Unsupported auth method: " + authMethod);
                    }
                } else {
                    log.fine("Auth not required");
                }
            }
            if (doOutput) {
                if (postData != null && !postData.isEmpty()) {
                    conn.setRequestProperty("Content-Length", Integer.toString(postContentLength));
                    DataOutputStream requestOuput = new DataOutputStream(conn.getOutputStream());
                    requestOuput.writeBytes(postData);
                    requestOuput.flush();
                    requestOuput.close();
                }
            } else {
                conn.connect();
            }
            int statusCode = conn.getResponseCode();
            if (log.isLoggable(Level.INFO)) {
                log.info("statusCode = " + statusCode + " for endpointUrl, " + endpointUrl);
            }
            String contentType = conn.getContentType();
            int contentLength = conn.getContentLength();
            String location = conn.getHeaderField("Location");
            Map<String, List<String>> headerFields = conn.getHeaderFields();
            if (ClientDebugHelper.getInstance().isTraceEnabled()) {
                log.info("contentType = " + contentType);
                log.info("contentLength = " + contentLength);
                if (headerFields != null) {
                    for (String key : headerFields.keySet()) {
                        List<String> list = headerFields.get(key);
                        String value = StringUtil.join(list, ",");
                        log.info("header key = " + key + "; value = " + value);
                    }
                }
            }
            String responseContent = null;
            if (doInput) {
                if (StatusCode.isError(statusCode)) {
                    if (log.isLoggable(Level.INFO)) {
                        log.info("Because the status code is error, we are skipping the response parsing for endpointUrl, " + endpointUrl);
                    }
                } else {
                    BufferedReader responseInput = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    String line = null;
                    StringBuilder sb = new StringBuilder();
                    while (null != (line = responseInput.readLine())) {
                        sb.append(line);
                    }
                    responseInput.close();
                    responseContent = sb.toString();
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("content received = " + responseContent + " for endpointUrl, " + endpointUrl);
                    }
                }
            }
            if (StatusCode.isSuccessful(statusCode)) {
                if (doInput) {
                    if (responseContent != null) {
                        Object payload = null;
                        String responseContentFormat = ContentFormat.getContentFormat(contentType);
                        if (responseContentFormat == null) {
                            responseContentFormat = this.responseFormat;
                        }
                        if (responseContentFormat != null) {
                            if (responseContentFormat.equals("JSON")) {
                                try {
                                    payload = JsonUtil.parseJson(responseContent);
                                }
                                catch (RestApiException e) {
                                    log.log(Level.WARNING, "Failed to get the payload.", e);
                                }
                            } else {
                                log.warning("Unsupported response contentType = " + contentType);
                            }
                        } else {
                            log.warning("Failed to parse the response contentType = " + contentType);
                        }
                        response = ResponseUtil.buildResponse(endpointUrl, statusCode, payload, location);
                    } else if (log.isLoggable(Level.INFO)) {
                        log.info("Response expected, but none received for endpointUrl, " + endpointUrl);
                    }
                }
            } else {
                block125: {
                    log.warning("Processing failed: statusCode = " + statusCode + " for endpointUrl, " + endpointUrl);
                    if (StatusCode.isRedirection(statusCode)) {
                        // empty if block
                    }
                    if (statusCode == 401) {
                        if (!retrying) {
                            if (this.authRefreshPolicy != null) {
                                boolean isRefreshIfFails;
                                accessToken = userCredential.getAuthToken();
                                Long tokenExpirationTime = userCredential.getExpirationTime();
                                if (tokenExpirationTime == null) {
                                    tokenExpirationTime = 0L;
                                }
                                if (isRefreshIfFails = this.authRefreshPolicy.isRefreshIfFails()) {
                                    if (this.authRefreshPolicy.isPerformable()) {
                                        try {
                                            Long refreshedTokenExpirationTime = null;
                                            refreshedUserCredential = (UserCredential)this.authRefreshPolicy.perform(userCredential);
                                            if (refreshedUserCredential != null) {
                                                refreshedTokenExpirationTime = refreshedUserCredential.getExpirationTime();
                                            }
                                            if (refreshedTokenExpirationTime != null && refreshedTokenExpirationTime > tokenExpirationTime) {
                                                String newAccessToken = null;
                                                if (refreshedUserCredential != null) {
                                                    newAccessToken = refreshedUserCredential.getAuthToken();
                                                }
                                                if (newAccessToken != null && !newAccessToken.isEmpty()) {
                                                    if (log.isLoggable(Level.INFO)) {
                                                        log.info("Access token refreshed. New expiration time = " + refreshedTokenExpirationTime);
                                                    }
                                                    return this.process(method, userCredential, inputData, id, params, true);
                                                }
                                                log.warning("User credential refreshed. But, failed to get the new access token.");
                                                break block125;
                                            }
                                            log.info("User credential is not refreshed.");
                                        }
                                        catch (RestApiException e) {
                                            log.log(Level.WARNING, "Failed to refresh userCredential", e);
                                        }
                                    } else {
                                        log.warning("User Auth refresh required if fails, but authRefreshHandler is not implemented!");
                                    }
                                } else {
                                    log.info("authRefreshPolicy.isRefreshIfFails() == false");
                                }
                            } else {
                                log.info("authRefreshPolicy is not set.");
                            }
                        } else {
                            log.info("Skipping auth refresh because retrying == true.");
                        }
                    }
                }
                String errorCode = String.valueOf(statusCode);
                String errorMessage = "Processing failed: statusCode = " + statusCode + " for endpointUrl, " + endpointUrl;
                response = ResponseUtil.buildResponse(endpointUrl, statusCode, errorCode, errorMessage);
            }
            conn.disconnect();
        }
        catch (MalformedURLException e) {
            log.log(Level.WARNING, "Bad endpointUrl, " + endpointUrl, e);
            throw e;
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Processing failed for endpointUrl, " + endpointUrl + "; method = " + method, e);
            throw e;
        }
        return response;
    }

    public String toString() {
        return "AbstractRestServiceClient [resourceBaseUrl=" + this.resourceBaseUrl + ", resourceUrlBuilder=" + this.resourceUrlBuilder + ", restServiceClientMaker=" + this.restServiceClientMaker + ", httpMethodFilter=" + this.httpMethodFilter + ", authCredentialRequired=" + this.authCredentialRequired + ", defaultAuthCredential=" + this.defaultAuthCredential + ", clientCredential=" + this.clientCredential + ", dataAccessClient=" + this.dataAccessClient + ", requestFormat=" + this.requestFormat + ", responseFormat=" + this.responseFormat + ", timeoutSeconds=" + this.timeoutSeconds + ", authRefreshPolicy=" + this.authRefreshPolicy + ", requestRetryPolicy=" + this.requestRetryPolicy + ", clientCachePolicy=" + this.clientCachePolicy + ", autoRedirectPolicy=" + this.autoRedirectPolicy + "]";
    }
}

