/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.impl;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import org.miniclient.FlexibleResourceClient;
import org.miniclient.FlexibleUserClient;
import org.miniclient.RestServiceClient;
import org.miniclient.RestUserClient;
import org.miniclient.common.AuthRefreshPolicy;
import org.miniclient.common.AutoRedirectPolicy;
import org.miniclient.common.CacheControlPolicy;
import org.miniclient.common.ClientCachePolicy;
import org.miniclient.common.RequestRetryPolicy;
import org.miniclient.common.ResourceUrlBuilder;
import org.miniclient.credential.UserCredential;
import org.miniclient.maker.RestUserClientMaker;
import org.miniclient.maker.impl.AbstractRestUserClientMaker;

public abstract class AbstractRestUserClient
implements RestUserClient,
FlexibleResourceClient,
FlexibleUserClient,
ResourceUrlBuilder {
    private static final Logger log = Logger.getLogger(AbstractRestUserClient.class.getName());
    private final RestServiceClient restServiceClient;
    private RestUserClientMaker restUserClientMaker = this.makeRestUserClientMaker();
    private UserCredential userCredential;

    public AbstractRestUserClient(String resourceBaseUrl) {
        this(resourceBaseUrl, null);
    }

    public AbstractRestUserClient(String resourceBaseUrl, UserCredential userCredential) {
        this.restServiceClient = this.makeServiceClient(resourceBaseUrl);
        this.userCredential = userCredential;
        this.init();
    }

    public AbstractRestUserClient(RestServiceClient restServiceClient) {
        this(restServiceClient, null);
    }

    public AbstractRestUserClient(RestServiceClient restServiceClient, UserCredential userCredential) {
        this.restServiceClient = restServiceClient;
        this.userCredential = userCredential;
        this.init();
    }

    protected void init() {
    }

    protected RestServiceClient getRestServiceClient() {
        return this.restServiceClient;
    }

    protected FlexibleResourceClient getFlexibleRestServiceClient() {
        return (FlexibleResourceClient)((Object)this.restServiceClient);
    }

    protected RestUserClientMaker makeRestUserClientMaker() {
        return AbstractRestUserClient.createRestUserClientMaker();
    }

    private static RestUserClientMaker createRestUserClientMaker() {
        return AbstractRestUserClientMaker.getInstance();
    }

    protected RestServiceClient makeServiceClient(String resourceBaseUrl) {
        return this.restUserClientMaker.makeServiceClient(resourceBaseUrl);
    }

    @Override
    public boolean isMethodSupported(String methodName) {
        return this.getRestServiceClient().isMethodSupported(methodName);
    }

    @Override
    public String getResourceBaseUrl() {
        return this.getRestServiceClient().getResourceBaseUrl();
    }

    @Override
    public String getResourceGetUrl(String id, Map<String, Object> params) {
        return ((ResourceUrlBuilder)((Object)this.getRestServiceClient())).getResourceGetUrl(id, params);
    }

    @Override
    public String getResourcePostUrl() {
        return ((ResourceUrlBuilder)((Object)this.getRestServiceClient())).getResourcePostUrl();
    }

    @Override
    public String getResourcePutUrl(String id) {
        return ((ResourceUrlBuilder)((Object)this.getRestServiceClient())).getResourcePutUrl(id);
    }

    @Override
    public String getResourcePatchUrl(String id) {
        return ((ResourceUrlBuilder)((Object)this.getRestServiceClient())).getResourcePatchUrl(id);
    }

    @Override
    public String getResourceDeleteUrl(String id, Map<String, Object> params) {
        return ((ResourceUrlBuilder)((Object)this.getRestServiceClient())).getResourceDeleteUrl(id, params);
    }

    @Override
    public AuthRefreshPolicy getAuthRefreshPolicy() {
        return this.getRestServiceClient().getAuthRefreshPolicy();
    }

    @Override
    public void setAuthRefreshPolicy(AuthRefreshPolicy authRefreshPolicy) {
        this.getFlexibleRestServiceClient().setAuthRefreshPolicy(authRefreshPolicy);
    }

    @Override
    public RequestRetryPolicy getRequestRetryPolicy() {
        return this.getRestServiceClient().getRequestRetryPolicy();
    }

    @Override
    public void setRequestRetryPolicy(RequestRetryPolicy requestRetryPolicy) {
        this.getFlexibleRestServiceClient().setRequestRetryPolicy(requestRetryPolicy);
    }

    @Override
    public ClientCachePolicy getClientCachePolicy() {
        return this.getRestServiceClient().getClientCachePolicy();
    }

    @Override
    public void setClientCachePolicy(ClientCachePolicy clientCachePolicy) {
        this.getFlexibleRestServiceClient().setClientCachePolicy(clientCachePolicy);
    }

    @Override
    public CacheControlPolicy getCacheControlPolicy() {
        return this.getRestServiceClient().getCacheControlPolicy();
    }

    @Override
    public void setCacheControlPolicy(CacheControlPolicy cacheControlPolicy) {
        this.getFlexibleRestServiceClient().setCacheControlPolicy(cacheControlPolicy);
    }

    @Override
    public AutoRedirectPolicy getAutoRedirectPolicy() {
        return this.getRestServiceClient().getAutoRedirectPolicy();
    }

    @Override
    public void setAutoRedirectPolicy(AutoRedirectPolicy autoRedirectPolicy) {
        this.getFlexibleRestServiceClient().setAutoRedirectPolicy(autoRedirectPolicy);
    }

    @Override
    public UserCredential getUserCredential() {
        return this.userCredential;
    }

    @Override
    public void setUserCredential(UserCredential userCredential) {
        this.userCredential = userCredential;
    }

    public boolean isAccessAllowed() {
        return this.getRestServiceClient().isAccessAllowed(this.userCredential);
    }

    @Override
    public Map<String, Object> get(String id, Map<String, Object> params) throws IOException {
        return this.getRestServiceClient().get(this.getUserCredential(), id, params);
    }

    @Override
    public Map<String, Object> post(Object inputData) throws IOException {
        return this.getRestServiceClient().post(this.getUserCredential(), inputData);
    }

    @Override
    public Map<String, Object> put(Object inputData, String id) throws IOException {
        return this.getRestServiceClient().put(this.getUserCredential(), inputData, id);
    }

    @Override
    public Map<String, Object> patch(Object partialData, String id) throws IOException {
        return this.getRestServiceClient().patch(this.getUserCredential(), partialData, id);
    }

    @Override
    public Map<String, Object> delete(String id, Map<String, Object> params) throws IOException {
        return this.getRestServiceClient().delete(this.getUserCredential(), id, params);
    }

    public String toString() {
        return "AbstractRestUserClient [restServiceClient=" + this.restServiceClient + ", restUserClientMaker=" + this.restUserClientMaker + ", userCredential=" + this.userCredential + "]";
    }
}

