/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.impl;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniclient.FlexibleUserClient;
import org.miniclient.RestApiException;
import org.miniclient.common.AuthRefreshPolicy;
import org.miniclient.common.UserAuthRefreshHandler;
import org.miniclient.common.impl.AbstractAuthRefreshPolicy;
import org.miniclient.credential.UserCredential;

public abstract class AbstractUserClient
implements FlexibleUserClient,
UserCredential {
    private static final Logger log = Logger.getLogger(AbstractUserClient.class.getName());
    private UserCredential userCredential;
    private final AuthRefreshPolicy authRefreshPolicy;

    public AbstractUserClient() {
        this(null);
    }

    public AbstractUserClient(UserCredential userCredential) {
        this.userCredential = userCredential;
        this.authRefreshPolicy = this.makeAuthRefreshPolicy();
    }

    protected AuthRefreshPolicy makeAuthRefreshPolicy() {
        return new AbstractAuthRefreshPolicy(){};
    }

    public AuthRefreshPolicy getAuthRefreshPolicy() {
        return this.authRefreshPolicy;
    }

    @Override
    public boolean isAuthRequired() {
        return this.getUserCredential().isAuthRequired();
    }

    @Override
    public String getUser() {
        return this.getUserCredential().getUser();
    }

    @Override
    public String getUserId() {
        return this.getUserCredential().getUserId();
    }

    @Override
    public String getAuthMethod() {
        return this.getUserCredential().getAuthMethod();
    }

    @Override
    public String getAuthToken() {
        return this.getUserCredential().getAuthToken();
    }

    @Override
    public String getAuthSecret() {
        return this.getUserCredential().getAuthSecret();
    }

    @Override
    public Set<String> getDataScopes() {
        return this.getUserCredential().getDataScopes();
    }

    @Override
    public boolean containsScope(String scope) {
        return this.getUserCredential().containsScope(scope);
    }

    @Override
    public Long getExpirationTime() {
        return this.getUserCredential().getExpirationTime();
    }

    @Override
    public Long getRefreshedTime() {
        return this.getUserCredential().getRefreshedTime();
    }

    @Override
    public UserCredential getUserCredential() {
        return this.getUserCredential(false);
    }

    public UserCredential getUserCredential(boolean ignoreAuthRefresh) {
        if (!ignoreAuthRefresh) {
            if (this.authRefreshPolicy != null) {
                boolean isRefreshBefore;
                Long tokenExpirationTime = this.userCredential.getExpirationTime();
                if (tokenExpirationTime == null) {
                    tokenExpirationTime = 0L;
                }
                boolean authRefreshHandlerImplemented = false;
                UserAuthRefreshHandler userAuthRefreshHandler = this.authRefreshPolicy.getAuthRefreshHandler();
                if (userAuthRefreshHandler != null) {
                    authRefreshHandlerImplemented = userAuthRefreshHandler.isImeplemented();
                }
                if (isRefreshBefore = this.authRefreshPolicy.isRefreshBeforeRequest()) {
                    long now = System.currentTimeMillis();
                    int futureMarginSecs = this.authRefreshPolicy.getFutureMarginSeconds();
                    long futureMarginMillis = (long)futureMarginSecs * 1000L;
                    long threshhold = now + futureMarginMillis;
                    if (tokenExpirationTime < threshhold) {
                        if (authRefreshHandlerImplemented) {
                            Long refreshedTokenExpirationTime = null;
                            UserCredential refresedhUserCredential = userAuthRefreshHandler.refreshAuthToken(this.userCredential);
                            if (refresedhUserCredential != null) {
                                refreshedTokenExpirationTime = refresedhUserCredential.getExpirationTime();
                            }
                            if (refreshedTokenExpirationTime != null && refreshedTokenExpirationTime > tokenExpirationTime) {
                                String newAccessToken = null;
                                if (refresedhUserCredential != null) {
                                    newAccessToken = refresedhUserCredential.getAuthToken();
                                }
                                if (newAccessToken != null && !newAccessToken.isEmpty()) {
                                    if (log.isLoggable(Level.INFO)) {
                                        log.info("Access token refreshed. New expiration time = " + refreshedTokenExpirationTime);
                                    }
                                    this.userCredential = refresedhUserCredential;
                                } else {
                                    log.warning("User credential refreshed. But, failed to get the new access token.");
                                }
                            } else {
                                log.info("User credential is not refreshed.");
                            }
                        } else {
                            log.warning("User Auth refresh required, but authRefreshHandler is not implemented!");
                        }
                    } else if (log.isLoggable(Level.INFO)) {
                        log.info("authRefreshPolicy.isRefreshBeforeRequest() == true. But, tokenExpirationTime has not reached: " + tokenExpirationTime);
                    }
                } else {
                    log.info("authRefreshPolicy.isRefreshBeforeRequest() == false.");
                }
            } else {
                log.info("authRefreshPolicy is not set.");
            }
        } else {
            log.info("ignoreAuthRefresh == true.");
        }
        return this.userCredential;
    }

    @Override
    public void setUserCredential(UserCredential userCredential) {
        this.userCredential = userCredential;
    }

    public UserCredential refreshUserCredential() {
        try {
            UserCredential refreshedUserCredential;
            this.userCredential = refreshedUserCredential = (UserCredential)this.authRefreshPolicy.perform(this.userCredential);
        }
        catch (RestApiException e) {
            log.log(Level.WARNING, "Failed to refresh ", e);
            return null;
        }
        return this.userCredential;
    }

    public String toString() {
        return "AbstractUserClient [userCredential=" + this.userCredential + ", authRefreshPolicy=" + this.authRefreshPolicy + "]";
    }
}

