/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ResponseUtil {
    private static final Logger log = Logger.getLogger(ResponseUtil.class.getName());
    public static final String KEY_STATUSCODE = "status";
    public static final String KEY_PAYLOAD = "payload";
    public static final String KEY_RESOURCE = "resource";
    public static final String KEY_LOCATION = "location";
    public static final String KEY_ERROR = "error";
    public static final String KEY_ERROR_CODE = "code";
    public static final String KEY_ERROR_MESSAGE = "message";
    public static final String KEY_ERROR_TRACE = "trace";

    private ResponseUtil() {
    }

    public static Map<String, Object> buildResponse(String resource, int statusCode, Object payload) {
        Map<String, Object> response = ResponseUtil.buildResponse(resource, statusCode, payload, null);
        return response;
    }

    public static Map<String, Object> buildResponse(String resource, int statusCode, Object payload, String location) {
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
        if (resource != null) {
            response.put(KEY_RESOURCE, resource);
        }
        response.put(KEY_STATUSCODE, statusCode);
        if (payload != null) {
            response.put(KEY_PAYLOAD, payload);
        }
        if (location != null) {
            response.put(KEY_LOCATION, location);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("response = " + response);
        }
        return response;
    }

    public static Map<String, Object> buildResponse(String resource, int statusCode, String errorCode, String errorMessage) {
        Map<String, Object> response = ResponseUtil.buildResponse(resource, statusCode, errorCode, errorMessage, null);
        return response;
    }

    public static Map<String, Object> buildResponse(String resource, int statusCode, String errorCode, String errorMessage, String errorTrace) {
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
        if (resource != null) {
            response.put(KEY_RESOURCE, resource);
        }
        response.put(KEY_STATUSCODE, statusCode);
        LinkedHashMap<String, String> error = new LinkedHashMap<String, String>();
        error.put(KEY_ERROR_CODE, errorCode);
        if (errorMessage != null) {
            error.put(KEY_ERROR_MESSAGE, errorMessage);
        }
        if (errorTrace != null) {
            error.put(KEY_ERROR_TRACE, errorTrace);
        }
        response.put(KEY_ERROR, error);
        if (log.isLoggable(Level.FINE)) {
            log.fine("response = " + response);
        }
        return response;
    }

    public static int getSatusCude(Map<String, Object> response) {
        Integer val;
        int statusCode = 0;
        if (response != null && response.containsKey(KEY_STATUSCODE) && (val = (Integer)response.get(KEY_STATUSCODE)) != null) {
            statusCode = val;
        }
        if (statusCode == 0) {
            log.warning("Status code is not set.");
        }
        return statusCode;
    }

    public static Map<String, String> getError(Map<String, Object> response) {
        Map error = null;
        if (response != null && response.containsKey(KEY_ERROR)) {
            Object val = response.get(KEY_ERROR);
            if (val instanceof Map) {
                error = (Map)val;
            } else if (log.isLoggable(Level.INFO)) {
                log.info("Invalid error format: error = " + val);
            }
        }
        return error;
    }

    public static Object getPayload(Map<String, Object> response) {
        Object payload = null;
        if (response != null && response.containsKey(KEY_PAYLOAD)) {
            payload = response.get(KEY_PAYLOAD);
        }
        return payload;
    }

    private static final class ResponseBuilder {
        private ResponseBuilder() {
        }

        public ResponseBuilder add(String key, Object value) {
            return this;
        }

        public Map<String, Object> build() {
            return null;
        }
    }
}

