/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.exception;

import java.util.logging.Logger;
import org.miniclient.RestApiException;
import org.miniclient.core.StatusCode;
import org.miniclient.exception.BadRequestRaException;
import org.miniclient.exception.FoundElsewhereRaException;
import org.miniclient.exception.InternalServerErrorRaException;
import org.miniclient.exception.MethodNotAllowedRaException;
import org.miniclient.exception.MovedPermanentlyRaException;
import org.miniclient.exception.MultipleChoiceRaException;
import org.miniclient.exception.NotAcceptableRaException;
import org.miniclient.exception.NotImplementedRaException;
import org.miniclient.exception.RequestConflictRaException;
import org.miniclient.exception.RequestForbiddenRaException;
import org.miniclient.exception.RequestTimeoutRaException;
import org.miniclient.exception.ResourceGoneRaException;
import org.miniclient.exception.ResourceNotFoundRaException;
import org.miniclient.exception.RestApiClientException;
import org.miniclient.exception.RestApiRedirectException;
import org.miniclient.exception.RestApiServerException;
import org.miniclient.exception.ServiceUnavailableRaException;
import org.miniclient.exception.TemporaryRedirectRaException;
import org.miniclient.exception.UnauthorizedRaException;
import org.miniclient.exception.UnsupportedMediaTypeRaException;

public final class StatusExceptionMapper {
    private static final Logger log = Logger.getLogger(StatusExceptionMapper.class.getName());

    private StatusExceptionMapper() {
    }

    public static RestApiException buildException(String message, Throwable cause, String resource, int statusCode, String location) {
        RestApiException exception = null;
        if (StatusCode.isRedirection(statusCode)) {
            exception = statusCode == 300 ? new MultipleChoiceRaException(message, cause, resource, statusCode, location) : (statusCode == 301 ? new MovedPermanentlyRaException(message, cause, resource, statusCode, location) : (statusCode == 302 ? new FoundElsewhereRaException(message, cause, resource, statusCode, location) : (statusCode == 307 ? new TemporaryRedirectRaException(message, cause, resource, statusCode, location) : new RestApiRedirectException(message, cause, resource, statusCode, location))));
        } else if (StatusCode.isError(statusCode)) {
            exception = StatusCode.isClientError(statusCode) ? (statusCode == 400 ? new BadRequestRaException(message, cause, resource, statusCode) : (statusCode == 401 ? new UnauthorizedRaException(message, cause, resource, statusCode) : (statusCode == 403 ? new RequestForbiddenRaException(message, cause, resource, statusCode) : (statusCode == 404 ? new ResourceNotFoundRaException(message, cause, resource, statusCode) : (statusCode == 405 ? new MethodNotAllowedRaException(message, cause, resource, statusCode) : (statusCode == 406 ? new NotAcceptableRaException(message, cause, resource, statusCode) : (statusCode == 408 ? new RequestTimeoutRaException(message, cause, resource, statusCode) : (statusCode == 409 ? new RequestConflictRaException(message, cause, resource, statusCode) : (statusCode == 410 ? new ResourceGoneRaException(message, cause, resource, statusCode) : (statusCode == 415 ? new UnsupportedMediaTypeRaException(message, cause, resource, statusCode) : new RestApiClientException(message, cause, resource, statusCode))))))))))) : (statusCode == 500 ? new InternalServerErrorRaException(message, cause, resource, statusCode) : (statusCode == 501 ? new NotImplementedRaException(message, cause, resource, statusCode) : (statusCode == 503 ? new ServiceUnavailableRaException(message, cause, resource, statusCode) : new RestApiServerException(message, cause, resource, statusCode))));
        }
        return exception;
    }
}

