/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.factory.impl;

import java.util.logging.Logger;
import org.miniclient.ApiServiceClient;
import org.miniclient.ResourceClient;
import org.miniclient.RestServiceClient;
import org.miniclient.common.AuthRefreshPolicy;
import org.miniclient.common.AutoRedirectPolicy;
import org.miniclient.common.CacheControlPolicy;
import org.miniclient.common.ClientCachePolicy;
import org.miniclient.common.CrudMethodFilter;
import org.miniclient.common.DataAccessClient;
import org.miniclient.common.RequestRetryPolicy;
import org.miniclient.factory.ApiServiceClientFactory;
import org.miniclient.factory.ApiUserClientFactory;
import org.miniclient.factory.ClientFactory;
import org.miniclient.factory.impl.AbstractApiUserClientFactory;
import org.miniclient.impl.AbstractApiServiceClient;
import org.miniclient.maker.ApiServiceClientMaker;
import org.miniclient.maker.impl.AbstractApiServiceClientMaker;

public abstract class AbstractApiServiceClientFactory
implements ApiServiceClientFactory,
ClientFactory {
    private static final Logger log = Logger.getLogger(AbstractApiServiceClientFactory.class.getName());
    private ApiServiceClientMaker apiServiceClientMaker = this.makeApiServiceClientMaker();

    protected AbstractApiServiceClientFactory() {
    }

    public static AbstractApiServiceClientFactory getInstance() {
        return AbstractApiServiceClientFactoryHolder.INSTANCE;
    }

    protected ApiServiceClient makeApiServiceClient(String resourceBaseUrl) {
        return new AbstractApiServiceClient(resourceBaseUrl){};
    }

    protected ApiServiceClientMaker makeApiServiceClientMaker() {
        return AbstractApiServiceClientMaker.getInstance();
    }

    protected ApiUserClientFactory makeApiUserClientFactory() {
        return AbstractApiUserClientFactory.getInstance();
    }

    @Override
    public ResourceClient createClient(String resourceBaseUrl) {
        return this.makeApiServiceClient(resourceBaseUrl);
    }

    @Override
    public ApiUserClientFactory createApiUserClientFactory() {
        return this.makeApiUserClientFactory();
    }

    @Override
    public RestServiceClient makeRestClient(String resourceBaseUrl) {
        return this.apiServiceClientMaker.makeRestClient(resourceBaseUrl);
    }

    @Override
    public CrudMethodFilter makeCrudMethodFilter() {
        return this.apiServiceClientMaker.makeCrudMethodFilter();
    }

    @Override
    public DataAccessClient makeDataAccessClient() {
        return this.apiServiceClientMaker.makeDataAccessClient();
    }

    @Override
    public AuthRefreshPolicy makeAuthRefreshPolicy() {
        return this.apiServiceClientMaker.makeAuthRefreshPolicy();
    }

    @Override
    public RequestRetryPolicy makeRequestRetryPolicy() {
        return this.apiServiceClientMaker.makeRequestRetryPolicy();
    }

    @Override
    public ClientCachePolicy makeClientCachePolicy() {
        return this.apiServiceClientMaker.makeClientCachePolicy();
    }

    @Override
    public CacheControlPolicy makeCacheControlPolicy() {
        return this.apiServiceClientMaker.makeCacheControlPolicy();
    }

    @Override
    public AutoRedirectPolicy makeAutoRedirectPolicy() {
        return this.apiServiceClientMaker.makeAutoRedirectPolicy();
    }

    public String toString() {
        return "AbstractApiServiceClientFactory [apiServiceClientMaker=" + this.apiServiceClientMaker + "]";
    }

    private static final class AbstractApiServiceClientFactoryHolder {
        private static final AbstractApiServiceClientFactory INSTANCE = new AbstractApiServiceClientFactory(){};

        private AbstractApiServiceClientFactoryHolder() {
        }
    }
}

