/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.factory.manager;

import java.util.logging.Logger;
import org.miniclient.factory.ApiServiceClientFactory;
import org.miniclient.factory.ApiUserClientFactory;
import org.miniclient.factory.impl.base.DefaultApiServiceClientFactory;

public abstract class AbstractApiClientFactoryManager {
    private static final Logger log = Logger.getLogger(AbstractApiClientFactoryManager.class.getName());
    private ApiServiceClientFactory apiServiceClientFactory = DefaultApiServiceClientFactory.getInstance();
    private ApiUserClientFactory apiUserClientFactory = this.apiServiceClientFactory.createApiUserClientFactory();

    protected AbstractApiClientFactoryManager() {
    }

    public static AbstractApiClientFactoryManager getInstance() {
        return AbstractApiClientFactoryManagerHolder.INSTANCE;
    }

    public ApiServiceClientFactory getApiServiceClientFactory() {
        return this.apiServiceClientFactory;
    }

    public ApiUserClientFactory getApiUserClientFactory() {
        return this.apiUserClientFactory;
    }

    public void setApiClientFactories(ApiServiceClientFactory apiServiceClientFactory) {
        this.setApiClientFactories(apiServiceClientFactory, null);
    }

    public void setApiClientFactories(ApiServiceClientFactory apiServiceClientFactory, ApiUserClientFactory apiUserClientFactory) {
        if (apiServiceClientFactory != null) {
            this.apiServiceClientFactory = apiServiceClientFactory;
            this.apiUserClientFactory = apiUserClientFactory != null ? apiUserClientFactory : apiServiceClientFactory.createApiUserClientFactory();
        } else {
            log.info("Input apiServiceClientFactory is null. Both apiServiceClientFactory and apiUserClientFactory will be ignored.");
        }
    }

    private static final class AbstractApiClientFactoryManagerHolder {
        private static final AbstractApiClientFactoryManager INSTANCE = new AbstractApiClientFactoryManager(){};

        private AbstractApiClientFactoryManagerHolder() {
        }
    }
}

