/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.factory.manager;

import java.util.logging.Logger;
import org.miniclient.factory.RestServiceClientFactory;
import org.miniclient.factory.RestUserClientFactory;
import org.miniclient.factory.impl.base.DefaultRestServiceClientFactory;

public abstract class AbstractRestClientFactoryManager {
    private static final Logger log = Logger.getLogger(AbstractRestClientFactoryManager.class.getName());
    private RestServiceClientFactory restServiceClientFactory = DefaultRestServiceClientFactory.getInstance();
    private RestUserClientFactory restUserClientFactory = this.restServiceClientFactory.createRestUserClientFactory();

    protected AbstractRestClientFactoryManager() {
    }

    public static AbstractRestClientFactoryManager getInstance() {
        return AbstractRestClientFactoryManagerHolder.INSTANCE;
    }

    public RestServiceClientFactory getRestServiceClientFactory() {
        return this.restServiceClientFactory;
    }

    public RestUserClientFactory getRestUserClientFactory() {
        return this.restUserClientFactory;
    }

    public void setRestClientFactories(RestServiceClientFactory restServiceClientFactory) {
        this.setRestClientFactories(restServiceClientFactory, null);
    }

    public void setRestClientFactories(RestServiceClientFactory restServiceClientFactory, RestUserClientFactory restUserClientFactory) {
        if (restServiceClientFactory != null) {
            this.restServiceClientFactory = restServiceClientFactory;
            this.restUserClientFactory = restUserClientFactory != null ? restUserClientFactory : restServiceClientFactory.createRestUserClientFactory();
        } else {
            log.info("Input restServiceClientFactory is null. Both restServiceClientFactory and restUserClientFactory will be ignored.");
        }
    }

    private static final class AbstractRestClientFactoryManagerHolder {
        private static final AbstractRestClientFactoryManager INSTANCE = new AbstractRestClientFactoryManager(){};

        private AbstractRestClientFactoryManagerHolder() {
        }
    }
}

