/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.helper;

import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniclient.util.HashUtil;

public class OAuthHelper {
    private static final Logger log = Logger.getLogger(OAuthHelper.class.getName());
    public static final String OAUTH_VERSION = "1.0";
    private static final String DEFAULT_SIGNATURE_METHOD = "HMAC-SHA1";
    private String signatureMethod = "HMAC-SHA1";

    public static OAuthHelper getInstance() {
        return DebugHelperHolder.INSTANCE;
    }

    private OAuthHelper() {
    }

    public String getSignatureMethod() {
        return this.signatureMethod;
    }

    public void setSignatureMethod(String signatureMethod) {
        this.signatureMethod = signatureMethod;
    }

    public String generateNonce() {
        String nonce = HashUtil.generateSha1Hash(UUID.randomUUID().toString());
        return nonce;
    }

    public String generateOAuthSiganture(String content) {
        if (content == null) {
            return null;
        }
        return null;
    }

    public String generateOAuthHeader(String consumerKey, String accessToken, String content) {
        StringBuilder sb = new StringBuilder();
        sb.append("oauth_consumer_key").append("=").append(consumerKey);
        String nonce = this.generateNonce();
        sb.append("oauth_nonce").append("=").append(nonce);
        String signature = this.generateOAuthSiganture(content);
        sb.append("oauth_signature").append("=").append(signature);
        sb.append("oauth_signature_method").append("=").append(this.signatureMethod);
        long now = System.currentTimeMillis();
        sb.append("oauth_timestamp").append("=").append(now);
        sb.append("oauth_token").append("=").append(accessToken);
        sb.append("oauth_version").append("=").append(OAUTH_VERSION);
        String header = sb.toString();
        if (log.isLoggable(Level.FINE)) {
            log.fine("header = " + header);
        }
        return header;
    }

    private static final class DebugHelperHolder {
        private static final OAuthHelper INSTANCE = new OAuthHelper();

        private DebugHelperHolder() {
        }
    }
}

