/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniclient.common.DataAccessClient;
import org.miniclient.credential.DataAccessCredential;

public abstract class AbstractDataAccessClient
implements DataAccessClient {
    private static final Logger log = Logger.getLogger(AbstractDataAccessClient.class.getName());
    private final Set<String> requiredScopes = new HashSet<String>();

    @Override
    public Set<String> getRequiredScopes() {
        return this.requiredScopes;
    }

    public boolean addRequiredScope(String scope) {
        return this.requiredScopes.add(scope);
    }

    public boolean addRequiredScopes(Collection<String> scopes) {
        return this.requiredScopes.addAll(scopes);
    }

    public boolean setRequiredScopes(Collection<String> scopes) {
        this.requiredScopes.clear();
        return this.requiredScopes.addAll(scopes);
    }

    public boolean removeRequiredScope(String scope) {
        return this.requiredScopes.remove(scope);
    }

    public boolean removeRequiredScopes(Collection<String> scopes) {
        return this.requiredScopes.removeAll(scopes);
    }

    public void clearRequiredScopes() {
        this.requiredScopes.clear();
    }

    @Override
    public boolean requiresScope(String scope) {
        if (scope == null || scope.isEmpty()) {
            return true;
        }
        boolean included = this.requiredScopes.contains(scope);
        if (log.isLoggable(Level.FINER)) {
            log.finer("Is scope, " + scope + ", included? " + included);
        }
        return included;
    }

    @Override
    public boolean isAccessAllowed(DataAccessCredential dataAccessCredential) {
        if (this.requiredScopes.isEmpty()) {
            return true;
        }
        if (dataAccessCredential == null) {
            return false;
        }
        Set<String> credScopes = dataAccessCredential.getDataScopes();
        if (credScopes == null || credScopes.isEmpty()) {
            return false;
        }
        boolean allowed = credScopes.containsAll(this.requiredScopes);
        if (log.isLoggable(Level.FINER)) {
            log.finer("credScopes = " + credScopes + "requiredScopes = " + this.requiredScopes + "; allowed " + allowed);
        }
        return allowed;
    }

    public String toString() {
        return "AbstractDataAccessClient [requiredScopes=" + this.requiredScopes + "]";
    }
}

