/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.core;

import java.util.logging.Level;
import java.util.logging.Logger;

public final class ContentFormat {
    private static final Logger log = Logger.getLogger(ContentFormat.class.getName());
    public static final String TEXT = "TEXT";
    public static final String HTML = "HTML";
    public static final String XML = "XML";
    public static final String JSON = "JSON";
    public static final String QUERY = "QUERY";
    public static final String FORM = "FORM";
    public static final String DEFAULT_CHARSET = "utf-8";

    private ContentFormat() {
    }

    public static boolean isValid(String format) {
        return false;
    }

    public static String getCotentType(String format) {
        return ContentFormat.getCotentType(format, true);
    }

    public static String getCotentType(String format, boolean includeCharset) {
        if (includeCharset) {
            return ContentFormat.getCotentType(format, DEFAULT_CHARSET);
        }
        return ContentFormat.getCotentType(format, null);
    }

    public static String getCotentType(String format, String charset) {
        String contentType = null;
        if (format.equals(TEXT)) {
            contentType = "text/plain";
        } else if (format.equals(HTML)) {
            contentType = "text/html";
        } else if (format.equals(XML)) {
            contentType = "application/xml";
        } else if (format.equals(JSON)) {
            contentType = "application/json";
        } else if (format.equals(QUERY)) {
            contentType = "application/x-www-form-urlencoded";
        } else if (format.equals(FORM)) {
            contentType = "multipart/form-data";
        }
        if (contentType != null && charset != null) {
            contentType = contentType + "; charset=" + charset;
        }
        return contentType;
    }

    public static String getContentFormat(String contentType) {
        if (contentType == null || contentType.isEmpty()) {
            return null;
        }
        if (contentType.startsWith("application/json")) {
            return JSON;
        }
        if (contentType.startsWith("application/xml")) {
            return XML;
        }
        if (contentType.startsWith("text/plain")) {
            return TEXT;
        }
        if (contentType.startsWith("text/html")) {
            return HTML;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Unrecognized contentType = " + contentType);
        }
        return null;
    }
}

