/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.credential.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniclient.credential.UserCredential;

public abstract class AbstractUserCredential
implements UserCredential,
Serializable {
    private static final Logger log = Logger.getLogger(AbstractUserCredential.class.getName());
    private static final long serialVersionUID = 1L;
    private boolean authRequired;
    private String user;
    private String userId;
    private String authMethod;
    private String authToken;
    private String authSecret;
    private Set<String> dataScopes;
    private Long expirationTime;
    private Long refreshedTime;

    public AbstractUserCredential() {
        this(false);
    }

    public AbstractUserCredential(boolean authRequired) {
        this(authRequired, null, null);
    }

    public AbstractUserCredential(boolean authRequired, String user, String userId) {
        this(authRequired, user, userId, null);
    }

    public AbstractUserCredential(boolean authRequired, String user, String userId, String authMethod) {
        this(authRequired, user, userId, authMethod, null, null);
    }

    public AbstractUserCredential(boolean authRequired, String user, String userId, String authMethod, String authToken, String authSecret) {
        this(authRequired, user, userId, authMethod, authToken, authSecret, null);
    }

    public AbstractUserCredential(boolean authRequired, String user, String userId, String authMethod, String authToken, String authSecret, Set<String> dataScopes) {
        this(authRequired, user, userId, authMethod, authToken, authSecret, dataScopes, null, null);
    }

    public AbstractUserCredential(boolean authRequired, String user, String userId, String authMethod, String authToken, String authSecret, Set<String> dataScopes, Long expirationTime, Long refreshedTime) {
        this.authRequired = authRequired;
        this.user = user;
        this.userId = userId;
        this.authMethod = authMethod;
        this.authToken = authToken;
        this.authSecret = authSecret;
        this.dataScopes = dataScopes;
        this.expirationTime = expirationTime;
        this.refreshedTime = refreshedTime;
        this.init();
    }

    protected void init() {
    }

    @Override
    public boolean isAuthRequired() {
        return this.authRequired;
    }

    public void setAuthRequired(boolean authRequired) {
        this.authRequired = authRequired;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    @Override
    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    @Override
    public String getAuthSecret() {
        return this.authSecret;
    }

    public void setAuthSecret(String authSecret) {
        this.authSecret = authSecret;
    }

    @Override
    public Set<String> getDataScopes() {
        return this.dataScopes;
    }

    public void setDataScopes(Set<String> dataScopes) {
        this.dataScopes = dataScopes;
    }

    public boolean addDataScope(String scope) {
        return this.dataScopes.add(scope);
    }

    public boolean addDataScopes(Collection<String> scopes) {
        return this.dataScopes.addAll(scopes);
    }

    public boolean setDataScopes(Collection<String> scopes) {
        this.dataScopes.clear();
        return this.dataScopes.addAll(scopes);
    }

    public boolean removeDataScope(String scope) {
        return this.dataScopes.remove(scope);
    }

    public boolean removeDataScopes(Collection<String> scopes) {
        return this.dataScopes.removeAll(scopes);
    }

    public void clearDataScopes() {
        this.dataScopes.clear();
    }

    @Override
    public boolean containsScope(String scope) {
        if (this.dataScopes == null || this.dataScopes.isEmpty()) {
            return false;
        }
        if (scope == null || scope.isEmpty()) {
            return true;
        }
        boolean included = this.dataScopes.contains(scope);
        if (log.isLoggable(Level.FINER)) {
            log.finer("Is scope, " + scope + ", included? " + included);
        }
        return included;
    }

    public boolean containsAllScopes(Set<String> scopes) {
        if (this.dataScopes == null || this.dataScopes.isEmpty()) {
            return false;
        }
        if (scopes == null || scopes.isEmpty()) {
            return true;
        }
        boolean included = this.dataScopes.containsAll(scopes);
        if (log.isLoggable(Level.FINER)) {
            log.finer("Are all scopes, " + scopes + ", included? " + included);
        }
        return included;
    }

    public boolean containsAnyScope(Set<String> scopes) {
        if (this.dataScopes == null || this.dataScopes.isEmpty()) {
            return false;
        }
        if (scopes == null || scopes.isEmpty()) {
            return true;
        }
        for (String s : scopes) {
            if (!this.dataScopes.contains(s)) continue;
            if (log.isLoggable(Level.FINER)) {
                log.finer("scope, " + s + ", included.");
            }
            return true;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("None of the scopes, " + scopes + ", included.");
        }
        return false;
    }

    @Override
    public Long getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(Long expirationTime) {
        this.expirationTime = expirationTime;
    }

    @Override
    public Long getRefreshedTime() {
        return this.refreshedTime;
    }

    public void setRefreshedTime(Long refreshedTime) {
        this.refreshedTime = refreshedTime;
    }

    public String toString() {
        return "AbstractUserCredential [authRequired=" + this.authRequired + ", user=" + this.user + ", userId=" + this.userId + ", authMethod=" + this.authMethod + ", authToken=" + "..." + ", authSecret=" + "..." + ", dataScopes=" + this.dataScopes + ", expirationTime=" + this.expirationTime + ", refreshedTime=" + this.refreshedTime + "]";
    }
}

