/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.factory.impl;

import java.util.logging.Logger;
import org.miniclient.ResourceClient;
import org.miniclient.RestServiceClient;
import org.miniclient.common.AuthRefreshPolicy;
import org.miniclient.common.AutoRedirectPolicy;
import org.miniclient.common.CacheControlPolicy;
import org.miniclient.common.ClientCachePolicy;
import org.miniclient.common.DataAccessClient;
import org.miniclient.common.HttpMethodFilter;
import org.miniclient.common.RequestRetryPolicy;
import org.miniclient.common.ResourceUrlBuilder;
import org.miniclient.factory.ClientFactory;
import org.miniclient.factory.RestServiceClientFactory;
import org.miniclient.factory.RestUserClientFactory;
import org.miniclient.factory.impl.AbstractRestUserClientFactory;
import org.miniclient.impl.AbstractRestServiceClient;
import org.miniclient.maker.RestServiceClientMaker;
import org.miniclient.maker.impl.AbstractRestServiceClientMaker;

public abstract class AbstractRestServiceClientFactory
implements RestServiceClientFactory,
ClientFactory {
    private static final Logger log = Logger.getLogger(AbstractRestServiceClientFactory.class.getName());
    private RestServiceClientMaker restServiceClientMaker = this.makeRestServiceClientMaker();

    protected AbstractRestServiceClientFactory() {
    }

    public static AbstractRestServiceClientFactory getInstance() {
        return AbstractRestServiceClientFactoryHolder.INSTANCE;
    }

    protected RestServiceClient makeRestServiceClient(String resourceBaseUrl) {
        return new AbstractRestServiceClient(resourceBaseUrl){};
    }

    protected RestServiceClientMaker makeRestServiceClientMaker() {
        return AbstractRestServiceClientMaker.getInstance();
    }

    protected RestUserClientFactory makeRestUserClientFactory() {
        return AbstractRestUserClientFactory.getInstance();
    }

    @Override
    public ResourceClient createClient(String resourceBaseUrl) {
        return this.makeRestServiceClient(resourceBaseUrl);
    }

    @Override
    public RestUserClientFactory createRestUserClientFactory() {
        return this.makeRestUserClientFactory();
    }

    @Override
    public ResourceUrlBuilder makeResourceUrlBuilder(String resourceBaseUrl) {
        return this.restServiceClientMaker.makeResourceUrlBuilder(resourceBaseUrl);
    }

    @Override
    public HttpMethodFilter makeHttpMethodFilter() {
        return this.restServiceClientMaker.makeHttpMethodFilter();
    }

    @Override
    public DataAccessClient makeDataAccessClient() {
        return this.restServiceClientMaker.makeDataAccessClient();
    }

    @Override
    public AuthRefreshPolicy makeAuthRefreshPolicy() {
        return this.restServiceClientMaker.makeAuthRefreshPolicy();
    }

    @Override
    public RequestRetryPolicy makeRequestRetryPolicy() {
        return this.restServiceClientMaker.makeRequestRetryPolicy();
    }

    @Override
    public ClientCachePolicy makeClientCachePolicy() {
        return this.restServiceClientMaker.makeClientCachePolicy();
    }

    @Override
    public CacheControlPolicy makeCacheControlPolicy() {
        return this.restServiceClientMaker.makeCacheControlPolicy();
    }

    @Override
    public AutoRedirectPolicy makeAutoRedirectPolicy() {
        return this.restServiceClientMaker.makeAutoRedirectPolicy();
    }

    public String toString() {
        return "AbstractRestServiceClientFactory [restServiceClientMaker=" + this.restServiceClientMaker + "]";
    }

    private static final class AbstractRestServiceClientFactoryHolder {
        private static final AbstractRestServiceClientFactory INSTANCE = new AbstractRestServiceClientFactory(){};

        private AbstractRestServiceClientFactoryHolder() {
        }
    }
}

