/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import java.util.logging.Logger;

public class CommonUtil {
    private static final Logger log = Logger.getLogger(CommonUtil.class.getName());
    private static Random sRNG = null;

    private static Random getRandom() {
        if (sRNG == null) {
            sRNG = new Random();
        }
        return sRNG;
    }

    private CommonUtil() {
    }

    private static String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }

    public static String MD2(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return CommonUtil.messageDigest(text, "MD2");
    }

    public static String MD5(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return CommonUtil.messageDigest(text, "MD5");
    }

    public static String SHA1(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return CommonUtil.messageDigest(text, "SHA-1");
    }

    public static String SHA256(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return CommonUtil.messageDigest(text, "SHA-256");
    }

    public static String SHA384(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return CommonUtil.messageDigest(text, "SHA-384");
    }

    public static String SHA512(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return CommonUtil.messageDigest(text, "SHA-512");
    }

    public static String messageDigest(String text, String algorithm) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        md.update(text.getBytes("UTF-8"), 0, text.length());
        byte[] sha1hash = md.digest();
        return CommonUtil.convertToHex(sha1hash);
    }
}

