/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.util;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniclient.RestApiException;
import org.miniclient.json.LiteJsonBuilder;
import org.miniclient.json.LiteJsonParser;
import org.miniclient.json.MiniClientJsonException;
import org.miniclient.json.builder.MiniClientJsonBuilder;
import org.miniclient.json.parser.MiniClientJsonParser;

public final class JsonUtil {
    private static final Logger log = Logger.getLogger(JsonUtil.class.getName());
    private static LiteJsonParser sJsonParser = new MiniClientJsonParser();
    private static LiteJsonBuilder sJsonBuilder = new MiniClientJsonBuilder();

    private JsonUtil() {
    }

    public static Object parseJson(String jsonStr) throws RestApiException {
        if (log.isLoggable(Level.FINER)) {
            log.finer("jsonStr = " + jsonStr);
        }
        Object obj = null;
        try {
            obj = sJsonParser.parse(jsonStr);
        }
        catch (MiniClientJsonException e) {
            log.log(Level.WARNING, "Failed to parse the Json string.", e);
            throw new RestApiException("Failed to parse the Json string.", e);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("obj = " + obj);
        }
        return obj;
    }

    public static Object parseJson(Reader reader) throws RestApiException, IOException {
        Object obj = null;
        try {
            obj = sJsonParser.parse(reader);
        }
        catch (MiniClientJsonException e) {
            log.log(Level.WARNING, "Failed to parse the Json string from the reader.", e);
            throw new RestApiException("Failed to parse the Json string from the reader.", e);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("obj = " + obj);
        }
        return obj;
    }

    public static String buildJson(Object jsonObj) throws RestApiException {
        if (log.isLoggable(Level.FINER)) {
            log.finer("jsonObj = " + jsonObj);
        }
        String jsonStr = null;
        try {
            jsonStr = sJsonBuilder.build(jsonObj);
        }
        catch (MiniClientJsonException e) {
            log.log(Level.WARNING, "Failed to build a Json string.", e);
            throw new RestApiException("Failed to build a Json string.", e);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("jsonStr = " + jsonStr);
        }
        return jsonStr;
    }

    public static void buildJson(Writer writer, Object jsonObj) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINER)) {
            log.finer("jsonObj = " + jsonObj);
        }
        try {
            sJsonBuilder.build(writer, jsonObj);
        }
        catch (MiniClientJsonException e) {
            log.log(Level.WARNING, "Failed to build a Json string.", e);
            throw new RestApiException("Failed to build a Json string to writer.", e);
        }
    }
}

