/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.ext.google.factory.mock;

import java.util.logging.Logger;
import org.miniclient.RestServiceClient;
import org.miniclient.RestUserClient;
import org.miniclient.credential.UserCredential;
import org.miniclient.ext.google.GoogleRestUserClient;
import org.miniclient.ext.google.factory.GoogleRestUserClientFactory;
import org.miniclient.ext.google.maker.GoogleRestUserClientMaker;
import org.miniclient.ext.google.mock.MockGoogleRestUserClient;
import org.miniclient.factory.impl.AbstractRestUserClientFactory;
import org.miniclient.maker.RestUserClientMaker;

public class MockGoogleRestUserClientFactory
extends AbstractRestUserClientFactory
implements GoogleRestUserClientFactory {
    private static final Logger log = Logger.getLogger(MockGoogleRestUserClientFactory.class.getName());

    public static MockGoogleRestUserClientFactory getInstance() {
        return GoogleRestUserClientFactoryHolder.INSTANCE;
    }

    protected RestUserClient makeRestUserClient(String resourceBaseUrl) {
        return new MockGoogleRestUserClient(resourceBaseUrl);
    }

    protected RestUserClientMaker makeRestUserClientMaker() {
        return GoogleRestUserClientMaker.getInstance();
    }

    public GoogleRestUserClient createGoogleRestUserClient(String resourceBaseUrl, UserCredential userCredential) {
        return new MockGoogleRestUserClient(resourceBaseUrl, userCredential);
    }

    public GoogleRestUserClient createGoogleRestUserClient(RestServiceClient restServiceClient, UserCredential userCredential) {
        return new MockGoogleRestUserClient(restServiceClient, userCredential);
    }

    public String toString() {
        return "MockGoogleRestUserClientFactory []";
    }

    private static final class GoogleRestUserClientFactoryHolder {
        private static final MockGoogleRestUserClientFactory INSTANCE = new MockGoogleRestUserClientFactory();

        private GoogleRestUserClientFactoryHolder() {
        }
    }
}

