/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.ext.google.mirror.factory.mock;

import java.util.logging.Logger;
import org.miniclient.ApiServiceClient;
import org.miniclient.ApiUserClient;
import org.miniclient.credential.UserCredential;
import org.miniclient.ext.google.factory.mock.MockGoogleApiUserClientFactory;
import org.miniclient.ext.google.mirror.MirrorApiServiceClient;
import org.miniclient.ext.google.mirror.MirrorApiUserClient;
import org.miniclient.ext.google.mirror.factory.MirrorApiUserClientFactory;
import org.miniclient.ext.google.mirror.maker.mock.MockMirrorApiUserClientMaker;
import org.miniclient.ext.google.mirror.mock.MockMirrorApiUserClient;
import org.miniclient.ext.google.mirror.resource.mock.MockMirrorContactApiUserClient;
import org.miniclient.ext.google.mirror.resource.mock.MockMirrorLocationApiUserClient;
import org.miniclient.ext.google.mirror.resource.mock.MockMirrorSubscriptionApiUserClient;
import org.miniclient.ext.google.mirror.resource.mock.MockMirrorTimelineApiUserClient;
import org.miniclient.ext.google.mirror.resource.mock.MockMirrorTimelineAttachmentApiUserClient;
import org.miniclient.maker.ApiUserClientMaker;

public class MockMirrorApiUserClientFactory
extends MockGoogleApiUserClientFactory
implements MirrorApiUserClientFactory {
    private static final Logger log = Logger.getLogger(MockMirrorApiUserClientFactory.class.getName());

    public static MockMirrorApiUserClientFactory getInstance() {
        return MirrorMockApiUserClientFactoryHolder.INSTANCE;
    }

    @Override
    protected ApiUserClient makeApiUserClient(String resourceBaseUrl) {
        return new MockMirrorApiUserClient(resourceBaseUrl);
    }

    @Override
    protected ApiUserClientMaker makeApiUserClientMaker() {
        return MockMirrorApiUserClientMaker.getInstance();
    }

    public MirrorApiUserClient createMirrorContactApiUserClient(UserCredential userCredential) {
        return new MockMirrorContactApiUserClient(userCredential);
    }

    public MirrorApiUserClient createMirrorLocationApiUserClient(UserCredential userCredential) {
        return new MockMirrorLocationApiUserClient(userCredential);
    }

    public MirrorApiUserClient createMirrorSubscriptionApiUserClient(UserCredential userCredential) {
        return new MockMirrorSubscriptionApiUserClient(userCredential);
    }

    public MirrorApiUserClient createMirrorTimelineApiUserClient(UserCredential userCredential) {
        return new MockMirrorTimelineApiUserClient(userCredential);
    }

    public MirrorApiUserClient createMirrorTimelineAttachmentApiUserClient(String timelineItemId, UserCredential userCredential) {
        return new MockMirrorTimelineAttachmentApiUserClient(timelineItemId, userCredential);
    }

    public MirrorApiUserClient createMirrorContactApiUserClient(MirrorApiServiceClient serviceClient, UserCredential userCredential) {
        return new MockMirrorContactApiUserClient((ApiServiceClient)serviceClient, userCredential);
    }

    public MirrorApiUserClient createMirrorLocationApiUserClient(MirrorApiServiceClient serviceClient, UserCredential userCredential) {
        return new MockMirrorLocationApiUserClient((ApiServiceClient)serviceClient, userCredential);
    }

    public MirrorApiUserClient createMirrorSubscriptionApiUserClient(MirrorApiServiceClient serviceClient, UserCredential userCredential) {
        return new MockMirrorSubscriptionApiUserClient((ApiServiceClient)serviceClient, userCredential);
    }

    public MirrorApiUserClient createMirrorTimelineApiUserClient(MirrorApiServiceClient serviceClient, UserCredential userCredential) {
        return new MockMirrorTimelineApiUserClient((ApiServiceClient)serviceClient, userCredential);
    }

    public MirrorApiUserClient createMirrorTimelineAttachmentApiUserClient(MirrorApiServiceClient serviceClient, UserCredential userCredential) {
        return new MockMirrorTimelineAttachmentApiUserClient((ApiServiceClient)serviceClient, userCredential);
    }

    @Override
    public String toString() {
        return "MockMirrorApiUserClientFactory []";
    }

    private static final class MirrorMockApiUserClientFactoryHolder {
        private static final MockMirrorApiUserClientFactory INSTANCE = new MockMirrorApiUserClientFactory();

        private MirrorMockApiUserClientFactoryHolder() {
        }
    }
}

