/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.ext.google.mirror.mock;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniclient.ApiServiceClient;
import org.miniclient.RestApiException;
import org.miniclient.credential.UserCredential;
import org.miniclient.ext.google.mirror.maker.mock.MockMirrorApiUserClientMaker;
import org.miniclient.ext.google.mirror.proxy.DecoratedMirrorApiUserClient;
import org.miniclient.ext.google.mock.MockGoogleApiUserClient;
import org.miniclient.maker.ApiUserClientMaker;

public class MockMirrorApiUserClient
extends MockGoogleApiUserClient
implements DecoratedMirrorApiUserClient,
Serializable {
    private static final Logger log = Logger.getLogger(MockMirrorApiUserClient.class.getName());
    private static final long serialVersionUID = 1L;
    private final MockGoogleApiUserClient decoratedClient;

    public MockMirrorApiUserClient(String resourceBaseUrl) {
        this(resourceBaseUrl, null);
    }

    public MockMirrorApiUserClient(String resourceBaseUrl, UserCredential userCredential) {
        super(resourceBaseUrl, userCredential);
        this.decoratedClient = null;
    }

    public MockMirrorApiUserClient(ApiServiceClient apiServiceClient) {
        this(apiServiceClient, null);
    }

    public MockMirrorApiUserClient(ApiServiceClient apiServiceClient, UserCredential userCredential) {
        super(apiServiceClient, userCredential);
        this.decoratedClient = null;
    }

    public MockMirrorApiUserClient(MockGoogleApiUserClient decoratedClient) {
        super((String)null);
        this.decoratedClient = decoratedClient;
    }

    @Override
    protected ApiUserClientMaker makeApiUserClientMaker() {
        return MockMirrorApiUserClientMaker.getInstance();
    }

    @Override
    public Object get(String id) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockMirrorApiUserClient.get(): id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.get(id);
        }
        return super.get(id);
    }

    @Override
    public List<Object> list(Map<String, Object> params) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockMirrorApiUserClient.list(): params = " + params);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.list(params);
        }
        return super.list(params);
    }

    @Override
    public List<String> keys(Map<String, Object> params) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockMirrorApiUserClient.keys(): params = " + params);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.keys(params);
        }
        return super.keys(params);
    }

    @Override
    public Object create(Object inputData) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockMirrorApiUserClient.create(): inputData = " + inputData);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.create(inputData);
        }
        return super.create(inputData);
    }

    @Override
    public Object create(Object inputData, String id) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockMirrorApiUserClient.create(): inputData = " + inputData + "; id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.create(inputData, id);
        }
        return super.create(inputData, id);
    }

    @Override
    public Object update(Object inputData, String id) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockMirrorApiUserClient.update(): inputData = " + inputData + "; id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.update(inputData, id);
        }
        return super.update(inputData, id);
    }

    @Override
    public Object modify(Object partialData, String id) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockMirrorApiUserClient.modify(): partialData = " + partialData + "; id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.modify(partialData, id);
        }
        return super.modify(partialData, id);
    }

    @Override
    public boolean delete(String id) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockMirrorApiUserClient.delete(): id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.delete(id);
        }
        return super.delete(id);
    }

    @Override
    public int delete(Map<String, Object> params) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockMirrorApiUserClient.delete(): params = " + params);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.delete(params);
        }
        return super.delete(params);
    }

    @Override
    public String toString() {
        return "MockMirrorApiUserClient [decoratedClient=" + this.decoratedClient + ", getApiServiceClient()=" + this.getApiServiceClient() + ", getUserCredential()=" + this.getUserCredential() + ", isAccessAllowed()=" + this.isAccessAllowed() + ", getResourceBaseUrl()=" + this.getResourceBaseUrl() + ", getRestServiceAuthRefreshPolicy()=" + this.getRestServiceAuthRefreshPolicy() + ", getRestServiceRequestRetryPolicy()=" + this.getRestServiceRequestRetryPolicy() + ", getRestServiceClientCachePolicy()=" + this.getRestServiceClientCachePolicy() + ", getRestServiceAutoRedirectPolicy()=" + this.getRestServiceAutoRedirectPolicy() + ", getAuthRefreshPolicy()=" + this.getAuthRefreshPolicy() + ", getRequestRetryPolicy()=" + this.getRequestRetryPolicy() + ", getClientCachePolicy()=" + this.getClientCachePolicy() + ", getAutoRedirectPolicy()=" + this.getAutoRedirectPolicy() + "]";
    }
}

