/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.ext.google.mock;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniclient.credential.UserCredential;
import org.miniclient.credential.impl.AbstractUserCredential;
import org.miniclient.ext.google.maker.mock.MockGoogleRestServiceClientMaker;
import org.miniclient.ext.google.proxy.DecoratedGoogleRestServiceClient;
import org.miniclient.maker.RestServiceClientMaker;
import org.miniclient.mock.MockRestServiceClient;

public class MockGoogleRestServiceClient
extends MockRestServiceClient
implements DecoratedGoogleRestServiceClient,
Serializable {
    private static final Logger log = Logger.getLogger(MockGoogleRestServiceClient.class.getName());
    private static final long serialVersionUID = 1L;
    private final MockRestServiceClient decoratedClient;

    public MockGoogleRestServiceClient(MockRestServiceClient decoratedClient) {
        this(decoratedClient, decoratedClient != null ? decoratedClient.getResourceBaseUrl() : null);
    }

    public MockGoogleRestServiceClient(String resourceBaseUrl) {
        this(null, resourceBaseUrl);
    }

    private MockGoogleRestServiceClient(MockRestServiceClient decoratedClient, String resourceBaseUrl) {
        super(resourceBaseUrl);
        this.decoratedClient = decoratedClient;
    }

    protected void init() {
        super.init();
        this.setAuthCredentialRequired(false);
        super.setDefaultAuthCredential((UserCredential)new AbstractUserCredential(){});
        this.setRequestFormat("JSON");
        this.setResponseFormat("JSON");
        this.setTimeoutSeconds(10);
    }

    protected RestServiceClientMaker makeRestServiceClientMaker() {
        return MockGoogleRestServiceClientMaker.getInstance();
    }

    public Map<String, Object> get(UserCredential credential, String id, Map<String, Object> params) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockGoogleRestServiceClient.get(): credential = " + credential + "; id = " + id + "; params = " + params);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.get(credential, id, params);
        }
        return super.get(credential, id, params);
    }

    public Map<String, Object> post(UserCredential credential, Object inputData) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockGoogleRestServiceClient.post(): credential = " + credential + "; inputData = " + inputData);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.post(credential, inputData);
        }
        return super.post(credential, inputData);
    }

    public Map<String, Object> put(UserCredential credential, Object inputData, String id) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockGoogleRestServiceClient.put(): credential = " + credential + "; inputData = " + inputData + "; id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.put(credential, inputData, id);
        }
        return super.put(credential, inputData, id);
    }

    public Map<String, Object> patch(UserCredential credential, Object partialData, String id) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockGoogleRestServiceClient.patch(): credential = " + credential + "; partialData = " + partialData + "; id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.patch(credential, partialData, id);
        }
        return super.patch(credential, partialData, id);
    }

    public Map<String, Object> delete(UserCredential credential, String id, Map<String, Object> params) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockGoogleRestServiceClient.delete(): credential = " + credential + "; id = " + id + "; params = " + params);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.delete(credential, id, params);
        }
        return super.delete(credential, id, params);
    }

    public String toString() {
        return "MockGoogleRestServiceClient [decoratedClient=" + this.decoratedClient + ", getResourceUrlBuilder()=" + this.getResourceUrlBuilder() + ", getHttpMethodFilter()=" + this.getHttpMethodFilter() + ", getResourceBaseUrl()=" + this.getResourceBaseUrl() + ", getResourcePostUrl()=" + this.getResourcePostUrl() + ", isAuthCredentialRequired()=" + this.isAuthCredentialRequired() + ", getDefaultAuthCredential()=" + this.getDefaultAuthCredential() + ", getClientCredential()=" + this.getClientCredential() + ", getRequiredScopes()=" + this.getRequiredScopes() + ", getRequestFormat()=" + this.getRequestFormat() + ", getResponseFormat()=" + this.getResponseFormat() + ", getTimeoutSeconds()=" + this.getTimeoutSeconds() + ", getAuthRefreshPolicy()=" + this.getAuthRefreshPolicy() + ", getRequestRetryPolicy()=" + this.getRequestRetryPolicy() + ", getClientCachePolicy()=" + this.getClientCachePolicy() + ", getAutoRedirectPolicy()=" + this.getAutoRedirectPolicy() + "]";
    }
}

