/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.ext.google.mirror.mock;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniclient.RestApiException;
import org.miniclient.core.ListResponseType;
import org.miniclient.credential.UserCredential;
import org.miniclient.ext.google.mirror.maker.mock.MockMirrorApiServiceClientMaker;
import org.miniclient.ext.google.mirror.proxy.DecoratedMirrorApiServiceClient;
import org.miniclient.ext.google.mock.MockGoogleApiServiceClient;
import org.miniclient.maker.ApiServiceClientMaker;

public class MockMirrorApiServiceClient
extends MockGoogleApiServiceClient
implements DecoratedMirrorApiServiceClient,
Serializable {
    private static final Logger log = Logger.getLogger(MockMirrorApiServiceClient.class.getName());
    private static final long serialVersionUID = 1L;
    private final MockGoogleApiServiceClient decoratedClient;

    public MockMirrorApiServiceClient(MockGoogleApiServiceClient decoratedClient) {
        this(decoratedClient, decoratedClient != null ? decoratedClient.getResourceBaseUrl() : null);
    }

    public MockMirrorApiServiceClient(String resourceBaseUrl) {
        this(null, resourceBaseUrl);
    }

    private MockMirrorApiServiceClient(MockGoogleApiServiceClient decoratedClient, String resourceBaseUrl) {
        super(resourceBaseUrl);
        this.decoratedClient = decoratedClient;
    }

    @Override
    protected void init() {
        super.init();
        this.setListResponseType(ListResponseType.MAP_ITEMS);
    }

    @Override
    protected ApiServiceClientMaker makeApiServiceClientMaker() {
        return MockMirrorApiServiceClientMaker.getInstance();
    }

    @Override
    public Object get(UserCredential credential, String id) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockMirrorApiServiceClient.get(): credential = " + credential + "; id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.get(credential, id);
        }
        return super.get(credential, id);
    }

    @Override
    public List<Object> list(UserCredential credential, Map<String, Object> params) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockMirrorApiServiceClient.list(): credential = " + credential + "; params = " + params);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.list(credential, params);
        }
        return super.list(credential, params);
    }

    @Override
    public List<String> keys(UserCredential credential, Map<String, Object> params) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockMirrorApiServiceClient.keys(): credential = " + credential + "; params = " + params);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.keys(credential, params);
        }
        return super.keys(credential, params);
    }

    @Override
    public Object create(UserCredential credential, Object inputData) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockMirrorApiServiceClient.create(): credential = " + credential + "; inputData = " + inputData);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.create(credential, inputData);
        }
        return super.create(credential, inputData);
    }

    @Override
    public Object create(UserCredential credential, Object inputData, String id) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockMirrorApiServiceClient.create(): credential = " + credential + "; inputData = " + inputData + "; id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.create(credential, inputData, id);
        }
        return super.create(credential, inputData, id);
    }

    @Override
    public Object update(UserCredential credential, Object inputData, String id) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockMirrorApiServiceClient.update(): credential = " + credential + "; inputData = " + inputData + "; id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.update(credential, inputData, id);
        }
        return super.update(credential, inputData, id);
    }

    @Override
    public Object modify(UserCredential credential, Object partialData, String id) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockMirrorApiServiceClient.modify(): credential = " + credential + "; partialData = " + partialData + "; id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.modify(credential, partialData, id);
        }
        return super.modify(credential, partialData, id);
    }

    @Override
    public boolean delete(UserCredential credential, String id) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockMirrorApiServiceClient.delete(): credential = " + credential + "; id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.delete(credential, id);
        }
        return super.delete(credential, id);
    }

    @Override
    public int delete(UserCredential credential, Map<String, Object> params) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockMirrorApiServiceClient.delete(): credential = " + credential + "; params = " + params);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.delete(credential, params);
        }
        return super.delete(credential, params);
    }

    @Override
    public String toString() {
        return "MockMirrorApiServiceClient [decoratedClient=" + this.decoratedClient + ", getRestServiceClient()=" + this.getRestServiceClient() + ", getCrudMethodFilter()=" + this.getCrudMethodFilter() + ", getListResponseType()=" + this.getListResponseType() + ", getResourceBaseUrl()=" + this.getResourceBaseUrl() + ", getClientCredential()=" + this.getClientCredential() + ", getRestServiceAuthRefreshPolicy()=" + this.getRestServiceAuthRefreshPolicy() + ", getRestServiceRequestRetryPolicy()=" + this.getRestServiceRequestRetryPolicy() + ", getRestServiceClientCachePolicy()=" + this.getRestServiceClientCachePolicy() + ", getRestServiceAutoRedirectPolicy()=" + this.getRestServiceAutoRedirectPolicy() + ", getRequiredScopes()=" + this.getRequiredScopes() + ", getAutoRedirectPolicy()=" + this.getAutoRedirectPolicy() + ", getAuthRefreshPolicy()=" + this.getAuthRefreshPolicy() + ", getRequestRetryPolicy()=" + this.getRequestRetryPolicy() + ", getClientCachePolicy()=" + this.getClientCachePolicy() + "]";
    }
}

