/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.ext.google.mock;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniclient.ApiServiceClient;
import org.miniclient.RestApiException;
import org.miniclient.credential.UserCredential;
import org.miniclient.ext.google.maker.mock.MockGoogleApiUserClientMaker;
import org.miniclient.ext.google.proxy.DecoratedGoogleApiUserClient;
import org.miniclient.maker.ApiUserClientMaker;
import org.miniclient.mock.MockApiUserClient;

public class MockGoogleApiUserClient
extends MockApiUserClient
implements DecoratedGoogleApiUserClient,
Serializable {
    private static final Logger log = Logger.getLogger(MockGoogleApiUserClient.class.getName());
    private static final long serialVersionUID = 1L;
    private final MockApiUserClient decoratedClient;

    public MockGoogleApiUserClient(String resourceBaseUrl) {
        this(resourceBaseUrl, null);
    }

    public MockGoogleApiUserClient(String resourceBaseUrl, UserCredential userCredential) {
        super(resourceBaseUrl, userCredential);
        this.decoratedClient = null;
    }

    public MockGoogleApiUserClient(ApiServiceClient apiServiceClient) {
        this(apiServiceClient, null);
    }

    public MockGoogleApiUserClient(ApiServiceClient apiServiceClient, UserCredential userCredential) {
        super(apiServiceClient, userCredential);
        this.decoratedClient = null;
    }

    public MockGoogleApiUserClient(MockApiUserClient decoratedClient) {
        super((String)null);
        this.decoratedClient = decoratedClient;
    }

    protected ApiUserClientMaker makeApiUserClientMaker() {
        return MockGoogleApiUserClientMaker.getInstance();
    }

    public Object get(String id) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockGoogleApiUserClient.get(): id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.get(id);
        }
        return super.get(id);
    }

    public List<Object> list(Map<String, Object> params) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockGoogleApiUserClient.list(): params = " + params);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.list(params);
        }
        return super.list(params);
    }

    public List<String> keys(Map<String, Object> params) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockGoogleApiUserClient.keys(): params = " + params);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.keys(params);
        }
        return super.keys(params);
    }

    public Object create(Object inputData) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockGoogleApiUserClient.create(): inputData = " + inputData);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.create(inputData);
        }
        return super.create(inputData);
    }

    public Object create(Object inputData, String id) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockGoogleApiUserClient.create(): inputData = " + inputData + "; id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.create(inputData, id);
        }
        return super.create(inputData, id);
    }

    public Object update(Object inputData, String id) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockGoogleApiUserClient.update(): inputData = " + inputData + "; id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.update(inputData, id);
        }
        return super.update(inputData, id);
    }

    public Object modify(Object partialData, String id) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockGoogleApiUserClient.modify(): partialData = " + partialData + "; id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.modify(partialData, id);
        }
        return super.modify(partialData, id);
    }

    public boolean delete(String id) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockGoogleApiUserClient.delete(): id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.delete(id);
        }
        return super.delete(id);
    }

    public int delete(Map<String, Object> params) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockGoogleApiUserClient.delete(): params = " + params);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.delete(params);
        }
        return super.delete(params);
    }

    public String toString() {
        return "MockGoogleApiUserClient [decoratedClient=" + this.decoratedClient + ", getApiServiceClient()=" + this.getApiServiceClient() + ", getUserCredential()=" + this.getUserCredential() + ", isAccessAllowed()=" + this.isAccessAllowed() + ", getResourceBaseUrl()=" + this.getResourceBaseUrl() + ", getRestServiceAuthRefreshPolicy()=" + this.getRestServiceAuthRefreshPolicy() + ", getRestServiceRequestRetryPolicy()=" + this.getRestServiceRequestRetryPolicy() + ", getRestServiceClientCachePolicy()=" + this.getRestServiceClientCachePolicy() + ", getRestServiceAutoRedirectPolicy()=" + this.getRestServiceAutoRedirectPolicy() + ", getAuthRefreshPolicy()=" + this.getAuthRefreshPolicy() + ", getRequestRetryPolicy()=" + this.getRequestRetryPolicy() + ", getClientCachePolicy()=" + this.getClientCachePolicy() + ", getAutoRedirectPolicy()=" + this.getAutoRedirectPolicy() + "]";
    }
}

