/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.ext.google.factory.impl;

import java.util.logging.Logger;
import org.miniclient.ApiServiceClient;
import org.miniclient.ResourceClient;
import org.miniclient.ext.google.GoogleApiServiceClient;
import org.miniclient.ext.google.factory.GoogleApiServiceClientFactory;
import org.miniclient.ext.google.factory.GoogleApiUserClientFactory;
import org.miniclient.ext.google.factory.impl.BaseGoogleApiUserClientFactory;
import org.miniclient.ext.google.impl.BaseGoogleApiServiceClient;
import org.miniclient.ext.google.maker.GoogleApiServiceClientMaker;
import org.miniclient.factory.ApiUserClientFactory;
import org.miniclient.factory.impl.AbstractApiServiceClientFactory;
import org.miniclient.maker.ApiServiceClientMaker;

public class BaseGoogleApiServiceClientFactory
extends AbstractApiServiceClientFactory
implements GoogleApiServiceClientFactory {
    private static final Logger log = Logger.getLogger(BaseGoogleApiServiceClientFactory.class.getName());

    public static BaseGoogleApiServiceClientFactory getInstance() {
        return GoogleApiServiceClientFactoryHolder.INSTANCE;
    }

    protected ApiServiceClient makeApiServiceClient(String resourceBaseUrl) {
        return new BaseGoogleApiServiceClient(resourceBaseUrl);
    }

    protected ApiServiceClientMaker makeApiServiceClientMaker() {
        return GoogleApiServiceClientMaker.getInstance();
    }

    protected ApiUserClientFactory makeApiUserClientFactory() {
        return this.makeGoogleApiUserClientFactory();
    }

    protected GoogleApiUserClientFactory makeGoogleApiUserClientFactory() {
        return BaseGoogleApiUserClientFactory.getInstance();
    }

    @Override
    public GoogleApiServiceClient createGoogleApiServiceClient(String resourceBaseUrl) {
        return new BaseGoogleApiServiceClient(resourceBaseUrl);
    }

    public ResourceClient createClient(String resourceBaseUrl) {
        return this.makeApiServiceClient(resourceBaseUrl);
    }

    public String toString() {
        return "BaseGoogleApiServiceClientFactory []";
    }

    private static final class GoogleApiServiceClientFactoryHolder {
        private static final BaseGoogleApiServiceClientFactory INSTANCE = new BaseGoogleApiServiceClientFactory();

        private GoogleApiServiceClientFactoryHolder() {
        }
    }
}

