/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.ext.google.factory.manager;

import java.util.logging.Logger;
import org.miniclient.ext.google.factory.GoogleApiServiceClientFactory;
import org.miniclient.ext.google.factory.GoogleApiUserClientFactory;
import org.miniclient.ext.google.factory.impl.BaseGoogleApiServiceClientFactory;

public abstract class AbstractGoogleApiClientFactoryManager {
    private static final Logger log = Logger.getLogger(AbstractGoogleApiClientFactoryManager.class.getName());
    private GoogleApiServiceClientFactory googleApiServiceClientFactory = BaseGoogleApiServiceClientFactory.getInstance();
    private GoogleApiUserClientFactory googleApiUserClientFactory = (GoogleApiUserClientFactory)this.googleApiServiceClientFactory.createApiUserClientFactory();

    protected AbstractGoogleApiClientFactoryManager() {
    }

    public static AbstractGoogleApiClientFactoryManager getInstance() {
        return AbstractGoogleApiClientFactoryManagerHolder.INSTANCE;
    }

    public GoogleApiServiceClientFactory getGoogleApiServiceClientFactory() {
        return this.googleApiServiceClientFactory;
    }

    public GoogleApiUserClientFactory getGoogleApiUserClientFactory() {
        return this.googleApiUserClientFactory;
    }

    public void setGoogleApiClientFactories(GoogleApiServiceClientFactory googleApiServiceClientFactory) {
        this.setGoogleApiClientFactories(googleApiServiceClientFactory, null);
    }

    public void setGoogleApiClientFactories(GoogleApiServiceClientFactory googleApiServiceClientFactory, GoogleApiUserClientFactory googleApiUserClientFactory) {
        if (googleApiServiceClientFactory != null) {
            this.googleApiServiceClientFactory = googleApiServiceClientFactory;
            this.googleApiUserClientFactory = googleApiUserClientFactory != null ? googleApiUserClientFactory : (GoogleApiUserClientFactory)googleApiServiceClientFactory.createApiUserClientFactory();
        } else {
            log.info("Input googleApiServiceClientFactory is null. Both googleApiServiceClientFactory and googleApiUserClientFactory will be ignored.");
        }
    }

    private static final class AbstractGoogleApiClientFactoryManagerHolder {
        private static final AbstractGoogleApiClientFactoryManager INSTANCE = new AbstractGoogleApiClientFactoryManager(){};

        private AbstractGoogleApiClientFactoryManagerHolder() {
        }
    }
}

