/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.ext.google.factory.manager;

import java.util.logging.Logger;
import org.miniclient.ext.google.factory.GoogleRestServiceClientFactory;
import org.miniclient.ext.google.factory.GoogleRestUserClientFactory;
import org.miniclient.ext.google.factory.impl.BaseGoogleRestServiceClientFactory;

public abstract class AbstractGoogleRestClientFactoryManager {
    private static final Logger log = Logger.getLogger(AbstractGoogleRestClientFactoryManager.class.getName());
    private GoogleRestServiceClientFactory googleRestServiceClientFactory = BaseGoogleRestServiceClientFactory.getInstance();
    private GoogleRestUserClientFactory googleRestUserClientFactory = (GoogleRestUserClientFactory)this.googleRestServiceClientFactory.createRestUserClientFactory();

    protected AbstractGoogleRestClientFactoryManager() {
    }

    public static AbstractGoogleRestClientFactoryManager getInstance() {
        return AbstractGoogleRestClientFactoryManagerHolder.INSTANCE;
    }

    public GoogleRestServiceClientFactory getGoogleRestServiceClientFactory() {
        return this.googleRestServiceClientFactory;
    }

    public GoogleRestUserClientFactory getGoogleRestUserClientFactory() {
        return this.googleRestUserClientFactory;
    }

    public void setGoogleRestClientFactories(GoogleRestServiceClientFactory googleRestServiceClientFactory) {
        this.setGoogleRestClientFactories(googleRestServiceClientFactory, null);
    }

    public void setGoogleRestClientFactories(GoogleRestServiceClientFactory googleRestServiceClientFactory, GoogleRestUserClientFactory googleRestUserClientFactory) {
        if (googleRestServiceClientFactory != null) {
            this.googleRestServiceClientFactory = googleRestServiceClientFactory;
            this.googleRestUserClientFactory = googleRestUserClientFactory != null ? googleRestUserClientFactory : (GoogleRestUserClientFactory)googleRestServiceClientFactory.createRestUserClientFactory();
        } else {
            log.info("Input googleRestServiceClientFactory is null. Both googleRestServiceClientFactory and googleRestUserClientFactory will be ignored.");
        }
    }

    private static final class AbstractGoogleRestClientFactoryManagerHolder {
        private static final AbstractGoogleRestClientFactoryManager INSTANCE = new AbstractGoogleRestClientFactoryManager(){};

        private AbstractGoogleRestClientFactoryManagerHolder() {
        }
    }
}

