/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.ext.google.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniclient.credential.UserCredential;
import org.miniclient.credential.impl.AbstractUserCredential;
import org.miniclient.ext.google.GoogleRestServiceClient;
import org.miniclient.ext.google.maker.GoogleRestServiceClientMaker;
import org.miniclient.impl.AbstractRestServiceClient;
import org.miniclient.maker.RestServiceClientMaker;

public class BaseGoogleRestServiceClient
extends AbstractRestServiceClient
implements GoogleRestServiceClient,
Serializable {
    private static final Logger log = Logger.getLogger(BaseGoogleRestServiceClient.class.getName());
    private static final long serialVersionUID = 1L;

    public BaseGoogleRestServiceClient(String resourceBaseUrl) {
        super(resourceBaseUrl);
    }

    protected void init() {
        super.init();
        this.setAuthCredentialRequired(false);
        super.setDefaultAuthCredential((UserCredential)new AbstractUserCredential(){});
        this.setRequestFormat("JSON");
        this.setResponseFormat("JSON");
        this.setTimeoutSeconds(10);
    }

    protected RestServiceClientMaker makeRestServiceClientMaker() {
        return GoogleRestServiceClientMaker.getInstance();
    }

    protected Map<String, Object> process(String method, UserCredential userCredential, Object inputData, String id, Map<String, Object> params, boolean retrying) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("BaseGoogleRestServiceClient.get(): method = " + method + "; userCredential = " + userCredential + "; inputData" + inputData + "; id = " + id + "; params = " + params);
        }
        return super.process(method, userCredential, inputData, id, params, retrying);
    }

    public Map<String, Object> get(UserCredential credential, String id, Map<String, Object> params) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("BaseGoogleRestServiceClient.get(): credential = " + credential + "; id = " + id + "; params = " + params);
        }
        return super.get(credential, id, params);
    }

    public Map<String, Object> post(UserCredential credential, Object inputData) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("BaseGoogleRestServiceClient.post(): credential = " + credential + "; inputData = " + inputData);
        }
        return super.post(credential, inputData);
    }

    public Map<String, Object> put(UserCredential credential, Object inputData, String id) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("BaseGoogleRestServiceClient.put(): credential = " + credential + "; inputData = " + inputData + "; id = " + id);
        }
        return super.put(credential, inputData, id);
    }

    public Map<String, Object> patch(UserCredential credential, Object partialData, String id) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("BaseGoogleRestServiceClient.patch(): credential = " + credential + "; partialData = " + partialData + "; id = " + id);
        }
        return super.patch(credential, partialData, id);
    }

    public Map<String, Object> delete(UserCredential credential, String id, Map<String, Object> params) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("BaseGoogleRestServiceClient.delete(): credential = " + credential + "; id = " + id + "; params = " + params);
        }
        return super.delete(credential, id, params);
    }

    public String toString() {
        return "BaseGoogleRestServiceClient [getResourceUrlBuilder()=" + this.getResourceUrlBuilder() + ", getHttpMethodFilter()=" + this.getHttpMethodFilter() + ", getResourceBaseUrl()=" + this.getResourceBaseUrl() + ", getResourcePostUrl()=" + this.getResourcePostUrl() + ", isAuthCredentialRequired()=" + this.isAuthCredentialRequired() + ", getDefaultAuthCredential()=" + this.getDefaultAuthCredential() + ", getClientCredential()=" + this.getClientCredential() + ", getRequiredScopes()=" + this.getRequiredScopes() + ", getRequestFormat()=" + this.getRequestFormat() + ", getResponseFormat()=" + this.getResponseFormat() + ", getTimeoutSeconds()=" + this.getTimeoutSeconds() + ", getAuthRefreshPolicy()=" + this.getAuthRefreshPolicy() + ", getRequestRetryPolicy()=" + this.getRequestRetryPolicy() + ", getClientCachePolicy()=" + this.getClientCachePolicy() + ", getAutoRedirectPolicy()=" + this.getAutoRedirectPolicy() + "]";
    }
}

