package org.miniclient.ext.google.mirror.factory;

import org.miniclient.credential.UserCredential;
import org.miniclient.ext.google.factory.GoogleApiUserClientFactory;
import org.miniclient.ext.google.mirror.MirrorApiServiceClient;
import org.miniclient.ext.google.mirror.MirrorApiUserClient;


public interface MirrorApiUserClientFactory extends GoogleApiUserClientFactory
{
    MirrorApiUserClient createMirrorContactApiUserClient(UserCredential userCredential);
    MirrorApiUserClient createMirrorLocationApiUserClient(UserCredential userCredential);
    MirrorApiUserClient createMirrorSubscriptionApiUserClient(UserCredential userCredential);
    MirrorApiUserClient createMirrorTimelineApiUserClient(UserCredential userCredential);
    MirrorApiUserClient createMirrorTimelineAttachmentApiUserClient(String timelineItemId, UserCredential userCredential);

    MirrorApiUserClient createMirrorContactApiUserClient(MirrorApiServiceClient serviceClient, UserCredential userCredential);
    MirrorApiUserClient createMirrorLocationApiUserClient(MirrorApiServiceClient serviceClient, UserCredential userCredential);
    MirrorApiUserClient createMirrorSubscriptionApiUserClient(MirrorApiServiceClient serviceClient, UserCredential userCredential);
    MirrorApiUserClient createMirrorTimelineApiUserClient(MirrorApiServiceClient serviceClient, UserCredential userCredential);
    MirrorApiUserClient createMirrorTimelineAttachmentApiUserClient(MirrorApiServiceClient serviceClient, UserCredential userCredential);
}
