/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.ext.google.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniclient.RestApiException;
import org.miniclient.core.ListResponseType;
import org.miniclient.credential.UserCredential;
import org.miniclient.ext.google.GoogleApiServiceClient;
import org.miniclient.ext.google.maker.GoogleApiServiceClientMaker;
import org.miniclient.impl.AbstractApiServiceClient;
import org.miniclient.maker.ApiServiceClientMaker;

public class BaseGoogleApiServiceClient
extends AbstractApiServiceClient
implements GoogleApiServiceClient,
Serializable {
    private static final Logger log = Logger.getLogger(BaseGoogleApiServiceClient.class.getName());
    private static final long serialVersionUID = 1L;

    public BaseGoogleApiServiceClient(String resourceBaseUrl) {
        super(resourceBaseUrl);
    }

    protected void init() {
        super.init();
        this.setListResponseType(ListResponseType.MAP_ITEMS);
    }

    protected ApiServiceClientMaker makeApiServiceClientMaker() {
        return GoogleApiServiceClientMaker.getInstance();
    }

    public Object get(UserCredential credential, String id) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("BaseGoogleApiServiceClient.get(): credential = " + credential + "; id = " + id);
        }
        return super.get(credential, id);
    }

    public List<Object> list(UserCredential credential, Map<String, Object> params) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("BaseGoogleApiServiceClient.list(): credential = " + credential + "; params = " + params);
        }
        return super.list(credential, params);
    }

    public List<String> keys(UserCredential credential, Map<String, Object> params) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("BaseGoogleApiServiceClient.keys(): credential = " + credential + "; params = " + params);
        }
        return super.keys(credential, params);
    }

    public Object create(UserCredential credential, Object inputData) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("BaseGoogleApiServiceClient.create(): credential = " + credential + "; inputData = " + inputData);
        }
        return super.create(credential, inputData);
    }

    public Object create(UserCredential credential, Object inputData, String id) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("BaseGoogleApiServiceClient.create(): credential = " + credential + "; inputData = " + inputData + "; id = " + id);
        }
        return super.create(credential, inputData, id);
    }

    public Object update(UserCredential credential, Object inputData, String id) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("BaseGoogleApiServiceClient.update(): credential = " + credential + "; inputData = " + inputData + "; id = " + id);
        }
        return super.update(credential, inputData, id);
    }

    public Object modify(UserCredential credential, Object partialData, String id) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("BaseGoogleApiServiceClient.modify(): credential = " + credential + "; partialData = " + partialData + "; id = " + id);
        }
        return super.modify(credential, partialData, id);
    }

    public boolean delete(UserCredential credential, String id) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("BaseGoogleApiServiceClient.delete(): credential = " + credential + "; id = " + id);
        }
        return super.delete(credential, id);
    }

    public int delete(UserCredential credential, Map<String, Object> params) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("BaseGoogleApiServiceClient.delete(): credential = " + credential + "; params = " + params);
        }
        return super.delete(credential, params);
    }

    public String toString() {
        return "BaseGoogleApiServiceClient [getRestServiceClient()=" + this.getRestServiceClient() + ", getCrudMethodFilter()=" + this.getCrudMethodFilter() + ", getListResponseType()=" + this.getListResponseType() + ", getResourceBaseUrl()=" + this.getResourceBaseUrl() + ", getClientCredential()=" + this.getClientCredential() + ", getRestServiceAuthRefreshPolicy()=" + this.getRestServiceAuthRefreshPolicy() + ", getRestServiceRequestRetryPolicy()=" + this.getRestServiceRequestRetryPolicy() + ", getRestServiceClientCachePolicy()=" + this.getRestServiceClientCachePolicy() + ", getRestServiceAutoRedirectPolicy()=" + this.getRestServiceAutoRedirectPolicy() + ", getRequiredScopes()=" + this.getRequiredScopes() + ", getAutoRedirectPolicy()=" + this.getAutoRedirectPolicy() + ", getAuthRefreshPolicy()=" + this.getAuthRefreshPolicy() + ", getRequestRetryPolicy()=" + this.getRequestRetryPolicy() + ", getClientCachePolicy()=" + this.getClientCachePolicy() + "]";
    }
}

