/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.json.common;

import java.util.Arrays;
import java.util.logging.Logger;
import org.miniclient.json.common.CyclicCharArray;

public final class CharQueue {
    private static final Logger log = Logger.getLogger(CharQueue.class.getName());
    private static final int MAX_BUFFER_SIZE = 10000000;
    private static final int DEF_BUFFER_SIZE = 2048;
    private static final int MIN_BUFFER_SIZE = 8;
    private final char[] buffer;
    private final int maxSize;
    private int tailPointer = 0;
    private int headPointer = 0;

    public CharQueue() {
        this(2048);
    }

    public CharQueue(int maxSize) {
        this.maxSize = maxSize < 8 ? 8 : (maxSize > 10000000 ? 10000000 : maxSize);
        this.buffer = new char[this.maxSize];
    }

    private void incrementHead() {
        ++this.headPointer;
        if (this.headPointer >= this.maxSize) {
            this.headPointer = 0;
        }
    }

    private void incrementHead(int delta) {
        this.headPointer += delta;
        if (this.headPointer >= this.maxSize) {
            this.headPointer %= this.maxSize;
        }
    }

    private void incrementTail() {
        ++this.tailPointer;
        if (this.tailPointer >= this.maxSize) {
            this.tailPointer = 0;
        }
    }

    private void incrementTail(int delta) {
        this.tailPointer += delta;
        if (this.tailPointer >= this.maxSize) {
            this.tailPointer %= this.maxSize;
        }
    }

    public int margin() {
        int margin = this.tailPointer < this.headPointer ? this.headPointer - this.tailPointer - 1 : this.maxSize - (this.tailPointer - this.headPointer) - 1;
        return margin;
    }

    public int maxCapacity() {
        return this.maxSize - 1;
    }

    public int size() {
        int size = this.tailPointer < this.headPointer ? this.maxSize + this.tailPointer - this.headPointer : this.tailPointer - this.headPointer;
        return size;
    }

    public boolean isEmpty() {
        return this.tailPointer == this.headPointer;
    }

    public boolean add(char ch) {
        if (this.margin() == 0) {
            return false;
        }
        this.buffer[this.tailPointer] = ch;
        this.incrementTail();
        return true;
    }

    public boolean addAll(char[] c) {
        if (c == null || c.length == 0) {
            return false;
        }
        int len = c.length;
        return this.addAll(c, len);
    }

    public boolean addAll(char[] c, int length) {
        if (c == null || c.length == 0) {
            return false;
        }
        int len = c.length;
        if (len < length) {
            length = len;
        }
        if (this.margin() < length) {
            return false;
        }
        if (this.tailPointer + length < this.maxSize) {
            System.arraycopy(c, 0, this.buffer, this.tailPointer, length);
        } else {
            int first = this.maxSize - this.tailPointer;
            int second = length - first;
            System.arraycopy(c, 0, this.buffer, this.tailPointer, first);
            System.arraycopy(c, first, this.buffer, 0, second);
        }
        this.incrementTail(length);
        return true;
    }

    public char poll() {
        if (this.isEmpty()) {
            return '\u0000';
        }
        char ch = this.buffer[this.headPointer];
        this.incrementHead();
        return ch;
    }

    public char[] poll(int length) {
        if (this.isEmpty()) {
            return new char[0];
        }
        if (length > this.size()) {
            length = this.size();
        }
        char[] polled = new char[length];
        if (this.headPointer + length < this.maxSize) {
            System.arraycopy(this.buffer, this.headPointer, polled, 0, length);
        } else {
            int first = this.maxSize - this.headPointer;
            int second = length - first;
            System.arraycopy(this.buffer, this.headPointer, polled, 0, first);
            System.arraycopy(this.buffer, 0, polled, first, second);
        }
        this.incrementHead(length);
        return polled;
    }

    public CyclicCharArray pollBuffer(int length) {
        if (this.isEmpty()) {
            return null;
        }
        if (length > this.size()) {
            length = this.size();
        }
        CyclicCharArray charArray = CyclicCharArray.wrap(this.buffer, this.headPointer, length);
        this.incrementHead(length);
        return charArray;
    }

    public void skip() {
        if (!this.isEmpty()) {
            this.incrementHead();
        }
    }

    public void skip(int length) {
        if (!this.isEmpty()) {
            if (length > this.size()) {
                length = this.size();
            }
            this.incrementHead(length);
        }
    }

    public char peek() {
        if (this.isEmpty()) {
            return '\u0000';
        }
        char ch = this.buffer[this.headPointer];
        return ch;
    }

    public char[] peek(int length) {
        if (this.isEmpty()) {
            return new char[0];
        }
        if (length > this.size()) {
            length = this.size();
        }
        char[] peeked = new char[length];
        if (this.headPointer + length < this.maxSize) {
            System.arraycopy(this.buffer, this.headPointer, peeked, 0, length);
        } else {
            int first = this.maxSize - this.headPointer;
            int second = length - first;
            System.arraycopy(this.buffer, this.headPointer, peeked, 0, first);
            System.arraycopy(this.buffer, 0, peeked, first, second);
        }
        return peeked;
    }

    public CyclicCharArray peekBuffer(int length) {
        if (this.isEmpty()) {
            return null;
        }
        if (length > this.size()) {
            length = this.size();
        }
        CyclicCharArray charArray = CyclicCharArray.wrap(this.buffer, this.headPointer, length);
        return charArray;
    }

    public CyclicCharArray peekBuffer(int offset, int length) {
        if (this.isEmpty()) {
            return null;
        }
        if (offset < 0 || offset >= this.size()) {
            return null;
        }
        if (length > this.size() - offset) {
            length = this.size() - offset;
        }
        CyclicCharArray charArray = CyclicCharArray.wrap(this.buffer, this.headPointer + offset, length);
        return charArray;
    }

    public char[] toArray() {
        if (this.isEmpty()) {
            return new char[0];
        }
        int length = this.size();
        char[] copied = new char[length];
        if (this.headPointer + length < this.maxSize) {
            System.arraycopy(this.buffer, this.headPointer, copied, 0, length);
        } else {
            int first = this.maxSize - this.headPointer;
            int second = length - first;
            System.arraycopy(this.buffer, this.headPointer, copied, 0, first);
            System.arraycopy(this.buffer, 0, copied, first, second);
        }
        return copied;
    }

    public void clear() {
        this.tailPointer = 0;
        this.headPointer = 0;
    }

    public String toString() {
        return "CharQueue [buffer=" + Arrays.toString(this.peek(100)) + ", maxSize=" + this.maxSize + ", tailPointer=" + this.tailPointer + ", headPointer=" + this.headPointer + "]";
    }
}

