/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.json.common;

import java.util.Arrays;
import java.util.logging.Logger;

public final class CyclicCharArray {
    private static final Logger log = Logger.getLogger(CyclicCharArray.class.getName());
    private final int arrayLength;
    private final char[] backingArray;
    private int maxLength;
    private int offset;
    private int length;
    private int end;

    public CyclicCharArray(char[] backingArray) {
        this.backingArray = backingArray;
        this.arrayLength = this.backingArray.length;
        this.maxLength = 2 * this.arrayLength;
        this.offset = 0;
        this.length = 0;
        this.resetEnd();
    }

    private void resetEnd() {
        this.end = this.offset + this.length;
    }

    public final int getMaxLength() {
        return this.maxLength;
    }

    public final int getArrayLength() {
        return this.arrayLength;
    }

    public static CyclicCharArray wrap(char[] backingArray) {
        CyclicCharArray charArray = new CyclicCharArray(backingArray);
        return charArray;
    }

    public static CyclicCharArray wrap(char[] backingArray, int offset, int length) {
        CyclicCharArray charArray = new CyclicCharArray(backingArray);
        charArray.setOffsetAndLength(offset, length);
        return charArray;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
        this.resetEnd();
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
        this.resetEnd();
    }

    public void setOffsetAndLength(int offset, int length) {
        this.offset = offset;
        this.length = length;
        this.resetEnd();
    }

    public int getStart() {
        return this.offset;
    }

    public int getEnd() {
        return this.end;
    }

    public final char[] getBackingArray() {
        return this.backingArray;
    }

    public char getCharInArray() {
        return this.getCharInArray(this.offset);
    }

    public char getCharInArray(int index) {
        return this.backingArray[index % this.arrayLength];
    }

    public char getCharInArrayBoundsCheck(int index) {
        if (index < this.offset || index >= this.offset + this.length) {
            throw new IndexOutOfBoundsException("Out of bound: index = " + index + ". offset = " + this.offset + "; length = " + this.length);
        }
        return this.backingArray[index % this.arrayLength];
    }

    public void setCharInArray(char ch) {
        this.setCharInArray(this.offset, ch);
    }

    public void setCharInArray(int index, char ch) {
        this.backingArray[index % this.arrayLength] = ch;
    }

    public void setCharInArrayBoundsCheck(int index, char ch) {
        if (index < this.offset || index >= this.offset + this.length) {
            throw new IndexOutOfBoundsException("Out of bound: index = " + index + ". offset = " + this.offset + "; length = " + this.length);
        }
        this.backingArray[index % this.arrayLength] = ch;
    }

    public void setCharInArrays(char ... c) {
        this.setCharInArrays(this.offset, c);
    }

    public void setCharInArrays(int index, char ... c) {
        for (int i = 0; i < c.length; ++i) {
            this.backingArray[(index + i) % this.arrayLength] = c[i];
        }
    }

    public void setCharInArraysBoundsCheck(int index, char ... c) {
        if (index < this.offset || index >= this.offset + this.length - c.length) {
            throw new IndexOutOfBoundsException("Out of bound: index = " + index + ". offset = " + this.offset + "; length = " + this.length);
        }
        for (int i = 0; i < c.length; ++i) {
            this.backingArray[(index + i) % this.arrayLength] = c[i];
        }
    }

    public char getChar() {
        return this.getChar(0);
    }

    public char getChar(int index) {
        return this.backingArray[(this.offset + index) % this.arrayLength];
    }

    public char getCharBoundsCheck(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException("Out of bound: index = " + index + ". offset = " + this.offset + "; length = " + this.length);
        }
        return this.backingArray[(this.offset + index) % this.arrayLength];
    }

    public char[] getChars(int index, int length) {
        char[] copied = new char[length];
        for (int i = 0; i < length; ++i) {
            copied[i] = this.backingArray[(this.offset + index + i) % this.arrayLength];
        }
        return copied;
    }

    public void setChar(char ch) {
        this.setChar(0, ch);
    }

    public void setChar(int index, char ch) {
        this.backingArray[(this.offset + index) % this.arrayLength] = ch;
    }

    public void setCharBoundsCheck(int index, char ch) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException("Out of bound: index = " + index + ". offset = " + this.offset + "; length = " + this.length);
        }
        this.backingArray[(this.offset + index) % this.arrayLength] = ch;
    }

    public void setChars(char ... c) {
        this.setChars(0, c);
    }

    public void setChars(int index, char ... c) {
        for (int i = 0; i < c.length; ++i) {
            this.backingArray[(this.offset + index + i) % this.arrayLength] = c[i];
        }
    }

    public void setCharsBoundsCheck(int index, char ... c) {
        if (index < 0 || index >= this.length - c.length) {
            throw new IndexOutOfBoundsException("Out of bound: index = " + index + ". offset = " + this.offset + "; length = " + this.length);
        }
        for (int i = 0; i < c.length; ++i) {
            this.backingArray[(this.offset + index + i) % this.arrayLength] = c[i];
        }
    }

    public char[] getArray() {
        char[] copied = new char[this.length];
        for (int i = 0; i < this.length; ++i) {
            copied[i] = this.backingArray[(this.offset + i) % this.arrayLength];
        }
        return copied;
    }

    public String toString() {
        return Arrays.toString(this.getArray());
    }
}

