/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.json.common;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

public final class Symbols {
    private static final Logger log = Logger.getLogger(Symbols.class.getName());
    public static final char COMMA = ',';
    public static final char COLON = ':';
    public static final char LSQUARE = '[';
    public static final char RSQUARE = ']';
    public static final char LCURLY = '{';
    public static final char RCURLY = '}';
    public static final char DQUOTE = '\"';
    public static final char BACKSLASH = '\\';
    public static final char SLASH = '/';
    public static final char BACKSPACE = 'b';
    public static final char FORMFEED = 'f';
    public static final char NEWLINE = 'n';
    public static final char RETURN = 'r';
    public static final char TAB = 't';
    public static final char PLUS = '+';
    public static final char MINUS = '-';
    public static final char PERIOD = '.';
    public static final char EXP_LOWER = 'e';
    public static final char EXP_UPPER = 'E';
    public static final char ESCAPED_DQUOTE = '\"';
    public static final char ESCAPED_BACKSLASH = '\\';
    public static final char ESCAPED_BACKSPACE = '\b';
    public static final char ESCAPED_FORMFEED = '\f';
    public static final char ESCAPED_NEWLINE = '\n';
    public static final char ESCAPED_RETURN = '\r';
    public static final char ESCAPED_TAB = '\t';
    public static final String ESCAPED_DQUOTE_STR = "\\\"";
    public static final String ESCAPED_BACKSLASH_STR = "\\\\";
    public static final String ESCAPED_SLASH_STR = "\\/";
    public static final String SLASH_STR = "/";
    public static final String ESCAPED_BACKSPACE_STR = "\\b";
    public static final String ESCAPED_FORMFEED_STR = "\\f";
    public static final String ESCAPED_NEWLINE_STR = "\\n";
    public static final String ESCAPED_RETURN_STR = "\\r";
    public static final String ESCAPED_TAB_STR = "\\t";
    public static final char NULL_START = 'n';
    public static final char TRUE_START = 't';
    public static final char FALSE_START = 'f';
    public static final char NULL_START_UPPER = 'N';
    public static final char TRUE_START_UPPER = 'T';
    public static final char FALSE_START_UPPER = 'F';
    public static final char UNICODE_PREFIX = 'u';
    private static final Set<Character> symbolSet = new HashSet<Character>();
    private static final Set<Character> escapables;
    private static final Set<Character> escaped;

    private Symbols() {
    }

    public static boolean isValidSymbol(char symbol) {
        return symbolSet.contains(Character.valueOf(symbol));
    }

    public static boolean isEscapableChar(char ch) {
        switch (ch) {
            case '\"': 
            case '/': 
            case '\\': 
            case 'b': 
            case 'f': 
            case 'n': 
            case 'r': 
            case 't': 
            case 'u': {
                return true;
            }
        }
        return false;
    }

    public static char getEscapedChar(char ch) {
        switch (ch) {
            case '\"': {
                return '\"';
            }
            case '\\': {
                return '\\';
            }
            case '/': {
                return '/';
            }
            case 'b': {
                return '\b';
            }
            case 'f': {
                return '\f';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
        }
        return '\u0000';
    }

    public static boolean isEscapedChar(char ch) {
        switch (ch) {
            case '\b': 
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case '\"': 
            case '/': 
            case '\\': {
                return true;
            }
        }
        return false;
    }

    public static String getEscapedCharString(char ch) {
        return Symbols.getEscapedCharString(ch, false);
    }

    public static String getEscapedCharString(char ch, boolean escapeForwardSlash) {
        switch (ch) {
            case '\"': {
                return ESCAPED_DQUOTE_STR;
            }
            case '\\': {
                return ESCAPED_BACKSLASH_STR;
            }
            case '/': {
                if (escapeForwardSlash) {
                    return ESCAPED_SLASH_STR;
                }
                return SLASH_STR;
            }
            case '\b': {
                return ESCAPED_BACKSPACE_STR;
            }
            case '\f': {
                return ESCAPED_FORMFEED_STR;
            }
            case '\n': {
                return ESCAPED_NEWLINE_STR;
            }
            case '\r': {
                return ESCAPED_RETURN_STR;
            }
            case '\t': {
                return ESCAPED_TAB_STR;
            }
        }
        return null;
    }

    public static boolean isStartingNumber(char ch) {
        return ch == '-' || ch == '+' || ch == '.' || Character.isDigit(ch);
    }

    public static boolean isExponentChar(char ch) {
        switch (ch) {
            case 'E': 
            case 'e': {
                return true;
            }
        }
        return false;
    }

    static {
        symbolSet.add(Character.valueOf(','));
        symbolSet.add(Character.valueOf(':'));
        symbolSet.add(Character.valueOf('['));
        symbolSet.add(Character.valueOf(']'));
        symbolSet.add(Character.valueOf('{'));
        symbolSet.add(Character.valueOf('}'));
        symbolSet.add(Character.valueOf('\"'));
        escapables = new HashSet<Character>();
        escapables.add(Character.valueOf('\"'));
        escapables.add(Character.valueOf('\\'));
        escapables.add(Character.valueOf('/'));
        escapables.add(Character.valueOf('b'));
        escapables.add(Character.valueOf('f'));
        escapables.add(Character.valueOf('n'));
        escapables.add(Character.valueOf('r'));
        escapables.add(Character.valueOf('t'));
        escapables.add(Character.valueOf('u'));
        escaped = new HashSet<Character>();
        escaped.add(Character.valueOf('\"'));
        escaped.add(Character.valueOf('\\'));
        escaped.add(Character.valueOf('/'));
        escaped.add(Character.valueOf('\b'));
        escaped.add(Character.valueOf('\f'));
        escaped.add(Character.valueOf('\n'));
        escaped.add(Character.valueOf('\r'));
        escaped.add(Character.valueOf('\t'));
    }
}

