/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.json.common;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.miniclient.json.common.JsonToken;
import org.miniclient.json.common.TokenTypes;

public final class TokenPool {
    private static final Logger log = Logger.getLogger(TokenPool.class.getName());
    public static final JsonToken TOKEN_EOF = new JsonToken(-1, null);
    public static final JsonToken TOKEN_NULL = new JsonToken(0, null);
    public static final JsonToken TOKEN_COMMA = new JsonToken(3, Character.valueOf(','));
    public static final JsonToken TOKEN_COLON = new JsonToken(4, Character.valueOf(':'));
    public static final JsonToken TOKEN_LSQUARE = new JsonToken(5, Character.valueOf('['));
    public static final JsonToken TOKEN_RSQUARE = new JsonToken(6, Character.valueOf(']'));
    public static final JsonToken TOKEN_LCURLY = new JsonToken(7, Character.valueOf('{'));
    public static final JsonToken TOKEN_RCURLY = new JsonToken(8, Character.valueOf('}'));
    public static final JsonToken TOKEN_TRUE = new JsonToken(9, true);
    public static final JsonToken TOKEN_FALSE = new JsonToken(9, false);
    private final Map<Integer, JsonToken> tokenPool = new HashMap<Integer, JsonToken>();

    private TokenPool() {
        this.tokenPool.put(TOKEN_EOF.hashCode(), TOKEN_EOF);
        this.tokenPool.put(TOKEN_NULL.hashCode(), TOKEN_NULL);
        this.tokenPool.put(TOKEN_COMMA.hashCode(), TOKEN_COMMA);
        this.tokenPool.put(TOKEN_COLON.hashCode(), TOKEN_COLON);
        this.tokenPool.put(TOKEN_LSQUARE.hashCode(), TOKEN_LSQUARE);
        this.tokenPool.put(TOKEN_RSQUARE.hashCode(), TOKEN_RSQUARE);
        this.tokenPool.put(TOKEN_LCURLY.hashCode(), TOKEN_LCURLY);
        this.tokenPool.put(TOKEN_RCURLY.hashCode(), TOKEN_RCURLY);
        this.tokenPool.put(TOKEN_TRUE.hashCode(), TOKEN_TRUE);
        this.tokenPool.put(TOKEN_FALSE.hashCode(), TOKEN_FALSE);
    }

    public static TokenPool getInstance() {
        return TokenPoolHolder.INSTANCE;
    }

    public static JsonToken getSymbolToken(char symbol) {
        switch (symbol) {
            case ',': {
                return TOKEN_COMMA;
            }
            case ':': {
                return TOKEN_COLON;
            }
            case '[': {
                return TOKEN_LSQUARE;
            }
            case ']': {
                return TOKEN_RSQUARE;
            }
            case '{': {
                return TOKEN_LCURLY;
            }
            case '}': {
                return TOKEN_RCURLY;
            }
        }
        return null;
    }

    public static JsonToken getStockToken(int type, Object value) {
        switch (type) {
            case -1: {
                return TOKEN_EOF;
            }
            case 0: {
                return TOKEN_NULL;
            }
            case 3: {
                return TOKEN_COMMA;
            }
            case 4: {
                return TOKEN_COLON;
            }
            case 5: {
                return TOKEN_LSQUARE;
            }
            case 6: {
                return TOKEN_RSQUARE;
            }
            case 7: {
                return TOKEN_LCURLY;
            }
            case 8: {
                return TOKEN_RCURLY;
            }
        }
        if (type == 9) {
            return TokenPool.getBooleanToken(value);
        }
        return null;
    }

    public static JsonToken getBooleanToken(Object value) {
        if (Boolean.TRUE.equals(value) || "true".equals(value)) {
            return TOKEN_TRUE;
        }
        return TOKEN_FALSE;
    }

    public JsonToken getToken(int type, Object value) {
        JsonToken token = TokenPool.getStockToken(type, value);
        if (token != null) {
            return token;
        }
        if (!TokenTypes.isValid(type)) {
            return TOKEN_NULL;
        }
        int h = JsonToken.getHashCode(type, value);
        JsonToken tok = null;
        if (this.tokenPool.containsKey(h)) {
            tok = this.tokenPool.get(h);
        } else {
            tok = new JsonToken(type, value);
            this.tokenPool.put(tok.hashCode(), tok);
        }
        return tok;
    }

    private static final class TokenPoolHolder {
        private static final TokenPool INSTANCE = new TokenPool();

        private TokenPoolHolder() {
        }
    }
}

