/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.json.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniclient.json.LiteJsonTokenizer;
import org.miniclient.json.MiniClientJsonException;
import org.miniclient.json.common.CharQueue;
import org.miniclient.json.common.CharacterUtil;
import org.miniclient.json.common.CyclicCharArray;
import org.miniclient.json.common.JsonToken;
import org.miniclient.json.common.LiteralUtil;
import org.miniclient.json.common.Literals;
import org.miniclient.json.common.Symbols;
import org.miniclient.json.common.TokenPool;
import org.miniclient.json.common.UnicodeUtil;

public final class MiniClientJsonTokenizer
implements LiteJsonTokenizer {
    private static final Logger log = Logger.getLogger(MiniClientJsonTokenizer.class.getName());
    private static final int MAX_STRING_LOOKAHEAD_SIZE = 128;
    private static final int MAX_SPACE_LOOKAHEAD_SIZE = 32;
    private static final int CHARQUEUE_SIZE = 4096;
    private static final int READER_BUFF_SIZE = 1024;
    private static final int HEAD_TRACE_LENGTH = 25;
    private Reader reader;
    private int curReaderIndex = 0;
    private boolean readerEOF = false;
    private JsonToken curToken = null;
    private JsonToken nextToken = null;
    private JsonToken nextNextToken = null;
    private final CharQueue charQueue;
    private final char[] buff = new char[1024];

    public MiniClientJsonTokenizer(String str) {
        this(new StringReader(str));
    }

    public MiniClientJsonTokenizer(Reader reader) {
        this(reader, 4096);
    }

    public MiniClientJsonTokenizer(Reader reader, int charQueueSize) {
        this.reader = reader;
        this.charQueue = new CharQueue(charQueueSize);
        this.init();
    }

    protected void init() {
    }

    public void reset(String str) {
        this.reset(new StringReader(str));
    }

    public void reset(Reader reader) {
        this.reader = reader;
        this.charQueue.clear();
        this.readerEOF = false;
        this.curToken = null;
        this.nextToken = null;
    }

    public String peekCharsAsString(int length) {
        char[] c = this.peekCharStream(length);
        if (c != null) {
            return new String(c);
        }
        return "";
    }

    public char[] peekCharStream(int length) {
        char[] c = null;
        try {
            c = this.peekChars(length);
        }
        catch (MiniClientJsonException e) {
            log.log(Level.WARNING, "Failed to peek char stream: length = " + length, e);
        }
        return c;
    }

    public char[] peekCharStream() {
        return this.peekCharStream(25);
    }

    @Override
    public boolean hasMore() throws MiniClientJsonException {
        if (this.nextToken == null) {
            this.nextToken = this.prepareNextToken();
        }
        return this.nextToken != null && !TokenPool.TOKEN_EOF.equals(this.nextToken);
    }

    @Override
    public JsonToken next() throws MiniClientJsonException {
        if (this.nextToken == null) {
            this.nextToken = this.prepareNextToken();
        }
        this.curToken = this.nextToken;
        this.nextToken = null;
        return this.curToken;
    }

    @Override
    public JsonToken peek() throws MiniClientJsonException {
        if (this.nextToken != null) {
            return this.nextToken;
        }
        this.nextToken = this.prepareNextToken();
        return this.nextToken;
    }

    public JsonToken nextAndPeek() throws MiniClientJsonException {
        this.curToken = this.nextToken == null ? this.prepareNextToken() : this.nextToken;
        this.nextToken = this.prepareNextToken();
        return this.nextToken;
    }

    private JsonToken prepareNextToken() throws MiniClientJsonException {
        if (this.nextToken != null) {
            return this.nextToken;
        }
        JsonToken token = null;
        char ch = this.gobbleUpSpaceLookAhead();
        switch (ch) {
            case ',': 
            case ':': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                token = TokenPool.getSymbolToken(ch);
                this.skipCharNoCheck();
                break;
            }
            case 'N': 
            case 'n': {
                token = this.doNullLiteral();
                break;
            }
            case 'T': 
            case 't': {
                token = this.doTrueLiteral();
                break;
            }
            case 'F': 
            case 'f': {
                token = this.doFalseLiteral();
                break;
            }
            case '\"': {
                token = this.doString();
                break;
            }
            case '\u0000': {
                token = TokenPool.TOKEN_EOF;
                this.skipCharNoCheck();
                break;
            }
            default: {
                if (Symbols.isStartingNumber(ch)) {
                    token = this.doNumber();
                    break;
                }
                throw new MiniClientJsonException("Invalid symbol encountered: ch = " + ch);
            }
        }
        return token;
    }

    private char gobbleUpSpace() {
        char c = '\u0000';
        try {
            c = this.peekChar();
            while (c != '\u0000' && CharacterUtil.isWhitespace(c)) {
                c = this.skipAndPeekChar();
            }
        }
        catch (MiniClientJsonException e) {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, "Failed to consume space.", e);
            }
            c = '\u0000';
        }
        return c;
    }

    private char gobbleUpSpaceLookAhead() {
        char c = '\u0000';
        try {
            c = this.peekChar();
            if (CharacterUtil.isWhitespace(c) && CharacterUtil.isWhitespace(c = this.skipAndPeekChar())) {
                CyclicCharArray charArray = this.peekCharsInQueue(32);
                int chunkLength = charArray.getLength();
                int chunkCounter = 0;
                int totalLookAheadLength = 0;
                c = charArray.getChar(0);
                while (chunkCounter < chunkLength - 1 && CharacterUtil.isWhitespace(c)) {
                    if (++chunkCounter >= chunkLength - 1) {
                        totalLookAheadLength += chunkCounter;
                        chunkCounter = 0;
                        charArray = this.peekCharsInQueue(totalLookAheadLength, 32);
                        if (charArray == null || (chunkLength = charArray.getLength()) == 0) break;
                    }
                    c = charArray.getChar(chunkCounter);
                }
                this.skipChars(totalLookAheadLength += chunkCounter);
                c = this.peekChar();
            }
        }
        catch (MiniClientJsonException e) {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, "Failed to consume space.", e);
            }
            c = '\u0000';
        }
        return c;
    }

    private JsonToken doNullLiteral() throws MiniClientJsonException {
        JsonToken token = null;
        int length = Literals.NULL_LENGTH;
        CyclicCharArray c = this.nextCharsInQueue(length);
        if (!LiteralUtil.isNull(c)) {
            throw new MiniClientJsonException("Unexpected string: ");
        }
        token = TokenPool.TOKEN_NULL;
        return token;
    }

    private JsonToken doTrueLiteral() throws MiniClientJsonException {
        JsonToken token = null;
        int length = Literals.TRUE_LENGTH;
        CyclicCharArray c = this.nextCharsInQueue(length);
        if (!LiteralUtil.isTrue(c)) {
            throw new MiniClientJsonException("Unexpected string: ");
        }
        token = TokenPool.TOKEN_TRUE;
        return token;
    }

    private JsonToken doFalseLiteral() throws MiniClientJsonException {
        JsonToken token = null;
        int length = Literals.FALSE_LENGTH;
        CyclicCharArray c = this.nextCharsInQueue(length);
        if (!LiteralUtil.isFalse(c)) {
            throw new MiniClientJsonException("Unexpected string: ");
        }
        token = TokenPool.TOKEN_FALSE;
        return token;
    }

    private JsonToken doString() throws MiniClientJsonException {
        JsonToken token = null;
        String value = this.readStringWithLookAhead();
        token = TokenPool.getInstance().getToken(11, value);
        return token;
    }

    /*
     * Unable to fully structure code
     */
    private String readString() throws MiniClientJsonException {
        sb = new StringBuilder();
        c = this.peekChar();
        if (c == '\u0000') {
            throw new MiniClientJsonException("Expecting String. Invalid token encountered: c = " + c);
        }
        if (c == '\"') {
            this.skipCharNoCheck();
        }
        escaped = false;
        d = this.peekChar();
        while (d != '\u0000' && (escaped || d != '\"')) {
            d = this.nextCharNoCheck();
            if (!escaped && d == '\\') {
                escaped = true;
            } else if (escaped) {
                if (d == 'u') {
                    hex = this.nextCharsInQueue(4);
                    try {
                        u = UnicodeUtil.getUnicodeChar(hex);
                        if (u == '\u0000') ** GOTO lbl32
                        sb.append(u);
                    }
                    catch (Exception e) {
                        throw new MiniClientJsonException("Invalid unicode char: hex = " + hex.toString(), e);
                    }
                } else if (Symbols.isEscapableChar(d)) {
                    e = Symbols.getEscapedChar(d);
                    if (e != '\u0000') {
                        sb.append(e);
                    }
                } else {
                    throw new MiniClientJsonException("Invalid escaped char: d = \\" + d);
                }
lbl32:
                // 3 sources

                escaped = false;
            } else {
                sb.append(d);
            }
            d = this.peekChar();
        }
        if (d == '\"') {
            this.skipCharNoCheck();
        }
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    private String readStringWithLookAhead() throws MiniClientJsonException {
        c = this.nextCharNoCheck();
        if (c == '\u0000' || c != '\"') {
            throw new MiniClientJsonException("Expecting String. Invalid token encountered: c = " + c);
        }
        sb = new StringBuilder();
        escaped = false;
        charArray = this.peekCharsInQueue(128);
        if (charArray == null || (chunkLength = charArray.getLength()) == 0) {
            throw new MiniClientJsonException("String token terminated unexpectedly.");
        }
        noMoreCharsInQueue = false;
        if (chunkLength < 128) {
            noMoreCharsInQueue = true;
        }
        needMore = false;
        chunkCounter = 0;
        totalLookAheadLength = 0;
        d = charArray.getChar(0);
        while (chunkCounter < chunkLength - 1 && d != '\u0000' && (escaped || d != '\"')) {
            block20: {
                block21: {
                    block19: {
                        ++chunkCounter;
                        if (escaped || d != '\\') break block19;
                        escaped = true;
                        break block20;
                    }
                    if (!escaped) break block21;
                    if (d != 'u') ** GOTO lbl40
                    if (chunkCounter < chunkLength - 4) {
                        hex = charArray.getChars(chunkCounter, 4);
                        chunkCounter += 4;
                        try {
                            u = UnicodeUtil.getUnicodeChar(hex);
                            if (u == '\u0000') ** GOTO lbl47
                            sb.append(u);
                        }
                        catch (Exception e) {
                            throw new MiniClientJsonException("Invalid unicode char: hex = " + Arrays.toString(hex), e);
                        }
                    } else if (!noMoreCharsInQueue) {
                        needMore = true;
                        chunkCounter -= 2;
                    } else {
                        throw new MiniClientJsonException("Invalid unicode char.");
lbl40:
                        // 1 sources

                        if (Symbols.isEscapableChar(d)) {
                            e = Symbols.getEscapedChar(d);
                            if (e != '\u0000') {
                                sb.append(e);
                            }
                        } else {
                            throw new MiniClientJsonException("Invalid escaped char: d = \\" + d);
                        }
                    }
lbl47:
                    // 4 sources

                    escaped = false;
                    break block20;
                }
                sb.append(d);
            }
            if (!noMoreCharsInQueue && (needMore || chunkCounter >= chunkLength - 1)) {
                totalLookAheadLength += chunkCounter;
                chunkCounter = 0;
                needMore = false;
                try {
                    charArray = this.peekCharsInQueue(totalLookAheadLength, 128);
                }
                catch (MiniClientJsonException e) {
                    MiniClientJsonTokenizer.log.warning("String token might have been too long. Trying again with no look-ahead readString().");
                    return this.readString();
                }
                if (charArray == null || (chunkLength = charArray.getLength()) == 0) {
                    throw new MiniClientJsonException("String token terminated unexpectedly.");
                }
                if (chunkLength < 128) {
                    noMoreCharsInQueue = true;
                }
            }
            d = charArray.getChar(chunkCounter);
        }
        this.skipChars(totalLookAheadLength += chunkCounter);
        d = this.peekChar();
        if (d == '\"') {
            this.skipCharNoCheck();
        }
        return sb.toString();
    }

    private JsonToken doNumber() throws MiniClientJsonException {
        JsonToken token = null;
        Number value = this.readNumber();
        token = TokenPool.getInstance().getToken(10, value);
        return token;
    }

    private Number readNumber() throws MiniClientJsonException {
        char c = this.nextCharNoCheck();
        if (!Symbols.isStartingNumber(c)) {
            throw new MiniClientJsonException("Expecting a number. Invalid symbol encountered: c = " + c);
        }
        if (c == '+') {
            c = this.nextChar();
        }
        StringBuilder sb = new StringBuilder();
        if (c == '-') {
            sb.append(c);
            c = this.nextChar();
        }
        boolean periodRead = false;
        if (c == '.') {
            periodRead = true;
            sb.append("0.");
        } else if (c == '0') {
            char c2 = this.peekChar();
            if (Character.isDigit(c2)) {
                throw new MiniClientJsonException("Invalid number: c = " + sb.toString() + c + c2);
            }
            sb.append(c);
            if (c2 == '.') {
                periodRead = true;
                sb.append(this.nextCharNoCheck());
            }
        } else {
            sb.append(c);
        }
        boolean exponentRead = false;
        char d = this.peekChar();
        while (d != '\u0000' && (Character.isDigit(d) || !periodRead && d == '.' || !exponentRead && Symbols.isExponentChar(d))) {
            sb.append(this.nextCharNoCheck());
            if (d == '.') {
                periodRead = true;
            }
            if (Symbols.isExponentChar(d)) {
                char d2 = this.peekChar();
                if (d2 != '+' && d2 != '-' && !Character.isDigit(d2)) {
                    throw new MiniClientJsonException("Invalid number: " + sb.toString() + d2);
                }
                sb.append(this.nextCharNoCheck());
                exponentRead = true;
            }
            d = this.peekChar();
        }
        if (d == '\u0000') {
            // empty if block
        }
        String str = sb.toString();
        Number number = null;
        try {
            if (str.contains(".")) {
                double x = Double.parseDouble(str);
                number = x;
            } else {
                long y = Long.parseLong(str);
                number = y;
            }
        }
        catch (Exception e) {
            throw new MiniClientJsonException("Invalid number encountered: str = " + str, e);
        }
        return number;
    }

    private char nextCharNoCheck() throws MiniClientJsonException {
        char ch = this.charQueue.poll();
        return ch;
    }

    private void skipCharNoCheck() throws MiniClientJsonException {
        this.charQueue.skip();
    }

    private char nextChar() throws MiniClientJsonException {
        if (this.charQueue.isEmpty() && !this.readerEOF) {
            try {
                this.forward();
            }
            catch (IOException e) {
                throw new MiniClientJsonException("Failed to forward character stream.", e);
            }
        }
        if (this.charQueue.isEmpty()) {
            return '\u0000';
        }
        char ch = this.charQueue.poll();
        return ch;
    }

    private char[] nextChars(int length) throws MiniClientJsonException {
        if (this.charQueue.size() < length && !this.readerEOF) {
            try {
                this.forward();
            }
            catch (IOException e) {
                throw new MiniClientJsonException("Failed to forward character stream.", e);
            }
        }
        char[] c = null;
        if (this.charQueue.size() < length) {
            c = this.charQueue.poll(this.charQueue.size());
        }
        c = this.charQueue.poll(length);
        return c;
    }

    private CyclicCharArray nextCharsInQueue(int length) throws MiniClientJsonException {
        if (this.charQueue.size() < length && !this.readerEOF) {
            try {
                this.forward();
            }
            catch (IOException e) {
                throw new MiniClientJsonException("Failed to forward character stream.", e);
            }
        }
        CyclicCharArray charArray = null;
        if (this.charQueue.size() < length) {
            charArray = this.charQueue.pollBuffer(this.charQueue.size());
        }
        charArray = this.charQueue.pollBuffer(length);
        return charArray;
    }

    private void skipChars(int length) throws MiniClientJsonException {
        if (this.charQueue.size() < length && !this.readerEOF) {
            try {
                this.forward();
            }
            catch (IOException e) {
                throw new MiniClientJsonException("Failed to forward character stream.", e);
            }
        }
        this.charQueue.skip(length);
    }

    private char peekChar() throws MiniClientJsonException {
        if (this.charQueue.isEmpty() && !this.readerEOF) {
            try {
                this.forward();
            }
            catch (IOException e) {
                throw new MiniClientJsonException("Failed to forward character stream.", e);
            }
        }
        if (this.charQueue.isEmpty()) {
            return '\u0000';
        }
        return this.charQueue.peek();
    }

    private char[] peekChars(int length) throws MiniClientJsonException {
        if (this.charQueue.size() < length && !this.readerEOF) {
            try {
                this.forward();
            }
            catch (IOException e) {
                throw new MiniClientJsonException("Failed to forward character stream.", e);
            }
        }
        if (this.charQueue.size() < length) {
            return this.charQueue.peek(this.charQueue.size());
        }
        return this.charQueue.peek(length);
    }

    private CyclicCharArray peekCharsInQueue(int length) throws MiniClientJsonException {
        if (this.charQueue.size() < length && !this.readerEOF) {
            try {
                this.forward();
            }
            catch (IOException e) {
                throw new MiniClientJsonException("Failed to forward character stream.", e);
            }
        }
        if (this.charQueue.size() < length) {
            return this.charQueue.peekBuffer(this.charQueue.size());
        }
        return this.charQueue.peekBuffer(length);
    }

    private CyclicCharArray peekCharsInQueue(int offset, int length) throws MiniClientJsonException {
        if (this.charQueue.size() < offset + length && !this.readerEOF) {
            try {
                this.forward();
            }
            catch (IOException e) {
                throw new MiniClientJsonException("Failed to forward character stream.", e);
            }
        }
        if (this.charQueue.size() < offset + length) {
            return this.charQueue.peekBuffer(offset, this.charQueue.size() - offset);
        }
        return this.charQueue.peekBuffer(offset, length);
    }

    private char skipAndPeekChar() throws MiniClientJsonException {
        int qSize = this.charQueue.size();
        if (qSize < 2 && !this.readerEOF) {
            try {
                this.forward();
                qSize = this.charQueue.size();
            }
            catch (IOException e) {
                throw new MiniClientJsonException("Failed to forward character stream.", e);
            }
        }
        if (qSize > 0) {
            this.charQueue.skip();
            if (qSize > 1) {
                return this.charQueue.peek();
            }
        }
        return '\u0000';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void forward() throws IOException, MiniClientJsonException {
        if (this.readerEOF) return;
        if (this.reader.ready()) {
            int cnt;
            block5: {
                cnt = 0;
                try {
                    cnt = this.reader.read(this.buff);
                }
                catch (IndexOutOfBoundsException e) {
                    if (!log.isLoggable(Level.INFO)) break block5;
                    log.log(Level.INFO, "Looks like we have reached the end of the reader.", e);
                }
            }
            if (cnt == -1 || cnt == 0) {
                this.readerEOF = true;
                return;
            } else {
                boolean suc = this.charQueue.addAll(this.buff, cnt);
                if (!suc) throw new MiniClientJsonException("Unexpected internal error occurred. Characters were not added to CharQueue: cnt = " + cnt);
                this.curReaderIndex += cnt;
            }
            return;
        }
        this.readerEOF = true;
    }
}

