/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.json.common;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public final class BeanIntrospectionUtil {
    private BeanIntrospectionUtil() {
    }

    public static Map<String, Object> introspect(Object obj) throws IntrospectionException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return BeanIntrospectionUtil.introspect(obj, 1);
    }

    public static Map<String, Object> introspect(Object obj, int drillDownDepth) throws IntrospectionException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        BeanInfo info = Introspector.getBeanInfo(obj.getClass());
        for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
            String attr;
            Method reader = pd.getReadMethod();
            if (reader == null || (attr = pd.getName()) == null || attr.equals("class")) continue;
            if (!reader.isAccessible()) {
                reader.setAccessible(true);
            }
            Object val = reader.invoke(obj, new Object[0]);
            result.put(attr, val);
        }
        return result;
    }
}

