/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.json.common;

import java.util.logging.Logger;
import org.miniclient.json.common.CyclicCharArray;
import org.miniclient.json.common.Literals;

public final class LiteralUtil {
    private static final Logger log = Logger.getLogger(LiteralUtil.class.getName());
    private static final char[] NULL_CHARS = new char[]{'n', 'u', 'l', 'l'};
    private static final char[] TRUE_CHARS = new char[]{'t', 'r', 'u', 'e'};
    private static final char[] FALSE_CHARS = new char[]{'f', 'a', 'l', 's', 'e'};
    private static final char[] NULL_CHARS_UPPER = new char[]{'N', 'U', 'L', 'L'};
    private static final char[] TRUE_CHARS_UPPER = new char[]{'T', 'R', 'U', 'E'};
    private static final char[] FALSE_CHARS_UPPER = new char[]{'F', 'A', 'L', 'S', 'E'};

    private LiteralUtil() {
    }

    public static boolean isNull(char[] c) {
        if (c == null || c.length != Literals.NULL_LENGTH) {
            return false;
        }
        for (int i = 0; i < Literals.NULL_LENGTH; ++i) {
            if (c[i] == NULL_CHARS[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isNullIgnoreCase(char[] c) {
        if (c == null || c.length != Literals.NULL_LENGTH) {
            return false;
        }
        for (int i = 0; i < Literals.NULL_LENGTH; ++i) {
            if (c[i] == NULL_CHARS[i] && c[i] == NULL_CHARS_UPPER[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isTrue(char[] c) {
        if (c == null || c.length != Literals.TRUE_LENGTH) {
            return false;
        }
        for (int i = 0; i < Literals.TRUE_LENGTH; ++i) {
            if (c[i] == TRUE_CHARS[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isTrueIgnoreCase(char[] c) {
        if (c == null || c.length != Literals.TRUE_LENGTH) {
            return false;
        }
        for (int i = 0; i < Literals.TRUE_LENGTH; ++i) {
            if (c[i] == TRUE_CHARS[i] && c[i] == TRUE_CHARS_UPPER[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isFalse(char[] c) {
        if (c == null || c.length != Literals.FALSE_LENGTH) {
            return false;
        }
        for (int i = 0; i < Literals.FALSE_LENGTH; ++i) {
            if (c[i] == FALSE_CHARS[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isFalseIgnoreCase(char[] c) {
        if (c == null || c.length != Literals.FALSE_LENGTH) {
            return false;
        }
        for (int i = 0; i < Literals.FALSE_LENGTH; ++i) {
            if (c[i] == FALSE_CHARS[i] && c[i] == FALSE_CHARS_UPPER[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isNull(CyclicCharArray c) {
        if (c == null || c.getLength() != Literals.NULL_LENGTH) {
            return false;
        }
        for (int i = 0; i < Literals.NULL_LENGTH; ++i) {
            if (c.getChar(i) == NULL_CHARS[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isNullIgnoreCase(CyclicCharArray c) {
        if (c == null || c.getLength() != Literals.NULL_LENGTH) {
            return false;
        }
        for (int i = 0; i < Literals.NULL_LENGTH; ++i) {
            if (c.getChar(i) == NULL_CHARS[i] && c.getChar(i) == NULL_CHARS_UPPER[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isTrue(CyclicCharArray c) {
        if (c == null || c.getLength() != Literals.TRUE_LENGTH) {
            return false;
        }
        for (int i = 0; i < Literals.TRUE_LENGTH; ++i) {
            if (c.getChar(i) == TRUE_CHARS[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isTrueIgnoreCase(CyclicCharArray c) {
        if (c == null || c.getLength() != Literals.TRUE_LENGTH) {
            return false;
        }
        for (int i = 0; i < Literals.TRUE_LENGTH; ++i) {
            if (c.getChar(i) == TRUE_CHARS[i] && c.getChar(i) == TRUE_CHARS_UPPER[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isFalse(CyclicCharArray c) {
        if (c == null || c.getLength() != Literals.FALSE_LENGTH) {
            return false;
        }
        for (int i = 0; i < Literals.FALSE_LENGTH; ++i) {
            if (c.getChar(i) == FALSE_CHARS[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isFalseIgnoreCase(CyclicCharArray c) {
        if (c == null || c.getLength() != Literals.FALSE_LENGTH) {
            return false;
        }
        for (int i = 0; i < Literals.FALSE_LENGTH; ++i) {
            if (c.getChar(i) == FALSE_CHARS[i] && c.getChar(i) == FALSE_CHARS_UPPER[i]) continue;
            return false;
        }
        return true;
    }
}

