/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.json.common;

import org.miniclient.json.common.CyclicCharArray;

public final class UnicodeUtil {
    private static char[] HEXNUM = "0123456789abcdef".toCharArray();

    private UnicodeUtil() {
    }

    public static boolean isUnicodeHex(char ch) {
        return ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f' || ch >= '0' && ch <= '9';
    }

    public static int getIntEquivalent(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 55;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 87;
        }
        return 0;
    }

    public static char getUnicodeChar(CyclicCharArray hex) {
        if (hex == null || hex.getLength() != 4) {
            return '\u0000';
        }
        return UnicodeUtil.getUnicodeCharFromHexSequence(hex);
    }

    public static char getUnicodeChar(char[] hex) {
        if (hex == null || hex.length != 4) {
            return '\u0000';
        }
        return UnicodeUtil.getUnicodeCharFromHexSequence(hex);
    }

    public static char getUnicodeCharNoCheck(CyclicCharArray hex) {
        char u = UnicodeUtil.getUnicodeCharFromHexSequence(hex);
        return u;
    }

    public static char getUnicodeCharNoCheck(char[] hex) {
        char u = UnicodeUtil.getUnicodeCharFromHexSequence(hex);
        return u;
    }

    public static char getUnicodeCharFromHexSequence(char[] c) {
        int x = 0;
        for (int i = 0; i < 4; ++i) {
            if (UnicodeUtil.isUnicodeHex(c[i])) {
                x += UnicodeUtil.getIntEquivalent(c[i]) << (3 - i) * 4;
                continue;
            }
            return '\u0000';
        }
        return (char)x;
    }

    public static char getUnicodeCharFromHexSequence(CyclicCharArray hex) {
        int x = 0;
        for (int i = 0; i < 4; ++i) {
            if (UnicodeUtil.isUnicodeHex(hex.getChar(i))) {
                x += UnicodeUtil.getIntEquivalent(hex.getChar(i)) << (3 - i) * 4;
                continue;
            }
            return '\u0000';
        }
        return (char)x;
    }

    public static char[] getUnicodeHexCodeFromChar(char ch) {
        char[] c6 = new char[]{'\\', 'u', '0', '0', '0', '0'};
        char code = ch;
        c6[2] = HEXNUM[(code & 0xF000) >> 12];
        c6[3] = HEXNUM[(code & 0xF00) >> 8];
        c6[4] = HEXNUM[(code & 0xF0) >> 4];
        c6[5] = HEXNUM[code & 0xF];
        return c6;
    }
}

