/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.json.builder;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniclient.json.LiteJsonBuilder;
import org.miniclient.json.MiniClientJsonException;
import org.miniclient.json.builder.MiniClientJsonStructureBuilder;
import org.miniclient.json.common.CharacterUtil;
import org.miniclient.json.common.JsonNull;
import org.miniclient.json.common.Symbols;
import org.miniclient.json.common.UnicodeUtil;

public final class MiniClientJsonBuilder
implements LiteJsonBuilder {
    private static final Logger log = Logger.getLogger(MiniClientJsonBuilder.class.getName());
    private static final int MAX_DRILL_DOWN_DEPTH = 127;
    private static final String WS = " ";

    @Override
    public String build(Object jsonObj) throws MiniClientJsonException {
        String jsonStr = null;
        StringWriter writer = new StringWriter();
        try {
            this.build(writer, jsonObj);
            jsonStr = writer.toString();
            if (log.isLoggable(Level.FINE)) {
                log.fine("jsonStr = " + jsonStr);
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Failed to write jsonObj as JSON.", e);
        }
        return jsonStr;
    }

    @Override
    public void build(Writer writer, Object obj) throws MiniClientJsonException, IOException {
        if (obj == null || obj instanceof Boolean || obj instanceof Character || obj instanceof Number || obj instanceof String) {
            throw new MiniClientJsonException("Top level element should be an object or an array/list.");
        }
        Object jsonObj = null;
        if (obj instanceof Map || obj instanceof List || obj.getClass().isArray() || obj instanceof Collection) {
            jsonObj = obj;
        } else {
            MiniClientJsonStructureBuilder structureBuilder = new MiniClientJsonStructureBuilder();
            jsonObj = structureBuilder.buildJsonStructure(obj);
        }
        this._build(writer, jsonObj, 127);
        writer.flush();
    }

    private void _build(Writer writer, Object obj, int depth) throws IOException {
        if (depth < 0) {
            return;
        }
        if (obj == null || obj instanceof JsonNull) {
            writer.append("null");
        } else if (depth <= 0) {
            String primStr = null;
            if (obj instanceof Boolean) {
                primStr = ((Boolean)obj).equals(Boolean.TRUE) ? "true" : "false";
                writer.append(primStr);
            } else if (obj instanceof Character) {
                Character strChar = (Character)obj;
                writer.append("\"").append(strChar.charValue()).append("\"");
            } else if (obj instanceof Number) {
                primStr = ((Number)obj).toString();
                writer.append(primStr);
            } else if (obj instanceof String) {
                primStr = (String)obj;
                writer.append("\"");
                this._appendEscapedString(writer, primStr);
                writer.append("\"");
            } else {
                primStr = obj instanceof Date ? ((Date)obj).toString() : (obj instanceof String ? (String)obj : obj.toString());
                writer.append("\"");
                this._appendEscapedString(writer, primStr);
                writer.append("\"");
            }
        } else if (obj instanceof Map) {
            Map map = null;
            try {
                map = (Map)obj;
            }
            catch (Exception e) {
                log.log(Level.INFO, "Invalid map type.", e);
            }
            writer.append("{");
            if (map != null && !map.isEmpty()) {
                Iterator it = map.keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    Object val = map.get(key);
                    writer.append("\"").append(key).append("\":").append(WS);
                    this._build(writer, val, depth - 1);
                    if (!it.hasNext()) continue;
                    writer.append(",").append(WS);
                }
            }
            writer.append("}");
        } else if (obj instanceof List) {
            List list = null;
            try {
                list = (List)obj;
            }
            catch (Exception e) {
                log.log(Level.INFO, "Invalid list type.", e);
            }
            writer.append("[");
            if (list != null && !list.isEmpty()) {
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    Object o = it.next();
                    this._build(writer, o, depth - 1);
                    if (!it.hasNext()) continue;
                    writer.append(",").append(WS);
                }
            }
            writer.append("]");
        } else if (obj.getClass().isArray()) {
            Object array = obj;
            writer.append("[");
            if (array != null && Array.getLength(array) > 0) {
                int arrLen = Array.getLength(array);
                for (int i = 0; i < arrLen; ++i) {
                    Object o = Array.get(array, i);
                    this._build(writer, o, depth - 1);
                    if (i >= arrLen - 1) continue;
                    writer.append(",").append(WS);
                }
            }
            writer.append("]");
        } else if (obj instanceof Collection) {
            Collection coll = null;
            try {
                coll = (Collection)obj;
            }
            catch (Exception e) {
                log.log(Level.INFO, "Invalid collection type.", e);
            }
            writer.append("[");
            if (coll != null && !coll.isEmpty()) {
                Iterator it = coll.iterator();
                while (it.hasNext()) {
                    Object o = it.next();
                    this._build(writer, o, depth - 1);
                    if (!it.hasNext()) continue;
                    writer.append(",");
                    writer.append(WS);
                }
            }
            writer.append("]");
        } else {
            String primStr = null;
            if (obj instanceof Boolean) {
                primStr = ((Boolean)obj).equals(Boolean.TRUE) ? "true" : "false";
                writer.append(primStr);
            } else if (obj instanceof Character) {
                Character strChar = (Character)obj;
                writer.append("\"").append(strChar.charValue()).append("\"");
            } else if (obj instanceof Number) {
                primStr = ((Number)obj).toString();
                writer.append(primStr);
            } else if (obj instanceof String) {
                primStr = (String)obj;
                writer.append("\"");
                this._appendEscapedString(writer, primStr);
                writer.append("\"");
            } else {
                primStr = obj instanceof Date ? ((Date)obj).toString() : (obj instanceof String ? (String)obj : obj.toString());
                writer.append("\"");
                this._appendEscapedString(writer, primStr);
                writer.append("\"");
            }
        }
    }

    private void _appendEscapedString(Writer writer, String primStr) throws IOException {
        if (primStr != null && !primStr.isEmpty()) {
            char[] primChars;
            for (char ec : primChars = primStr.toCharArray()) {
                if (Symbols.isEscapedChar(ec)) {
                    String str = Symbols.getEscapedCharString(ec, false);
                    if (str != null) {
                        writer.append(str);
                        continue;
                    }
                    writer.append(ec);
                    continue;
                }
                if (CharacterUtil.isISOControl(ec)) {
                    char[] uc = UnicodeUtil.getUnicodeHexCodeFromChar(ec);
                    writer.write(uc);
                    continue;
                }
                writer.append(ec);
            }
        }
    }
}

