/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.json.builder;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniclient.json.LiteJsonStructureBuilder;
import org.miniclient.json.MiniClientJsonException;
import org.miniclient.json.common.BeanIntrospectionUtil;
import org.miniclient.json.common.JsonNull;

public final class MiniClientJsonStructureBuilder
implements LiteJsonStructureBuilder {
    private static final Logger log = Logger.getLogger(MiniClientJsonStructureBuilder.class.getName());
    private static final int MAX_DRILL_DOWN_DEPTH = 127;
    private static final int DEF_DRILL_DOWN_DEPTH = 3;

    @Override
    public Object buildJsonStructure(Object obj) throws MiniClientJsonException {
        return this.buildJsonStructure(obj, 3);
    }

    @Override
    public Object buildJsonStructure(Object jsonObj, int depth) throws MiniClientJsonException {
        if (depth < 0 || depth > 127) {
            depth = 127;
        }
        return this._buildJsonStruct(jsonObj, depth);
    }

    private Object _buildJsonStruct(Object obj, int depth) throws MiniClientJsonException {
        Object jsonStruct = null;
        if (obj != null && !(obj instanceof JsonNull)) {
            if (depth <= 0) {
                jsonStruct = obj instanceof Boolean ? (Boolean)obj : (obj instanceof Character ? (Character)obj : (obj instanceof Number ? (Number)obj : (obj instanceof String ? (String)obj : obj.toString())));
            } else if (obj instanceof Map) {
                LinkedHashMap<String, Object> jsonMap = new LinkedHashMap<String, Object>();
                Map map = null;
                try {
                    map = (Map)obj;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Invalid map type.", e);
                }
                if (map != null && !map.isEmpty()) {
                    for (String f : map.keySet()) {
                        Object val = map.get(f);
                        Object jsonVal = this._buildJsonStruct(val, depth - 1);
                        if (jsonVal != null) {
                            jsonMap.put(f, jsonVal);
                            continue;
                        }
                        jsonMap.put(f, null);
                    }
                }
                jsonStruct = jsonMap;
            } else if (obj instanceof List) {
                ArrayList<Object> jsonList = new ArrayList<Object>();
                List list = null;
                try {
                    list = (List)obj;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Invalid list type.", e);
                }
                if (list != null && !list.isEmpty()) {
                    for (Object v : list) {
                        Object jsonVal = this._buildJsonStruct(v, depth - 1);
                        if (jsonVal != null) {
                            jsonList.add(jsonVal);
                            continue;
                        }
                        jsonList.add(null);
                    }
                }
                jsonStruct = jsonList;
            } else if (obj.getClass().isArray()) {
                ArrayList<Object> jsonList = new ArrayList<Object>();
                Object array = obj;
                if (array != null && Array.getLength(array) > 0) {
                    int arrLen = Array.getLength(array);
                    for (int i = 0; i < arrLen; ++i) {
                        Object o = Array.get(array, i);
                        Object jsonVal = this._buildJsonStruct(o, depth - 1);
                        if (jsonVal != null) {
                            jsonList.add(jsonVal);
                            continue;
                        }
                        jsonList.add(null);
                    }
                }
                jsonStruct = jsonList;
            } else if (obj instanceof Collection) {
                ArrayList<Object> jsonList = new ArrayList<Object>();
                for (Object o : (Collection)obj) {
                    Object jsonVal = this._buildJsonStruct(o, depth - 1);
                    if (jsonVal != null) {
                        jsonList.add(jsonVal);
                        continue;
                    }
                    jsonList.add(null);
                }
                jsonStruct = jsonList;
            } else if (obj instanceof Boolean) {
                jsonStruct = (Boolean)obj;
            } else if (obj instanceof Character) {
                jsonStruct = (Character)obj;
            } else if (obj instanceof Number) {
                jsonStruct = (Number)obj;
            } else if (obj instanceof String) {
                jsonStruct = (String)obj;
            } else {
                Map<String, Object> mapEquivalent;
                block36: {
                    mapEquivalent = null;
                    try {
                        mapEquivalent = BeanIntrospectionUtil.introspect(obj);
                    }
                    catch (Exception e) {
                        if (!log.isLoggable(Level.INFO)) break block36;
                        log.log(Level.INFO, "Faild to introspect a bean.", e);
                    }
                }
                jsonStruct = mapEquivalent != null ? this._buildJsonStruct(mapEquivalent, depth) : obj.toString();
            }
        }
        return jsonStruct;
    }
}

