/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.json.common;

import java.util.HashSet;
import java.util.Set;

public final class TokenTypes {
    public static final int EOF = -1;
    public static final int NULL = 0;
    public static final int COMMA = 3;
    public static final int COLON = 4;
    public static final int LSQUARE = 5;
    public static final int RSQUARE = 6;
    public static final int LCURLY = 7;
    public static final int RCURLY = 8;
    public static final int BOOLEAN = 9;
    public static final int NUMBER = 10;
    public static final int STRING = 11;
    private static final Set<Integer> typeSet = new HashSet<Integer>();

    private TokenTypes() {
    }

    public static boolean isValid(int type) {
        return typeSet.contains(type);
    }

    public static String getTokenName(int type) {
        switch (type) {
            case -1: {
                return "eof";
            }
            case 0: {
                return "null";
            }
            case 3: {
                return "comma";
            }
            case 4: {
                return "colon";
            }
            case 5: {
                return "l-square";
            }
            case 6: {
                return "r-square";
            }
            case 7: {
                return "l-curly";
            }
            case 8: {
                return "r-curly";
            }
            case 9: {
                return "boolean";
            }
            case 10: {
                return "number";
            }
            case 11: {
                return "string";
            }
        }
        return "unknown";
    }

    public static String getDisplayName(int type) {
        switch (type) {
            case -1: {
                return "eof";
            }
            case 0: {
                return "null";
            }
            case 3: {
                return "comma";
            }
            case 4: {
                return "colon";
            }
            case 5: {
                return "left square bracket";
            }
            case 6: {
                return "right square bracket";
            }
            case 7: {
                return "left curly brace";
            }
            case 8: {
                return "right curly brace";
            }
            case 9: {
                return "boolean";
            }
            case 10: {
                return "number";
            }
            case 11: {
                return "string";
            }
        }
        return "unknown type";
    }

    static {
        typeSet.add(-1);
        typeSet.add(0);
        typeSet.add(3);
        typeSet.add(4);
        typeSet.add(5);
        typeSet.add(6);
        typeSet.add(7);
        typeSet.add(8);
        typeSet.add(9);
        typeSet.add(10);
        typeSet.add(11);
    }
}

