/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.json.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniclient.json.LiteJsonParser;
import org.miniclient.json.LiteJsonTokenizer;
import org.miniclient.json.MiniClientJsonException;
import org.miniclient.json.common.JsonNull;
import org.miniclient.json.common.JsonToken;
import org.miniclient.json.common.MapEntry;
import org.miniclient.json.common.TokenTypes;
import org.miniclient.json.parser.MiniClientJsonTokenizer;

public final class MiniClientJsonParser
implements LiteJsonParser {
    private static final Logger log = Logger.getLogger(MiniClientJsonParser.class.getName());
    private static final int HEAD_TRACE_LENGTH = 35;

    protected char[] peekCharStream(LiteJsonTokenizer tokenizer) {
        if (tokenizer instanceof MiniClientJsonTokenizer) {
            return ((MiniClientJsonTokenizer)tokenizer).peekCharStream(35);
        }
        return null;
    }

    @Override
    public Object parse(String jsonStr) throws MiniClientJsonException {
        StringReader sr = new StringReader(jsonStr);
        Object jsonObj = null;
        try {
            jsonObj = this.parse(sr);
        }
        catch (IOException e) {
            throw new MiniClientJsonException("IO error during JSON parsing.", e);
        }
        return jsonObj;
    }

    @Override
    public Object parse(Reader reader) throws MiniClientJsonException, IOException {
        Object topNode = this._parse(reader);
        return topNode;
    }

    private Object _parse(Reader reader) throws MiniClientJsonException {
        if (reader == null) {
            return null;
        }
        MiniClientJsonTokenizer jsonTokenizer = null;
        jsonTokenizer = new MiniClientJsonTokenizer(reader);
        return this._parse(jsonTokenizer);
    }

    private Object _parse(LiteJsonTokenizer tokenizer) throws MiniClientJsonException {
        if (tokenizer == null) {
            return null;
        }
        Object topNode = null;
        int type = this.peekAndGetType(tokenizer);
        if (type == -1 || type == 7 || type == 5) {
            if (type == -1) {
                topNode = this.produceJsonNull(tokenizer);
            } else if (type == 7) {
                topNode = this.produceJsonObject(tokenizer);
            } else if (type == 5) {
                topNode = this.produceJsonArray(tokenizer);
            }
        } else {
            throw new MiniClientJsonException("Json string should be Object or Array. Input tokenType = " + TokenTypes.getDisplayName(type));
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("topnNode = " + topNode);
        }
        return topNode;
    }

    private Map<String, Object> produceJsonObject(LiteJsonTokenizer tokenizer) throws MiniClientJsonException {
        int lcurl = this.nextAndGetType(tokenizer);
        if (lcurl != 7) {
            throw new MiniClientJsonException("JSON object should start with {. ");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        int type = this.peekAndGetType(tokenizer);
        if (type == 8) {
            JsonToken t = tokenizer.next();
        } else {
            Map<String, Object> members = this.produceJsonObjectMembers(tokenizer);
            int rcurl = this.nextAndGetType(tokenizer);
            if (rcurl == 8) {
                map.putAll(members);
            } else {
                throw new MiniClientJsonException("JSON object should end with }. ");
            }
        }
        HashMap<String, Object> jObject = map;
        if (log.isLoggable(Level.FINE)) {
            log.fine("jObject = " + jObject);
        }
        return jObject;
    }

    private Map<String, Object> produceJsonObjectMembers(LiteJsonTokenizer tokenizer) throws MiniClientJsonException {
        HashMap<String, Object> members = new HashMap<String, Object>();
        int type = this.peekAndGetType(tokenizer);
        while (type != 8) {
            Map.Entry<String, Object> member = this.produceJsonObjectMember(tokenizer);
            if (member != null) {
                members.put(member.getKey(), member.getValue());
            }
            type = this.peekAndGetType(tokenizer);
            while (type == 3) {
                JsonToken t = tokenizer.next();
                type = this.peekAndGetType(tokenizer);
            }
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("members = " + members);
        }
        return members;
    }

    private Map.Entry<String, Object> produceJsonObjectMember(LiteJsonTokenizer tokenizer) throws MiniClientJsonException {
        JsonToken keyToken = this.nextAndGetToken(tokenizer);
        int keyType = keyToken.getType();
        if (keyType != 11) {
            throw new MiniClientJsonException("JSON Object member should start with a string key. keyType = " + keyType + "; ");
        }
        String key = (String)keyToken.getValue();
        JsonToken colonToken = this.nextAndGetToken(tokenizer);
        int colonType = colonToken.getType();
        if (colonType != 4) {
            throw new MiniClientJsonException("JSON Object member should include a colon (:). ");
        }
        Object value = null;
        int type = this.peekAndGetType(tokenizer);
        switch (type) {
            case 0: {
                value = this.produceJsonNull(tokenizer);
                break;
            }
            case 9: {
                value = this.produceJsonBoolean(tokenizer);
                break;
            }
            case 10: {
                value = this.produceJsonNumber(tokenizer);
                break;
            }
            case 11: {
                value = this.produceJsonString(tokenizer);
                break;
            }
            case 7: {
                value = this.produceJsonObject(tokenizer);
                break;
            }
            case 5: {
                value = this.produceJsonArray(tokenizer);
                break;
            }
            default: {
                throw new MiniClientJsonException("Json array element not recognized: token = " + tokenizer.peek() + "; ");
            }
        }
        MapEntry<String, Object> member = new MapEntry<String, Object>(key, value);
        if (log.isLoggable(Level.FINER)) {
            log.finer("member = " + member);
        }
        return member;
    }

    private List<Object> produceJsonArray(LiteJsonTokenizer tokenizer) throws MiniClientJsonException {
        int lsq = this.nextAndGetType(tokenizer);
        if (lsq != 5) {
            throw new MiniClientJsonException("JSON array should start with [. ");
        }
        ArrayList<Object> list = new ArrayList<Object>();
        int type = this.peekAndGetType(tokenizer);
        if (type == 6) {
            JsonToken t = tokenizer.next();
        } else {
            List<Object> elements = this.produceJsonArrayElements(tokenizer);
            int rsq = this.nextAndGetType(tokenizer);
            if (rsq == 6) {
                list.addAll(elements);
            } else {
                throw new MiniClientJsonException("JSON array should end with ]. ");
            }
        }
        ArrayList<Object> jArray = list;
        if (log.isLoggable(Level.FINE)) {
            log.fine("jArray = " + jArray);
        }
        return jArray;
    }

    private List<Object> produceJsonArrayElements(LiteJsonTokenizer tokenizer) throws MiniClientJsonException {
        ArrayList<Object> elements = new ArrayList<Object>();
        int type = this.peekAndGetType(tokenizer);
        while (type != 6) {
            Object element = this.produceJsonArrayElement(tokenizer);
            if (element != null) {
                elements.add(element);
            }
            type = this.peekAndGetType(tokenizer);
            while (type == 3) {
                JsonToken t = tokenizer.next();
                type = this.peekAndGetType(tokenizer);
            }
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("elements = " + elements);
        }
        return elements;
    }

    private Object produceJsonArrayElement(LiteJsonTokenizer tokenizer) throws MiniClientJsonException {
        Object element = null;
        int type = this.peekAndGetType(tokenizer);
        switch (type) {
            case 0: {
                element = this.produceJsonNull(tokenizer);
                break;
            }
            case 9: {
                element = this.produceJsonBoolean(tokenizer);
                break;
            }
            case 10: {
                element = this.produceJsonNumber(tokenizer);
                break;
            }
            case 11: {
                element = this.produceJsonString(tokenizer);
                break;
            }
            case 7: {
                element = this.produceJsonObject(tokenizer);
                break;
            }
            case 5: {
                element = this.produceJsonArray(tokenizer);
                break;
            }
            default: {
                throw new MiniClientJsonException("Json array element not recognized: token = " + tokenizer.peek() + "; ");
            }
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("element = " + element);
        }
        return element;
    }

    private JsonToken peekAndGetToken(LiteJsonTokenizer tokenizer) throws MiniClientJsonException {
        JsonToken s = tokenizer.peek();
        if (s == null) {
            throw new MiniClientJsonException("Failed to get the next json token. ");
        }
        return s;
    }

    private int peekAndGetType(LiteJsonTokenizer tokenizer) throws MiniClientJsonException {
        JsonToken s = tokenizer.peek();
        if (s == null) {
            throw new MiniClientJsonException("Failed to get the next json token. ");
        }
        int type = s.getType();
        return type;
    }

    private JsonToken nextAndGetToken(LiteJsonTokenizer tokenizer) throws MiniClientJsonException {
        JsonToken s = tokenizer.next();
        if (s == null) {
            throw new MiniClientJsonException("Failed to get the next json token. ");
        }
        return s;
    }

    private int nextAndGetType(LiteJsonTokenizer tokenizer) throws MiniClientJsonException {
        JsonToken s = tokenizer.next();
        if (s == null) {
            throw new MiniClientJsonException("Failed to get the next json token. ");
        }
        int type = s.getType();
        return type;
    }

    private String produceJsonString(LiteJsonTokenizer tokenizer) throws MiniClientJsonException {
        String jString = null;
        try {
            JsonToken t = tokenizer.next();
            jString = (String)t.getValue();
        }
        catch (Exception e) {
            throw new MiniClientJsonException("Failed to create a String node. ");
        }
        return jString;
    }

    private Number produceJsonNumber(LiteJsonTokenizer tokenizer) throws MiniClientJsonException {
        Number jNumber = null;
        try {
            JsonToken t = tokenizer.next();
            jNumber = (Number)t.getValue();
        }
        catch (Exception e) {
            throw new MiniClientJsonException("Failed to create a Number node. ");
        }
        return jNumber;
    }

    private Boolean produceJsonBoolean(LiteJsonTokenizer tokenizer) throws MiniClientJsonException {
        Boolean jBoolean = null;
        try {
            JsonToken t = tokenizer.next();
            jBoolean = (Boolean)t.getValue();
        }
        catch (Exception e) {
            throw new MiniClientJsonException("Failed to create a Boolean node. ");
        }
        return jBoolean;
    }

    private Object produceJsonNull(LiteJsonTokenizer tokenizer) throws MiniClientJsonException {
        Object jNull = null;
        try {
            JsonToken t = tokenizer.next();
            jNull = JsonNull.NULL;
        }
        catch (Exception e) {
            throw new MiniClientJsonException("Failed to create a Null node. ");
        }
        return jNull;
    }
}

