/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.tool.json.profiler;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniclient.json.MiniClientJsonException;
import org.miniclient.json.builder.MiniClientJsonBuilder;
import org.miniclient.json.parser.MiniClientJsonParser;

public class MiniClientJsonParserRunner {
    private static final Logger log = Logger.getLogger(MiniClientJsonParser.class.getName());
    private MiniClientJsonParser jsonParser = null;

    public MiniClientJsonParserRunner() {
        this.init();
    }

    private void init() {
        this.jsonParser = new MiniClientJsonParser();
    }

    public void runParse() {
        String filePath = "C:\\Projects\\gitprojects\\glass\\app\\appengine\\miniclient\\extra\\mirrorapi.json";
        Object node = null;
        try {
            FileReader reader = new FileReader(filePath);
            node = this.jsonParser.parse((Reader)reader);
            String str = node.toString();
            int len = str.length();
            System.out.println("str.lenth = " + len);
        }
        catch (FileNotFoundException e) {
            log.log(Level.WARNING, "Failed to find the JSON file: filePath = " + filePath, e);
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Failed to parse the JSON file: filePath = " + filePath, e);
        }
        catch (MiniClientJsonException e) {
            log.log(Level.WARNING, "Failed to parse the JSON file: filePath = " + filePath, e);
        }
        String outputPath = "C:\\Projects\\gitprojects\\glass\\app\\appengine\\miniclient\\extra\\sample-output.json";
        MiniClientJsonBuilder jsonBuilder = new MiniClientJsonBuilder();
        String jsonStr = null;
        try {
            jsonStr = jsonBuilder.build(node);
        }
        catch (MiniClientJsonException e) {
            e.printStackTrace();
        }
        if (jsonStr != null) {
            int jsonLen = jsonStr.length();
            System.out.println("jsonStr.length = " + jsonLen);
        } else {
            System.out.println("Failed build JSON string.");
        }
    }

    public static void main(String[] args) {
        System.out.println("Running...");
        MiniClientJsonParserRunner runner = new MiniClientJsonParserRunner();
        for (int counter = 0; counter < 200; ++counter) {
            System.out.println(">>>> counter = " + counter);
            runner.runParse();
            try {
                Thread.sleep(10000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Done.");
    }
}

