/* 
Copyright 2012 Brian Hawkins
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.agileclick.genorm.runtime;

import java.text.DecimalFormat;
import java.util.Locale;
import java.util.StringTokenizer;

public abstract class SQLQuery
	{
	protected Locale m_locale;
	protected Formatter m_formatter;
	
	//---------------------------------------------------------------------------
	public SQLQuery()
		{
		m_formatter = new DefaultFormatter();
		}
		
	//---------------------------------------------------------------------------
	public void setFormatter(Formatter formatter)
		{
		m_formatter = formatter;
		}
		
	//---------------------------------------------------------------------------
	public void setLocale(Locale locale)
		{
		m_formatter.setLocale(locale);
		}
		
	//---------------------------------------------------------------------------
	//---------------------------------------------------------------------------
	public abstract String getQueryName();
	public abstract String getQuery();
	
	//---------------------------------------------------------------------------
	//---------------------------------------------------------------------------
	//---------------------------------------------------------------------------
	}
