/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.shadow.net.bytebuddy.implementation.bytecode.constant;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.agrona.shadow.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.agrona.shadow.net.bytebuddy.description.method.MethodDescription;
import org.agrona.shadow.net.bytebuddy.description.type.TypeDescription;
import org.agrona.shadow.net.bytebuddy.implementation.Implementation;
import org.agrona.shadow.net.bytebuddy.implementation.bytecode.Duplication;
import org.agrona.shadow.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.agrona.shadow.net.bytebuddy.implementation.bytecode.TypeCreation;
import org.agrona.shadow.net.bytebuddy.implementation.bytecode.constant.NullConstant;
import org.agrona.shadow.net.bytebuddy.implementation.bytecode.constant.TextConstant;
import org.agrona.shadow.net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import org.agrona.shadow.net.bytebuddy.jar.asm.MethodVisitor;

@HashCodeAndEqualsPlugin.Enhance
public class SerializedConstant
implements StackManipulation {
    private static final String CHARSET = "ISO-8859-1";
    private final String serialization;

    protected SerializedConstant(String serialization) {
        this.serialization = serialization;
    }

    public static StackManipulation of(Serializable value) {
        if (value == null) {
            return NullConstant.INSTANCE;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            try {
                objectOutputStream.writeObject(value);
            }
            finally {
                objectOutputStream.close();
            }
            return new SerializedConstant(byteArrayOutputStream.toString(CHARSET));
        }
        catch (IOException exception) {
            throw new IllegalStateException("Cannot serialize " + value, exception);
        }
    }

    public boolean isValid() {
        return true;
    }

    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        try {
            return new StackManipulation.Compound(TypeCreation.of(TypeDescription.ForLoadedType.of(ObjectInputStream.class)), Duplication.SINGLE, TypeCreation.of(TypeDescription.ForLoadedType.of(ByteArrayInputStream.class)), Duplication.SINGLE, new TextConstant(this.serialization), new TextConstant(CHARSET), MethodInvocation.invoke(new MethodDescription.ForLoadedMethod(String.class.getMethod("getBytes", String.class))), MethodInvocation.invoke(new MethodDescription.ForLoadedConstructor(ByteArrayInputStream.class.getConstructor(byte[].class))), MethodInvocation.invoke(new MethodDescription.ForLoadedConstructor(ObjectInputStream.class.getConstructor(InputStream.class))), MethodInvocation.invoke(new MethodDescription.ForLoadedMethod(ObjectInputStream.class.getMethod("readObject", new Class[0])))).apply(methodVisitor, implementationContext);
        }
        catch (NoSuchMethodException exception) {
            throw new IllegalStateException("Could not locate Java API method", exception);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.serialization.equals(((SerializedConstant)object).serialization);
    }

    public int hashCode() {
        return 17 * 31 + this.serialization.hashCode();
    }
}

