/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.util.List;
import java.util.Objects;
import org.agrona.concurrent.Agent;

public class CompositeAgent
implements Agent {
    private final Agent[] agents;
    private final String roleName;
    private int agentIndex = 0;

    public CompositeAgent(List<? extends Agent> agents) {
        this(agents.toArray(new Agent[0]));
    }

    public CompositeAgent(Agent ... agents) {
        if (agents.length == 0) {
            throw new IllegalArgumentException("requires at least one sub-agent");
        }
        this.agents = new Agent[agents.length];
        StringBuilder sb = new StringBuilder(agents.length * 16);
        sb.append('[');
        int i = 0;
        for (Agent agent : agents) {
            Objects.requireNonNull(agent, "agent cannot be null");
            sb.append(agent.roleName()).append(',');
            this.agents[i++] = agent;
        }
        sb.setCharAt(sb.length() - 1, ']');
        this.roleName = sb.toString();
    }

    @Override
    public String roleName() {
        return this.roleName;
    }

    @Override
    public void onStart() {
        Throwable ce = null;
        for (Agent agent : this.agents) {
            try {
                agent.onStart();
            }
            catch (Throwable ex) {
                if (ce == null) {
                    ce = new RuntimeException(this.getClass().getName() + ": underlying agent error on start");
                }
                ce.addSuppressed(ex);
            }
        }
        if (ce != null) {
            throw ce;
        }
    }

    @Override
    public int doWork() throws Exception {
        int workCount = 0;
        Agent[] agents = this.agents;
        while (this.agentIndex < agents.length) {
            Agent agent = agents[this.agentIndex++];
            workCount += agent.doWork();
        }
        this.agentIndex = 0;
        return workCount;
    }

    @Override
    public void onClose() {
        Throwable ce = null;
        for (Agent agent : this.agents) {
            try {
                agent.onClose();
            }
            catch (Throwable ex) {
                if (ce == null) {
                    ce = new RuntimeException(this.getClass().getName() + ": underlying agent error on close");
                }
                ce.addSuppressed(ex);
            }
        }
        if (ce != null) {
            throw ce;
        }
    }
}

