/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.AsciiEncoding;
import org.agrona.AsciiNumberFormatException;
import org.agrona.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.LangUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.SystemUtil;
import org.agrona.UnsafeAccess;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.AtomicBuffer;

public class UnsafeBuffer
implements AtomicBuffer {
    public static final int ALIGNMENT = 8;
    public static final String DISABLE_BOUNDS_CHECKS_PROP_NAME = "agrona.disable.bounds.checks";
    public static final boolean SHOULD_BOUNDS_CHECK = !"true".equals(SystemUtil.getProperty("agrona.disable.bounds.checks"));
    private long addressOffset;
    private int capacity;
    private byte[] byteArray;
    private ByteBuffer byteBuffer;

    public UnsafeBuffer() {
        this.wrap(ArrayUtil.EMPTY_BYTE_ARRAY);
    }

    public UnsafeBuffer(byte[] buffer) {
        this.wrap(buffer);
    }

    public UnsafeBuffer(byte[] buffer, int offset, int length) {
        this.wrap(buffer, offset, length);
    }

    public UnsafeBuffer(ByteBuffer buffer) {
        this.wrap(buffer);
    }

    public UnsafeBuffer(ByteBuffer buffer, int offset, int length) {
        this.wrap(buffer, offset, length);
    }

    public UnsafeBuffer(DirectBuffer buffer) {
        this.wrap(buffer);
    }

    public UnsafeBuffer(DirectBuffer buffer, int offset, int length) {
        this.wrap(buffer, offset, length);
    }

    public UnsafeBuffer(long address, int length) {
        this.wrap(address, length);
    }

    @Override
    public void wrap(byte[] buffer) {
        this.capacity = buffer.length;
        this.addressOffset = BufferUtil.ARRAY_BASE_OFFSET;
        this.byteBuffer = null;
        if (buffer != this.byteArray) {
            this.byteArray = buffer;
        }
    }

    @Override
    public void wrap(byte[] buffer, int offset, int length) {
        if (SHOULD_BOUNDS_CHECK) {
            UnsafeBuffer.boundsCheckWrap(offset, length, buffer.length);
        }
        this.capacity = length;
        this.addressOffset = BufferUtil.ARRAY_BASE_OFFSET + (long)offset;
        this.byteBuffer = null;
        if (buffer != this.byteArray) {
            this.byteArray = buffer;
        }
    }

    @Override
    public void wrap(ByteBuffer buffer) {
        this.capacity = buffer.capacity();
        if (buffer != this.byteBuffer) {
            this.byteBuffer = buffer;
        }
        if (buffer.isDirect()) {
            this.byteArray = null;
            this.addressOffset = BufferUtil.address(buffer);
        } else {
            this.byteArray = BufferUtil.array(buffer);
            this.addressOffset = BufferUtil.ARRAY_BASE_OFFSET + (long)BufferUtil.arrayOffset(buffer);
        }
    }

    @Override
    public void wrap(ByteBuffer buffer, int offset, int length) {
        if (SHOULD_BOUNDS_CHECK) {
            UnsafeBuffer.boundsCheckWrap(offset, length, buffer.capacity());
        }
        this.capacity = length;
        if (buffer != this.byteBuffer) {
            this.byteBuffer = buffer;
        }
        if (buffer.isDirect()) {
            this.byteArray = null;
            this.addressOffset = BufferUtil.address(buffer) + (long)offset;
        } else {
            this.byteArray = BufferUtil.array(buffer);
            this.addressOffset = BufferUtil.ARRAY_BASE_OFFSET + (long)BufferUtil.arrayOffset(buffer) + (long)offset;
        }
    }

    @Override
    public void wrap(DirectBuffer buffer) {
        ByteBuffer byteBuffer;
        this.capacity = buffer.capacity();
        this.addressOffset = buffer.addressOffset();
        byte[] byteArray = buffer.byteArray();
        if (byteArray != this.byteArray) {
            this.byteArray = byteArray;
        }
        if ((byteBuffer = buffer.byteBuffer()) != this.byteBuffer) {
            this.byteBuffer = byteBuffer;
        }
    }

    @Override
    public void wrap(DirectBuffer buffer, int offset, int length) {
        ByteBuffer byteBuffer;
        if (SHOULD_BOUNDS_CHECK) {
            UnsafeBuffer.boundsCheckWrap(offset, length, buffer.capacity());
        }
        this.capacity = length;
        this.addressOffset = buffer.addressOffset() + (long)offset;
        byte[] byteArray = buffer.byteArray();
        if (byteArray != this.byteArray) {
            this.byteArray = byteArray;
        }
        if ((byteBuffer = buffer.byteBuffer()) != this.byteBuffer) {
            this.byteBuffer = byteBuffer;
        }
    }

    @Override
    public void wrap(long address, int length) {
        this.capacity = length;
        this.addressOffset = address;
        this.byteArray = null;
        this.byteBuffer = null;
    }

    @Override
    public long addressOffset() {
        return this.addressOffset;
    }

    @Override
    public byte[] byteArray() {
        return this.byteArray;
    }

    @Override
    public ByteBuffer byteBuffer() {
        return this.byteBuffer;
    }

    @Override
    public void setMemory(int index, int length, byte value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
        }
        long offset = this.addressOffset + (long)index;
        if (UnsafeAccess.MEMSET_HACK_REQUIRED && length > UnsafeAccess.MEMSET_HACK_THRESHOLD && 0L == (offset & 1L)) {
            UnsafeAccess.UNSAFE.putByte(this.byteArray, offset, value);
            UnsafeAccess.UNSAFE.setMemory(this.byteArray, offset + 1L, length - 1, value);
        } else {
            UnsafeAccess.UNSAFE.setMemory(this.byteArray, offset, length, value);
        }
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public void checkLimit(int limit) {
        if (limit > this.capacity) {
            throw new IndexOutOfBoundsException("limit=" + limit + " is beyond capacity=" + this.capacity);
        }
    }

    @Override
    public boolean isExpandable() {
        return false;
    }

    @Override
    public void verifyAlignment() {
        if (0L != (this.addressOffset & 7L)) {
            throw new IllegalStateException("AtomicBuffer is not correctly aligned: addressOffset=" + this.addressOffset + " is not divisible by " + 8);
        }
    }

    @Override
    public long getLong(int index, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        long bits = UnsafeAccess.UNSAFE.getLong(this.byteArray, this.addressOffset + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Long.reverseBytes(bits);
        }
        return bits;
    }

    @Override
    public void putLong(int index, long value, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        long bits = value;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Long.reverseBytes(bits);
        }
        UnsafeAccess.UNSAFE.putLong(this.byteArray, this.addressOffset + (long)index, bits);
    }

    @Override
    public long getLong(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        return UnsafeAccess.UNSAFE.getLong(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putLong(int index, long value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        UnsafeAccess.UNSAFE.putLong(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public long getLongVolatile(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        return UnsafeAccess.UNSAFE.getLongVolatile(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putLongVolatile(int index, long value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        UnsafeAccess.UNSAFE.putLongVolatile(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public void putLongOrdered(int index, long value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        UnsafeAccess.UNSAFE.putOrderedLong(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public long addLongOrdered(int index, long increment) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        long offset = this.addressOffset + (long)index;
        byte[] byteArray = this.byteArray;
        long value = UnsafeAccess.UNSAFE.getLong(byteArray, offset);
        UnsafeAccess.UNSAFE.putOrderedLong(byteArray, offset, value + increment);
        return value;
    }

    @Override
    public boolean compareAndSetLong(int index, long expectedValue, long updateValue) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        return UnsafeAccess.UNSAFE.compareAndSwapLong(this.byteArray, this.addressOffset + (long)index, expectedValue, updateValue);
    }

    @Override
    public long getAndSetLong(int index, long value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        return UnsafeAccess.UNSAFE.getAndSetLong(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public long getAndAddLong(int index, long delta) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        return UnsafeAccess.UNSAFE.getAndAddLong(this.byteArray, this.addressOffset + (long)index, delta);
    }

    @Override
    public int getInt(int index, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        int bits = UnsafeAccess.UNSAFE.getInt(this.byteArray, this.addressOffset + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        return bits;
    }

    @Override
    public void putInt(int index, int value, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        int bits = value;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        UnsafeAccess.UNSAFE.putInt(this.byteArray, this.addressOffset + (long)index, bits);
    }

    @Override
    public int getInt(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        return UnsafeAccess.UNSAFE.getInt(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putInt(int index, int value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        UnsafeAccess.UNSAFE.putInt(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public int getIntVolatile(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        return UnsafeAccess.UNSAFE.getIntVolatile(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putIntVolatile(int index, int value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        UnsafeAccess.UNSAFE.putIntVolatile(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public void putIntOrdered(int index, int value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        UnsafeAccess.UNSAFE.putOrderedInt(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public int addIntOrdered(int index, int increment) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        long offset = this.addressOffset + (long)index;
        byte[] byteArray = this.byteArray;
        int value = UnsafeAccess.UNSAFE.getInt(byteArray, offset);
        UnsafeAccess.UNSAFE.putOrderedInt(byteArray, offset, value + increment);
        return value;
    }

    @Override
    public boolean compareAndSetInt(int index, int expectedValue, int updateValue) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        return UnsafeAccess.UNSAFE.compareAndSwapInt(this.byteArray, this.addressOffset + (long)index, expectedValue, updateValue);
    }

    @Override
    public int getAndSetInt(int index, int value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        return UnsafeAccess.UNSAFE.getAndSetInt(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public int getAndAddInt(int index, int delta) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        return UnsafeAccess.UNSAFE.getAndAddInt(this.byteArray, this.addressOffset + (long)index, delta);
    }

    @Override
    public double getDouble(int index, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            long bits = UnsafeAccess.UNSAFE.getLong(this.byteArray, this.addressOffset + (long)index);
            return Double.longBitsToDouble(Long.reverseBytes(bits));
        }
        return UnsafeAccess.UNSAFE.getDouble(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putDouble(int index, double value, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            long bits = Long.reverseBytes(Double.doubleToRawLongBits(value));
            UnsafeAccess.UNSAFE.putLong(this.byteArray, this.addressOffset + (long)index, bits);
        } else {
            UnsafeAccess.UNSAFE.putDouble(this.byteArray, this.addressOffset + (long)index, value);
        }
    }

    @Override
    public double getDouble(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        return UnsafeAccess.UNSAFE.getDouble(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putDouble(int index, double value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        UnsafeAccess.UNSAFE.putDouble(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public float getFloat(int index, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            int bits = UnsafeAccess.UNSAFE.getInt(this.byteArray, this.addressOffset + (long)index);
            return Float.intBitsToFloat(Integer.reverseBytes(bits));
        }
        return UnsafeAccess.UNSAFE.getFloat(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putFloat(int index, float value, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            int bits = Integer.reverseBytes(Float.floatToRawIntBits(value));
            UnsafeAccess.UNSAFE.putInt(this.byteArray, this.addressOffset + (long)index, bits);
        } else {
            UnsafeAccess.UNSAFE.putFloat(this.byteArray, this.addressOffset + (long)index, value);
        }
    }

    @Override
    public float getFloat(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        return UnsafeAccess.UNSAFE.getFloat(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putFloat(int index, float value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        UnsafeAccess.UNSAFE.putFloat(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public short getShort(int index, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        short bits = UnsafeAccess.UNSAFE.getShort(this.byteArray, this.addressOffset + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Short.reverseBytes(bits);
        }
        return bits;
    }

    @Override
    public void putShort(int index, short value, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        short bits = value;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Short.reverseBytes(bits);
        }
        UnsafeAccess.UNSAFE.putShort(this.byteArray, this.addressOffset + (long)index, bits);
    }

    @Override
    public short getShort(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        return UnsafeAccess.UNSAFE.getShort(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putShort(int index, short value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        UnsafeAccess.UNSAFE.putShort(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public short getShortVolatile(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        return UnsafeAccess.UNSAFE.getShortVolatile(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putShortVolatile(int index, short value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        UnsafeAccess.UNSAFE.putShortVolatile(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public byte getByte(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck(index);
        }
        return UnsafeAccess.UNSAFE.getByte(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putByte(int index, byte value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck(index);
        }
        UnsafeAccess.UNSAFE.putByte(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public byte getByteVolatile(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck(index);
        }
        return UnsafeAccess.UNSAFE.getByteVolatile(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putByteVolatile(int index, byte value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck(index);
        }
        UnsafeAccess.UNSAFE.putByteVolatile(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public void getBytes(int index, byte[] dst) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, dst.length);
        }
        UnsafeAccess.UNSAFE.copyMemory(this.byteArray, this.addressOffset + (long)index, dst, BufferUtil.ARRAY_BASE_OFFSET, dst.length);
    }

    @Override
    public void getBytes(int index, byte[] dst, int offset, int length) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
            BufferUtil.boundsCheck(dst, (long)offset, length);
        }
        UnsafeAccess.UNSAFE.copyMemory(this.byteArray, this.addressOffset + (long)index, dst, BufferUtil.ARRAY_BASE_OFFSET + (long)offset, length);
    }

    @Override
    public void getBytes(int index, MutableDirectBuffer dstBuffer, int dstIndex, int length) {
        dstBuffer.putBytes(dstIndex, this, index, length);
    }

    @Override
    public void getBytes(int index, ByteBuffer dstBuffer, int length) {
        int dstOffset = dstBuffer.position();
        this.getBytes(index, dstBuffer, dstOffset, length);
        dstBuffer.position(dstOffset + length);
    }

    @Override
    public void getBytes(int index, ByteBuffer dstBuffer, int dstOffset, int length) {
        long dstBaseOffset;
        byte[] dstByteArray;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
            BufferUtil.boundsCheck(dstBuffer, (long)dstOffset, length);
        }
        if (dstBuffer.isDirect()) {
            dstByteArray = null;
            dstBaseOffset = BufferUtil.address(dstBuffer);
        } else {
            dstByteArray = BufferUtil.array(dstBuffer);
            dstBaseOffset = BufferUtil.ARRAY_BASE_OFFSET + (long)BufferUtil.arrayOffset(dstBuffer);
        }
        UnsafeAccess.UNSAFE.copyMemory(this.byteArray, this.addressOffset + (long)index, dstByteArray, dstBaseOffset + (long)dstOffset, length);
    }

    @Override
    public void putBytes(int index, byte[] src) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, src.length);
        }
        UnsafeAccess.UNSAFE.copyMemory(src, BufferUtil.ARRAY_BASE_OFFSET, this.byteArray, this.addressOffset + (long)index, src.length);
    }

    @Override
    public void putBytes(int index, byte[] src, int offset, int length) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
            BufferUtil.boundsCheck(src, (long)offset, length);
        }
        UnsafeAccess.UNSAFE.copyMemory(src, BufferUtil.ARRAY_BASE_OFFSET + (long)offset, this.byteArray, this.addressOffset + (long)index, length);
    }

    @Override
    public void putBytes(int index, ByteBuffer srcBuffer, int length) {
        int srcIndex = srcBuffer.position();
        this.putBytes(index, srcBuffer, srcIndex, length);
        srcBuffer.position(srcIndex + length);
    }

    @Override
    public void putBytes(int index, ByteBuffer srcBuffer, int srcIndex, int length) {
        long srcBaseOffset;
        byte[] srcByteArray;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
            BufferUtil.boundsCheck(srcBuffer, (long)srcIndex, length);
        }
        if (srcBuffer.isDirect()) {
            srcByteArray = null;
            srcBaseOffset = BufferUtil.address(srcBuffer);
        } else {
            srcByteArray = BufferUtil.array(srcBuffer);
            srcBaseOffset = BufferUtil.ARRAY_BASE_OFFSET + (long)BufferUtil.arrayOffset(srcBuffer);
        }
        UnsafeAccess.UNSAFE.copyMemory(srcByteArray, srcBaseOffset + (long)srcIndex, this.byteArray, this.addressOffset + (long)index, length);
    }

    @Override
    public void putBytes(int index, DirectBuffer srcBuffer, int srcIndex, int length) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
            srcBuffer.boundsCheck(srcIndex, length);
        }
        UnsafeAccess.UNSAFE.copyMemory(srcBuffer.byteArray(), srcBuffer.addressOffset() + (long)srcIndex, this.byteArray, this.addressOffset + (long)index, length);
    }

    @Override
    public char getChar(int index, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        char bits = UnsafeAccess.UNSAFE.getChar(this.byteArray, this.addressOffset + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = (char)Short.reverseBytes((short)bits);
        }
        return bits;
    }

    @Override
    public void putChar(int index, char value, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        char bits = value;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = (char)Short.reverseBytes((short)bits);
        }
        UnsafeAccess.UNSAFE.putChar(this.byteArray, this.addressOffset + (long)index, bits);
    }

    @Override
    public char getChar(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        return UnsafeAccess.UNSAFE.getChar(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putChar(int index, char value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        UnsafeAccess.UNSAFE.putChar(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public char getCharVolatile(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        return UnsafeAccess.UNSAFE.getCharVolatile(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putCharVolatile(int index, char value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        UnsafeAccess.UNSAFE.putCharVolatile(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public String getStringAscii(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        int length = UnsafeAccess.UNSAFE.getInt(this.byteArray, this.addressOffset + (long)index);
        return this.getStringAscii(index, length);
    }

    @Override
    public int getStringAscii(int index, Appendable appendable) {
        this.boundsCheck0(index, 4);
        int length = UnsafeAccess.UNSAFE.getInt(this.byteArray, this.addressOffset + (long)index);
        return this.getStringAscii(index, length, appendable);
    }

    @Override
    public String getStringAscii(int index, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        int bits = UnsafeAccess.UNSAFE.getInt(this.byteArray, this.addressOffset + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        int length = bits;
        return this.getStringAscii(index, length);
    }

    @Override
    public int getStringAscii(int index, Appendable appendable, ByteOrder byteOrder) {
        this.boundsCheck0(index, 4);
        int bits = UnsafeAccess.UNSAFE.getInt(this.byteArray, this.addressOffset + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        int length = bits;
        return this.getStringAscii(index, length, appendable);
    }

    @Override
    public String getStringAscii(int index, int length) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index + 4, length);
        }
        byte[] dst = new byte[length];
        UnsafeAccess.UNSAFE.copyMemory(this.byteArray, this.addressOffset + (long)index + 4L, dst, BufferUtil.ARRAY_BASE_OFFSET, length);
        return new String(dst, StandardCharsets.US_ASCII);
    }

    @Override
    public int getStringAscii(int index, int length, Appendable appendable) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length + 4);
        }
        try {
            int limit = index + 4 + length;
            for (int i = index + 4; i < limit; ++i) {
                char c = (char)UnsafeAccess.UNSAFE.getByte(this.byteArray, this.addressOffset + (long)i);
                appendable.append(c > '\u007f' ? (char)'?' : (char)c);
            }
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
        return length;
    }

    @Override
    public int putStringAscii(int index, String value) {
        int length;
        int n = length = value != null ? value.length() : 0;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length + 4);
        }
        UnsafeAccess.UNSAFE.putInt(this.byteArray, this.addressOffset + (long)index, length);
        for (int i = 0; i < length; ++i) {
            int c = value.charAt(i);
            if (c > 127) {
                c = 63;
            }
            UnsafeAccess.UNSAFE.putByte(this.byteArray, this.addressOffset + 4L + (long)index + (long)i, (byte)c);
        }
        return 4 + length;
    }

    @Override
    public int putStringAscii(int index, CharSequence value) {
        int length;
        int n = length = value != null ? value.length() : 0;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length + 4);
        }
        UnsafeAccess.UNSAFE.putInt(this.byteArray, this.addressOffset + (long)index, length);
        for (int i = 0; i < length; ++i) {
            int c = value.charAt(i);
            if (c > 127) {
                c = 63;
            }
            UnsafeAccess.UNSAFE.putByte(this.byteArray, this.addressOffset + 4L + (long)index + (long)i, (byte)c);
        }
        return 4 + length;
    }

    @Override
    public int putStringAscii(int index, String value, ByteOrder byteOrder) {
        int length;
        int n = length = value != null ? value.length() : 0;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length + 4);
        }
        int bits = length;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        UnsafeAccess.UNSAFE.putInt(this.byteArray, this.addressOffset + (long)index, bits);
        for (int i = 0; i < length; ++i) {
            int c = value.charAt(i);
            if (c > 127) {
                c = 63;
            }
            UnsafeAccess.UNSAFE.putByte(this.byteArray, this.addressOffset + 4L + (long)index + (long)i, (byte)c);
        }
        return 4 + length;
    }

    @Override
    public int putStringAscii(int index, CharSequence value, ByteOrder byteOrder) {
        int length;
        int n = length = value != null ? value.length() : 0;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length + 4);
        }
        int bits = length;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        UnsafeAccess.UNSAFE.putInt(this.byteArray, this.addressOffset + (long)index, bits);
        for (int i = 0; i < length; ++i) {
            int c = value.charAt(i);
            if (c > 127) {
                c = 63;
            }
            UnsafeAccess.UNSAFE.putByte(this.byteArray, this.addressOffset + 4L + (long)index + (long)i, (byte)c);
        }
        return 4 + length;
    }

    @Override
    public String getStringWithoutLengthAscii(int index, int length) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
        }
        byte[] dst = new byte[length];
        UnsafeAccess.UNSAFE.copyMemory(this.byteArray, this.addressOffset + (long)index, dst, BufferUtil.ARRAY_BASE_OFFSET, length);
        return new String(dst, StandardCharsets.US_ASCII);
    }

    @Override
    public int getStringWithoutLengthAscii(int index, int length, Appendable appendable) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
        }
        try {
            int limit = index + length;
            for (int i = index; i < limit; ++i) {
                char c = (char)UnsafeAccess.UNSAFE.getByte(this.byteArray, this.addressOffset + (long)i);
                appendable.append(c > '\u007f' ? (char)'?' : (char)c);
            }
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
        return length;
    }

    @Override
    public int putStringWithoutLengthAscii(int index, String value) {
        int length;
        int n = length = value != null ? value.length() : 0;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
        }
        for (int i = 0; i < length; ++i) {
            int c = value.charAt(i);
            if (c > 127) {
                c = 63;
            }
            UnsafeAccess.UNSAFE.putByte(this.byteArray, this.addressOffset + (long)index + (long)i, (byte)c);
        }
        return length;
    }

    @Override
    public int putStringWithoutLengthAscii(int index, CharSequence value) {
        int length;
        int n = length = value != null ? value.length() : 0;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
        }
        for (int i = 0; i < length; ++i) {
            int c = value.charAt(i);
            if (c > 127) {
                c = 63;
            }
            UnsafeAccess.UNSAFE.putByte(this.byteArray, this.addressOffset + (long)index + (long)i, (byte)c);
        }
        return length;
    }

    @Override
    public int putStringWithoutLengthAscii(int index, String value, int valueOffset, int length) {
        int len;
        int n = len = value != null ? Math.min(value.length() - valueOffset, length) : 0;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, len);
        }
        for (int i = 0; i < len; ++i) {
            int c = value.charAt(valueOffset + i);
            if (c > 127) {
                c = 63;
            }
            UnsafeAccess.UNSAFE.putByte(this.byteArray, this.addressOffset + (long)index + (long)i, (byte)c);
        }
        return len;
    }

    @Override
    public int putStringWithoutLengthAscii(int index, CharSequence value, int valueOffset, int length) {
        int len;
        int n = len = value != null ? Math.min(value.length() - valueOffset, length) : 0;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, len);
        }
        for (int i = 0; i < len; ++i) {
            int c = value.charAt(valueOffset + i);
            if (c > 127) {
                c = 63;
            }
            UnsafeAccess.UNSAFE.putByte(this.byteArray, this.addressOffset + (long)index + (long)i, (byte)c);
        }
        return len;
    }

    @Override
    public String getStringUtf8(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        int length = UnsafeAccess.UNSAFE.getInt(this.byteArray, this.addressOffset + (long)index);
        return this.getStringUtf8(index, length);
    }

    @Override
    public String getStringUtf8(int index, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        int bits = UnsafeAccess.UNSAFE.getInt(this.byteArray, this.addressOffset + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        int length = bits;
        return this.getStringUtf8(index, length);
    }

    @Override
    public String getStringUtf8(int index, int length) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index + 4, length);
        }
        byte[] stringInBytes = new byte[length];
        UnsafeAccess.UNSAFE.copyMemory(this.byteArray, this.addressOffset + (long)index + 4L, stringInBytes, BufferUtil.ARRAY_BASE_OFFSET, length);
        return new String(stringInBytes, StandardCharsets.UTF_8);
    }

    @Override
    public int putStringUtf8(int index, String value) {
        return this.putStringUtf8(index, value, Integer.MAX_VALUE);
    }

    @Override
    public int putStringUtf8(int index, String value, ByteOrder byteOrder) {
        return this.putStringUtf8(index, value, byteOrder, Integer.MAX_VALUE);
    }

    @Override
    public int putStringUtf8(int index, String value, int maxEncodedLength) {
        byte[] bytes;
        byte[] byArray = bytes = value != null ? value.getBytes(StandardCharsets.UTF_8) : BufferUtil.NULL_BYTES;
        if (bytes.length > maxEncodedLength) {
            throw new IllegalArgumentException("Encoded string larger than maximum size: " + maxEncodedLength);
        }
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4 + bytes.length);
        }
        UnsafeAccess.UNSAFE.putInt(this.byteArray, this.addressOffset + (long)index, bytes.length);
        UnsafeAccess.UNSAFE.copyMemory(bytes, BufferUtil.ARRAY_BASE_OFFSET, this.byteArray, this.addressOffset + (long)index + 4L, bytes.length);
        return 4 + bytes.length;
    }

    @Override
    public int putStringUtf8(int index, String value, ByteOrder byteOrder, int maxEncodedLength) {
        byte[] bytes;
        byte[] byArray = bytes = value != null ? value.getBytes(StandardCharsets.UTF_8) : BufferUtil.NULL_BYTES;
        if (bytes.length > maxEncodedLength) {
            throw new IllegalArgumentException("Encoded string larger than maximum size: " + maxEncodedLength);
        }
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4 + bytes.length);
        }
        int bits = bytes.length;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        UnsafeAccess.UNSAFE.putInt(this.byteArray, this.addressOffset + (long)index, bits);
        UnsafeAccess.UNSAFE.copyMemory(bytes, BufferUtil.ARRAY_BASE_OFFSET, this.byteArray, this.addressOffset + (long)index + 4L, bytes.length);
        return 4 + bytes.length;
    }

    @Override
    public String getStringWithoutLengthUtf8(int index, int length) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
        }
        byte[] stringInBytes = new byte[length];
        UnsafeAccess.UNSAFE.copyMemory(this.byteArray, this.addressOffset + (long)index, stringInBytes, BufferUtil.ARRAY_BASE_OFFSET, length);
        return new String(stringInBytes, StandardCharsets.UTF_8);
    }

    @Override
    public int putStringWithoutLengthUtf8(int index, String value) {
        byte[] bytes;
        byte[] byArray = bytes = value != null ? value.getBytes(StandardCharsets.UTF_8) : BufferUtil.NULL_BYTES;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, bytes.length);
        }
        UnsafeAccess.UNSAFE.copyMemory(bytes, BufferUtil.ARRAY_BASE_OFFSET, this.byteArray, this.addressOffset + (long)index, bytes.length);
        return bytes.length;
    }

    @Override
    public int parseNaturalIntAscii(int index, int length) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
        }
        if (length <= 0) {
            throw new AsciiNumberFormatException("empty string: index=" + index + " length=" + length);
        }
        if (length < 10) {
            return this.parsePositiveIntAscii(index, length, index, index + length);
        }
        long tally = this.parsePositiveIntAsciiOverflowCheck(index, length, index, index + length);
        if (tally >= AsciiEncoding.INTEGER_ABSOLUTE_MIN_VALUE) {
            this.throwParseIntOverflowError(index, length);
        }
        return (int)tally;
    }

    @Override
    public long parseNaturalLongAscii(int index, int length) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
        }
        if (length <= 0) {
            throw new AsciiNumberFormatException("empty string: index=" + index + " length=" + length);
        }
        if (length < 19) {
            return this.parsePositiveLongAscii(index, length, index, index + length);
        }
        return this.parseLongAsciiOverflowCheck(index, length, AsciiEncoding.LONG_MAX_VALUE_DIGITS, index, index + length);
    }

    @Override
    public int parseIntAscii(int index, int length) {
        int end;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
        }
        if (length <= 0) {
            throw new AsciiNumberFormatException("empty string: index=" + index + " length=" + length);
        }
        boolean negative = 45 == UnsafeAccess.UNSAFE.getByte(this.byteArray, this.addressOffset + (long)index);
        int i = index;
        if (negative) {
            ++i;
            if (1 == length) {
                this.throwParseIntError(index, length);
            }
        }
        if ((end = index + length) - i < 10) {
            int tally = this.parsePositiveIntAscii(index, length, i, end);
            return negative ? -tally : tally;
        }
        long tally = this.parsePositiveIntAsciiOverflowCheck(index, length, i, end);
        if (tally > AsciiEncoding.INTEGER_ABSOLUTE_MIN_VALUE || AsciiEncoding.INTEGER_ABSOLUTE_MIN_VALUE == tally && !negative) {
            this.throwParseIntOverflowError(index, length);
        }
        return (int)(negative ? -tally : tally);
    }

    @Override
    public long parseLongAscii(int index, int length) {
        int end;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
        }
        if (length <= 0) {
            throw new AsciiNumberFormatException("empty string: index=" + index + " length=" + length);
        }
        boolean negative = 45 == UnsafeAccess.UNSAFE.getByte(this.byteArray, this.addressOffset + (long)index);
        int i = index;
        if (negative) {
            ++i;
            if (1 == length) {
                this.throwParseLongError(index, length);
            }
        }
        if ((end = index + length) - i < 19) {
            long tally = this.parsePositiveLongAscii(index, length, i, end);
            return negative ? -tally : tally;
        }
        if (negative) {
            return -this.parseLongAsciiOverflowCheck(index, length, AsciiEncoding.LONG_MIN_VALUE_DIGITS, i, end);
        }
        return this.parseLongAsciiOverflowCheck(index, length, AsciiEncoding.LONG_MAX_VALUE_DIGITS, i, end);
    }

    @Override
    public int putIntAscii(int index, int value) {
        int length;
        int digitCount;
        if (value == 0) {
            this.putByte(index, (byte)48);
            return 1;
        }
        if (value == Integer.MIN_VALUE) {
            this.putBytes(index, AsciiEncoding.MIN_INTEGER_VALUE);
            return AsciiEncoding.MIN_INTEGER_VALUE.length;
        }
        byte[] dest = this.byteArray;
        long offset = this.addressOffset + (long)index;
        int quotient = value;
        if (value < 0) {
            quotient = -quotient;
            digitCount = AsciiEncoding.digitCount(quotient);
            length = digitCount + 1;
            if (SHOULD_BOUNDS_CHECK) {
                this.boundsCheck0(index, length);
            }
            UnsafeAccess.UNSAFE.putByte(dest, offset, (byte)45);
            ++offset;
        } else {
            length = digitCount = AsciiEncoding.digitCount(quotient);
            if (SHOULD_BOUNDS_CHECK) {
                this.boundsCheck0(index, length);
            }
        }
        UnsafeBuffer.putPositiveIntAscii(dest, offset, quotient, digitCount);
        return length;
    }

    @Override
    public int putNaturalIntAscii(int index, int value) {
        if (value == 0) {
            this.putByte(index, (byte)48);
            return 1;
        }
        int digitCount = AsciiEncoding.digitCount(value);
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, digitCount);
        }
        UnsafeBuffer.putPositiveIntAscii(this.byteArray, this.addressOffset + (long)index, value, digitCount);
        return digitCount;
    }

    @Override
    public void putNaturalPaddedIntAscii(int offset, int length, int value) {
        int end = offset + length;
        int remainder = value;
        for (int index = end - 1; index >= offset; --index) {
            int digit = remainder % 10;
            remainder /= 10;
            this.putByte(index, (byte)(48 + digit));
        }
        if (remainder != 0) {
            throw new NumberFormatException("Cannot write " + value + " in " + length + " bytes");
        }
    }

    @Override
    public int putNaturalIntAsciiFromEnd(int value, int endExclusive) {
        int index = endExclusive;
        for (int remainder = value; remainder > 0; remainder /= 10) {
            int digit = remainder % 10;
            this.putByte(--index, (byte)(48 + digit));
        }
        return index;
    }

    @Override
    public int putNaturalLongAscii(int index, long value) {
        if (value == 0L) {
            this.putByte(index, (byte)48);
            return 1;
        }
        int digitCount = AsciiEncoding.digitCount(value);
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, digitCount);
        }
        UnsafeBuffer.putPositiveLongAscii(this.byteArray, this.addressOffset + (long)index, value, digitCount);
        return digitCount;
    }

    @Override
    public int putLongAscii(int index, long value) {
        int length;
        int digitCount;
        if (value == 0L) {
            this.putByte(index, (byte)48);
            return 1;
        }
        if (value == Long.MIN_VALUE) {
            this.putBytes(index, AsciiEncoding.MIN_LONG_VALUE);
            return AsciiEncoding.MIN_LONG_VALUE.length;
        }
        byte[] dest = this.byteArray;
        long offset = this.addressOffset + (long)index;
        long quotient = value;
        if (value < 0L) {
            quotient = -quotient;
            digitCount = AsciiEncoding.digitCount(quotient);
            length = digitCount + 1;
            if (SHOULD_BOUNDS_CHECK) {
                this.boundsCheck0(index, length);
            }
            UnsafeAccess.UNSAFE.putByte(dest, offset, (byte)45);
            ++offset;
        } else {
            length = digitCount = AsciiEncoding.digitCount(quotient);
            if (SHOULD_BOUNDS_CHECK) {
                this.boundsCheck0(index, length);
            }
        }
        UnsafeBuffer.putPositiveLongAscii(dest, offset, quotient, digitCount);
        return length;
    }

    @Override
    public void boundsCheck(int index, int length) {
        this.boundsCheck0(index, length);
    }

    @Override
    public int wrapAdjustment() {
        long offset = this.byteArray != null ? BufferUtil.ARRAY_BASE_OFFSET : BufferUtil.address(this.byteBuffer);
        return (int)(this.addressOffset - offset);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UnsafeBuffer that = (UnsafeBuffer)obj;
        if (this.capacity != that.capacity) {
            return false;
        }
        byte[] thisByteArray = this.byteArray;
        byte[] thatByteArray = that.byteArray;
        long thisOffset = this.addressOffset;
        long thatOffset = that.addressOffset;
        int length = this.capacity;
        for (int i = 0; i < length; ++i) {
            if (UnsafeAccess.UNSAFE.getByte(thisByteArray, thisOffset + (long)i) == UnsafeAccess.UNSAFE.getByte(thatByteArray, thatOffset + (long)i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        byte[] byteArray = this.byteArray;
        long addressOffset = this.addressOffset;
        int length = this.capacity;
        for (int i = 0; i < length; ++i) {
            hashCode = 31 * hashCode + UnsafeAccess.UNSAFE.getByte(byteArray, addressOffset + (long)i);
        }
        return hashCode;
    }

    @Override
    public int compareTo(DirectBuffer that) {
        int thisCapacity = this.capacity;
        int thatCapacity = that.capacity();
        byte[] thisByteArray = this.byteArray;
        byte[] thatByteArray = that.byteArray();
        long thisOffset = this.addressOffset;
        long thatOffset = that.addressOffset();
        int length = Math.min(thisCapacity, thatCapacity);
        for (int i = 0; i < length; ++i) {
            int cmp = Byte.compare(UnsafeAccess.UNSAFE.getByte(thisByteArray, thisOffset + (long)i), UnsafeAccess.UNSAFE.getByte(thatByteArray, thatOffset + (long)i));
            if (0 == cmp) continue;
            return cmp;
        }
        if (thisCapacity != thatCapacity) {
            return thisCapacity - thatCapacity;
        }
        return 0;
    }

    public String toString() {
        return "UnsafeBuffer{addressOffset=" + this.addressOffset + ", capacity=" + this.capacity + ", byteArray=" + this.byteArray + ", byteBuffer=" + this.byteBuffer + '}';
    }

    private void boundsCheck(int index) {
        if (index < 0 || index >= this.capacity) {
            throw new IndexOutOfBoundsException("index=" + index + " capacity=" + this.capacity);
        }
    }

    private void boundsCheck0(int index, int length) {
        long resultingPosition = (long)index + (long)length;
        if (index < 0 || length < 0 || resultingPosition > (long)this.capacity) {
            throw new IndexOutOfBoundsException("index=" + index + " length=" + length + " capacity=" + this.capacity);
        }
    }

    private int parsePositiveIntAscii(int index, int length, int startIndex, int end) {
        byte digit;
        int quartet;
        long offset = this.addressOffset;
        byte[] src = this.byteArray;
        int i = startIndex;
        int tally = 0;
        while (end - i >= 4 && AsciiEncoding.isFourDigitsAsciiEncodedNumber(quartet = UnsafeAccess.UNSAFE.getInt(src, offset + (long)i))) {
            if (BufferUtil.NATIVE_BYTE_ORDER != ByteOrder.LITTLE_ENDIAN) {
                quartet = Integer.reverseBytes(quartet);
            }
            tally = tally * 10000 + AsciiEncoding.parseFourDigitsLittleEndian(quartet);
            i += 4;
        }
        while (i < end && AsciiEncoding.isDigit(digit = UnsafeAccess.UNSAFE.getByte(src, offset + (long)i))) {
            tally = tally * 10 + (digit - 48);
            ++i;
        }
        if (i != end) {
            this.throwParseIntError(index, length);
        }
        return tally;
    }

    private long parsePositiveIntAsciiOverflowCheck(int index, int length, int startIndex, int end) {
        if (end - startIndex > 10) {
            this.throwParseIntOverflowError(index, length);
        }
        long offset = this.addressOffset;
        byte[] src = this.byteArray;
        int i = startIndex;
        long tally = 0L;
        long octet = UnsafeAccess.UNSAFE.getLong(src, offset + (long)i);
        if (AsciiEncoding.isEightDigitAsciiEncodedNumber(octet)) {
            byte digit;
            if (BufferUtil.NATIVE_BYTE_ORDER != ByteOrder.LITTLE_ENDIAN) {
                octet = Long.reverseBytes(octet);
            }
            tally = AsciiEncoding.parseEightDigitsLittleEndian(octet);
            i += 8;
            while (i < end && AsciiEncoding.isDigit(digit = UnsafeAccess.UNSAFE.getByte(src, offset + (long)i))) {
                tally = tally * 10L + (long)(digit - 48);
                ++i;
            }
        }
        if (i != end) {
            this.throwParseIntError(index, length);
        }
        return tally;
    }

    private void throwParseIntError(int index, int length) {
        throw new AsciiNumberFormatException("error parsing int: " + this.getStringWithoutLengthAscii(index, length));
    }

    private void throwParseIntOverflowError(int index, int length) {
        throw new AsciiNumberFormatException("int overflow parsing: " + this.getStringWithoutLengthAscii(index, length));
    }

    private long parsePositiveLongAscii(int index, int length, int startIndex, int end) {
        byte digit;
        int quartet;
        long octet;
        long offset = this.addressOffset;
        byte[] src = this.byteArray;
        int i = startIndex;
        long tally = 0L;
        while (end - i >= 8 && AsciiEncoding.isEightDigitAsciiEncodedNumber(octet = UnsafeAccess.UNSAFE.getLong(src, offset + (long)i))) {
            if (BufferUtil.NATIVE_BYTE_ORDER != ByteOrder.LITTLE_ENDIAN) {
                octet = Long.reverseBytes(octet);
            }
            tally = tally * 100000000L + (long)AsciiEncoding.parseEightDigitsLittleEndian(octet);
            i += 8;
        }
        while (end - i >= 4 && AsciiEncoding.isFourDigitsAsciiEncodedNumber(quartet = UnsafeAccess.UNSAFE.getInt(src, offset + (long)i))) {
            if (BufferUtil.NATIVE_BYTE_ORDER != ByteOrder.LITTLE_ENDIAN) {
                quartet = Integer.reverseBytes(quartet);
            }
            tally = tally * 10000L + (long)AsciiEncoding.parseFourDigitsLittleEndian(quartet);
            i += 4;
        }
        while (i < end && AsciiEncoding.isDigit(digit = UnsafeAccess.UNSAFE.getByte(src, offset + (long)i))) {
            tally = tally * 10L + (long)(digit - 48);
            ++i;
        }
        if (i != end) {
            this.throwParseLongError(index, length);
        }
        return tally;
    }

    private long parseLongAsciiOverflowCheck(int index, int length, int[] maxValue, int startIndex, int end) {
        byte digit;
        long octet;
        if (end - startIndex > 19) {
            this.throwParseLongOverflowError(index, length);
        }
        long offset = this.addressOffset;
        byte[] src = this.byteArray;
        int i = startIndex;
        int k = 0;
        boolean checkOverflow = true;
        long tally = 0L;
        while (end - i >= 8 && AsciiEncoding.isEightDigitAsciiEncodedNumber(octet = UnsafeAccess.UNSAFE.getLong(src, offset + (long)i))) {
            if (BufferUtil.NATIVE_BYTE_ORDER != ByteOrder.LITTLE_ENDIAN) {
                octet = Long.reverseBytes(octet);
            }
            int eightDigits = AsciiEncoding.parseEightDigitsLittleEndian(octet);
            if (checkOverflow) {
                if (eightDigits > maxValue[k]) {
                    this.throwParseLongOverflowError(index, length);
                } else if (eightDigits < maxValue[k]) {
                    checkOverflow = false;
                }
                ++k;
            }
            tally = tally * 100000000L + (long)eightDigits;
            i += 8;
        }
        int lastDigits = 0;
        while (i < end && AsciiEncoding.isDigit(digit = UnsafeAccess.UNSAFE.getByte(src, offset + (long)i))) {
            lastDigits = lastDigits * 10 + (digit - 48);
            ++i;
        }
        if (i != end) {
            this.throwParseLongError(index, length);
        } else if (checkOverflow && lastDigits > maxValue[k]) {
            this.throwParseLongOverflowError(index, length);
        }
        return tally * 1000L + (long)lastDigits;
    }

    private void throwParseLongError(int index, int length) {
        throw new AsciiNumberFormatException("error parsing long: " + this.getStringWithoutLengthAscii(index, length));
    }

    private void throwParseLongOverflowError(int index, int length) {
        throw new AsciiNumberFormatException("long overflow parsing: " + this.getStringWithoutLengthAscii(index, length));
    }

    private static void boundsCheckWrap(int offset, int length, int capacity) {
        if (offset < 0) {
            throw new IllegalArgumentException("invalid offset: " + offset);
        }
        if (length < 0) {
            throw new IllegalArgumentException("invalid length: " + length);
        }
        if (offset > capacity - length || length > capacity - offset) {
            throw new IllegalArgumentException("offset=" + offset + " length=" + length + " not valid for capacity=" + capacity);
        }
    }

    private static void putPositiveIntAscii(byte[] dest, long offset, int value, int digitCount) {
        int position;
        int quotient;
        int i = digitCount;
        for (quotient = value; quotient >= 10000; quotient /= 10000) {
            int lastFourDigits = quotient % 10000;
            int p1 = lastFourDigits / 100 << 1;
            int p2 = lastFourDigits % 100 << 1;
            UnsafeAccess.UNSAFE.putByte(dest, offset + (long)(i -= 4), AsciiEncoding.ASCII_DIGITS[p1]);
            UnsafeAccess.UNSAFE.putByte(dest, offset + (long)i + 1L, AsciiEncoding.ASCII_DIGITS[p1 + 1]);
            UnsafeAccess.UNSAFE.putByte(dest, offset + (long)i + 2L, AsciiEncoding.ASCII_DIGITS[p2]);
            UnsafeAccess.UNSAFE.putByte(dest, offset + (long)i + 3L, AsciiEncoding.ASCII_DIGITS[p2 + 1]);
        }
        if (quotient >= 100) {
            position = quotient % 100 << 1;
            quotient /= 100;
            UnsafeAccess.UNSAFE.putByte(dest, offset + (long)i - 1L, AsciiEncoding.ASCII_DIGITS[position + 1]);
            UnsafeAccess.UNSAFE.putByte(dest, offset + (long)i - 2L, AsciiEncoding.ASCII_DIGITS[position]);
        }
        if (quotient >= 10) {
            position = quotient << 1;
            UnsafeAccess.UNSAFE.putByte(dest, offset + 1L, AsciiEncoding.ASCII_DIGITS[position + 1]);
            UnsafeAccess.UNSAFE.putByte(dest, offset, AsciiEncoding.ASCII_DIGITS[position]);
        } else {
            UnsafeAccess.UNSAFE.putByte(dest, offset, (byte)(48 + quotient));
        }
    }

    private static void putPositiveLongAscii(byte[] dest, long offset, long value, int digitCount) {
        long quotient;
        int i = digitCount;
        for (quotient = value; quotient >= 100000000L; quotient /= 100000000L) {
            int lastEightDigits = (int)(quotient % 100000000L);
            int upperPart = lastEightDigits / 10000;
            int lowerPart = lastEightDigits % 10000;
            int u1 = upperPart / 100 << 1;
            int u2 = upperPart % 100 << 1;
            int l1 = lowerPart / 100 << 1;
            int l2 = lowerPart % 100 << 1;
            UnsafeAccess.UNSAFE.putByte(dest, offset + (long)(i -= 8), AsciiEncoding.ASCII_DIGITS[u1]);
            UnsafeAccess.UNSAFE.putByte(dest, offset + (long)i + 1L, AsciiEncoding.ASCII_DIGITS[u1 + 1]);
            UnsafeAccess.UNSAFE.putByte(dest, offset + (long)i + 2L, AsciiEncoding.ASCII_DIGITS[u2]);
            UnsafeAccess.UNSAFE.putByte(dest, offset + (long)i + 3L, AsciiEncoding.ASCII_DIGITS[u2 + 1]);
            UnsafeAccess.UNSAFE.putByte(dest, offset + (long)i + 4L, AsciiEncoding.ASCII_DIGITS[l1]);
            UnsafeAccess.UNSAFE.putByte(dest, offset + (long)i + 5L, AsciiEncoding.ASCII_DIGITS[l1 + 1]);
            UnsafeAccess.UNSAFE.putByte(dest, offset + (long)i + 6L, AsciiEncoding.ASCII_DIGITS[l2]);
            UnsafeAccess.UNSAFE.putByte(dest, offset + (long)i + 7L, AsciiEncoding.ASCII_DIGITS[l2 + 1]);
        }
        UnsafeBuffer.putPositiveIntAscii(dest, offset, (int)quotient, i);
    }
}

