/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;

public class LongHashSet
extends AbstractSet<Long> {
    public static final int DEFAULT_INITIAL_CAPACITY = 8;
    static final long MISSING_VALUE = -1L;
    private final boolean shouldAvoidAllocation;
    private boolean containsMissingValue;
    private final float loadFactor;
    private int resizeThreshold;
    private int sizeOfArrayValues;
    private long[] values;
    private LongIterator iterator;

    public LongHashSet() {
        this(8);
    }

    public LongHashSet(int proposedCapacity) {
        this(proposedCapacity, 0.65f, true);
    }

    public LongHashSet(int proposedCapacity, float loadFactor) {
        this(proposedCapacity, loadFactor, true);
    }

    public LongHashSet(int proposedCapacity, float loadFactor, boolean shouldAvoidAllocation) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.shouldAvoidAllocation = shouldAvoidAllocation;
        this.loadFactor = loadFactor;
        this.sizeOfArrayValues = 0;
        int capacity = BitUtil.findNextPositivePowerOfTwo(Math.max(8, proposedCapacity));
        this.resizeThreshold = (int)((float)capacity * loadFactor);
        this.values = new long[capacity];
        Arrays.fill(this.values, -1L);
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.values.length;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    @Override
    public boolean add(Long value) {
        return this.add((long)value);
    }

    @Override
    public boolean add(long value) {
        long oldValue;
        if (-1L == value) {
            boolean previousContainsMissingValue = this.containsMissingValue;
            this.containsMissingValue = true;
            return !previousContainsMissingValue;
        }
        long[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(value, mask);
        while (-1L != (oldValue = values[index])) {
            if (oldValue == value) {
                return false;
            }
            index = LongHashSet.next(index, mask);
        }
        values[index] = value;
        ++this.sizeOfArrayValues;
        if (this.sizeOfArrayValues > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return true;
    }

    private void increaseCapacity() {
        int newCapacity = this.values.length * 2;
        if (newCapacity < 0) {
            throw new IllegalStateException("max capacity reached at size=" + this.size());
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        long[] values;
        int capacity = newCapacity;
        int mask = newCapacity - 1;
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        long[] tempValues = new long[capacity];
        Arrays.fill(tempValues, -1L);
        for (long value : values = this.values) {
            if (-1L == value) continue;
            int newHash = Hashing.hash(value, mask);
            while (-1L != tempValues[newHash]) {
                ++newHash;
                newHash &= mask;
            }
            tempValues[newHash] = value;
        }
        this.values = tempValues;
    }

    @Override
    public boolean remove(Object value) {
        return this.remove((Long)value);
    }

    public boolean remove(long value) {
        long oldValue;
        if (-1L == value) {
            boolean previousContainsMissingValue = this.containsMissingValue;
            this.containsMissingValue = false;
            return previousContainsMissingValue;
        }
        long[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(value, mask);
        while (-1L != (oldValue = values[index])) {
            if (oldValue == value) {
                values[index] = -1L;
                this.compactChain(index);
                --this.sizeOfArrayValues;
                return true;
            }
            index = LongHashSet.next(index, mask);
        }
        return false;
    }

    private static int next(int index, int mask) {
        return index + 1 & mask;
    }

    void compactChain(int deleteIndex) {
        long[] values = this.values;
        int mask = values.length - 1;
        int index = deleteIndex;
        long value;
        while (-1L != (value = values[index = LongHashSet.next(index, mask)])) {
            int hash = Hashing.hash(value, mask);
            if ((index >= hash || hash > deleteIndex && deleteIndex > index) && (hash > deleteIndex || deleteIndex > index)) continue;
            values[deleteIndex] = value;
            values[index] = -1L;
            deleteIndex = index;
        }
        return;
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, idealCapacity)));
    }

    @Override
    public boolean contains(Object value) {
        return this.contains((Long)value);
    }

    public boolean contains(long value) {
        long existingValue;
        if (-1L == value) {
            return this.containsMissingValue;
        }
        int mask = this.values.length - 1;
        int index = Hashing.hash(value, mask);
        while (-1L != (existingValue = this.values[index])) {
            if (existingValue == value) {
                return true;
            }
            index = LongHashSet.next(index, mask);
        }
        return false;
    }

    @Override
    public int size() {
        return this.sizeOfArrayValues + (this.containsMissingValue ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void clear() {
        if (this.size() > 0) {
            Arrays.fill(this.values, -1L);
            this.sizeOfArrayValues = 0;
            this.containsMissingValue = false;
        }
    }

    @Override
    public boolean addAll(Collection<? extends Long> coll) {
        boolean added = false;
        for (Long l : coll) {
            added |= this.add(l);
        }
        return added;
    }

    public boolean addAll(LongHashSet coll) {
        boolean acc = false;
        for (long value : coll.values) {
            if (-1L == value) continue;
            acc |= this.add(value);
        }
        if (coll.containsMissingValue) {
            acc |= this.add(-1L);
        }
        return acc;
    }

    public boolean containsAll(LongHashSet coll) {
        for (long value : coll.values) {
            if (-1L == value || this.contains(value)) continue;
            return false;
        }
        return this.containsMissingValue || !coll.containsMissingValue;
    }

    public LongHashSet difference(LongHashSet other) {
        long[] values;
        LongHashSet difference = null;
        for (long value : values = this.values) {
            if (-1L == value || other.contains(value)) continue;
            if (null == difference) {
                difference = new LongHashSet();
            }
            difference.add(value);
        }
        if (this.containsMissingValue && !other.containsMissingValue) {
            if (null == difference) {
                difference = new LongHashSet();
            }
            difference.add(-1L);
        }
        return difference;
    }

    @Override
    public boolean removeIf(Predicate<? super Long> filter) {
        return super.removeIf(filter);
    }

    public boolean removeIfLong(LongPredicate filter) {
        boolean removed = false;
        LongIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!filter.test(iterator.nextValue())) continue;
            iterator.remove();
            removed = true;
        }
        return removed;
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        boolean removed = false;
        for (Object value : coll) {
            removed |= this.remove(value);
        }
        return removed;
    }

    public boolean removeAll(LongHashSet coll) {
        boolean removed = false;
        for (long value : coll.values) {
            if (-1L == value) continue;
            removed |= this.remove(value);
        }
        if (coll.containsMissingValue) {
            removed |= this.remove(-1L);
        }
        return removed;
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        boolean removed = false;
        for (long value : this.values) {
            if (-1L == value || coll.contains(value)) continue;
            values[i] = -1L;
            --this.sizeOfArrayValues;
            removed = true;
        }
        if (removed && this.sizeOfArrayValues > 0) {
            int newCapacity = Math.max(8, BitUtil.findNextPositivePowerOfTwo(this.sizeOfArrayValues));
            this.rehash(newCapacity);
        }
        if (this.containsMissingValue && !coll.contains(-1L)) {
            this.containsMissingValue = false;
            removed = true;
        }
        return removed;
    }

    public boolean retainAll(LongHashSet coll) {
        boolean removed = false;
        for (long value : this.values) {
            if (-1L == value || coll.contains(value)) continue;
            this.values[i] = -1L;
            --this.sizeOfArrayValues;
            removed = true;
        }
        if (removed && this.sizeOfArrayValues > 0) {
            int newCapacity = Math.max(8, BitUtil.findNextPositivePowerOfTwo(this.sizeOfArrayValues));
            this.rehash(newCapacity);
        }
        if (this.containsMissingValue && !coll.contains(-1L)) {
            this.containsMissingValue = false;
            removed = true;
        }
        return removed;
    }

    public LongIterator iterator() {
        LongIterator iterator = this.iterator;
        if (null == iterator) {
            iterator = new LongIterator();
            if (this.shouldAvoidAllocation) {
                this.iterator = iterator;
            }
        }
        return iterator.reset();
    }

    public void forEachLong(LongConsumer action) {
        if (this.sizeOfArrayValues > 0) {
            long[] values;
            for (long v : values = this.values) {
                if (-1L == v) continue;
                action.accept(v);
            }
        }
        if (this.containsMissingValue) {
            action.accept(-1L);
        }
    }

    public void copy(LongHashSet that) {
        if (this.values.length != that.values.length) {
            throw new IllegalArgumentException("cannot copy object: masks not equal");
        }
        System.arraycopy(that.values, 0, this.values, 0, this.values.length);
        this.sizeOfArrayValues = that.sizeOfArrayValues;
        this.containsMissingValue = that.containsMissingValue;
    }

    @Override
    public String toString() {
        long[] values;
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (long value : values = this.values) {
            if (-1L == value) continue;
            sb.append(value).append(", ");
        }
        if (this.containsMissingValue) {
            sb.append(-1L).append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Class<Long> componentType = a.getClass().getComponentType();
        if (!componentType.isAssignableFrom(Long.class)) {
            throw new ArrayStoreException("cannot store Longs in array of type " + componentType);
        }
        int size = this.size();
        Object[] arrayCopy = a.length >= size ? a : (Object[])Array.newInstance(componentType, size);
        this.copyValues(arrayCopy);
        return arrayCopy;
    }

    @Override
    public Object[] toArray() {
        Object[] arrayCopy = new Object[this.size()];
        this.copyValues(arrayCopy);
        return arrayCopy;
    }

    private void copyValues(Object[] arrayCopy) {
        long[] values;
        int i = 0;
        for (long value : values = this.values) {
            if (-1L == value) continue;
            arrayCopy[i++] = value;
        }
        if (this.containsMissingValue) {
            arrayCopy[this.sizeOfArrayValues] = -1L;
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof LongHashSet) {
            LongHashSet otherSet = (LongHashSet)other;
            return otherSet.containsMissingValue == this.containsMissingValue && otherSet.sizeOfArrayValues == this.sizeOfArrayValues && this.containsAll(otherSet);
        }
        if (!(other instanceof Set)) {
            return false;
        }
        Set c = (Set)other;
        if (c.size() != this.size()) {
            return false;
        }
        try {
            return this.containsAll(c);
        }
        catch (ClassCastException | NullPointerException ignore) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (long value : this.values) {
            if (-1L == value) continue;
            hashCode += Long.hashCode(value);
        }
        if (this.containsMissingValue) {
            hashCode += Long.hashCode(-1L);
        }
        return hashCode;
    }

    public final class LongIterator
    implements Iterator<Long> {
        private int remaining;
        private int positionCounter;
        private int stopCounter;
        private boolean isPositionValid = false;

        LongIterator reset() {
            int length;
            this.remaining = LongHashSet.this.size();
            long[] values = LongHashSet.this.values;
            int i = length = values.length;
            if (-1L != values[length - 1]) {
                for (i = 0; i < length && -1L != values[i]; ++i) {
                }
            }
            this.stopCounter = i;
            this.positionCounter = i + length;
            this.isPositionValid = false;
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        public int remaining() {
            return this.remaining;
        }

        @Override
        public Long next() {
            return this.nextValue();
        }

        public long nextValue() {
            if (this.remaining == 1 && LongHashSet.this.containsMissingValue) {
                this.remaining = 0;
                this.isPositionValid = true;
                return -1L;
            }
            this.findNext();
            long[] values = LongHashSet.this.values;
            return values[this.position(values)];
        }

        @Override
        public void remove() {
            if (this.isPositionValid) {
                if (0 == this.remaining && LongHashSet.this.containsMissingValue) {
                    LongHashSet.this.containsMissingValue = false;
                } else {
                    long[] values = LongHashSet.this.values;
                    int position = this.position(values);
                    values[position] = -1L;
                    --LongHashSet.this.sizeOfArrayValues;
                    LongHashSet.this.compactChain(position);
                }
            } else {
                throw new IllegalStateException();
            }
            this.isPositionValid = false;
        }

        private void findNext() {
            long[] values = LongHashSet.this.values;
            int mask = values.length - 1;
            this.isPositionValid = true;
            int stop = this.stopCounter;
            for (int i = this.positionCounter - 1; i >= stop; --i) {
                int index = i & mask;
                if (-1L == values[index]) continue;
                this.positionCounter = i;
                --this.remaining;
                return;
            }
            this.isPositionValid = false;
            throw new NoSuchElementException();
        }

        private int position(long[] values) {
            return this.positionCounter & values.length - 1;
        }
    }
}

