/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.broadcast;

import java.lang.invoke.VarHandle;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.broadcast.BroadcastBufferDescriptor;
import org.agrona.concurrent.broadcast.RecordDescriptor;

public class BroadcastTransmitter {
    private final AtomicBuffer buffer;
    private final int capacity;
    private final int maxMsgLength;
    private final int tailIntentCountIndex;
    private final int tailCounterIndex;
    private final int latestCounterIndex;

    public BroadcastTransmitter(AtomicBuffer buffer) {
        this.buffer = buffer;
        this.capacity = buffer.capacity() - BroadcastBufferDescriptor.TRAILER_LENGTH;
        BroadcastBufferDescriptor.checkCapacity(this.capacity);
        buffer.verifyAlignment();
        this.maxMsgLength = RecordDescriptor.calculateMaxMessageLength(this.capacity);
        this.tailIntentCountIndex = this.capacity + BroadcastBufferDescriptor.TAIL_INTENT_COUNTER_OFFSET;
        this.tailCounterIndex = this.capacity + BroadcastBufferDescriptor.TAIL_COUNTER_OFFSET;
        this.latestCounterIndex = this.capacity + BroadcastBufferDescriptor.LATEST_COUNTER_OFFSET;
    }

    public int capacity() {
        return this.capacity;
    }

    public int maxMsgLength() {
        return this.maxMsgLength;
    }

    public void transmit(int msgTypeId, DirectBuffer srcBuffer, int srcIndex, int length) {
        RecordDescriptor.checkTypeId(msgTypeId);
        this.checkMessageLength(length);
        AtomicBuffer buffer = this.buffer;
        long currentTail = buffer.getLong(this.tailCounterIndex);
        int recordOffset = (int)currentTail & this.capacity - 1;
        int recordLength = 8 + length;
        int recordLengthAligned = BitUtil.align(recordLength, 8);
        long newTail = currentTail + (long)recordLengthAligned;
        int toEndOfBuffer = this.capacity - recordOffset;
        if (toEndOfBuffer < recordLengthAligned) {
            this.signalTailIntent(buffer, newTail + (long)toEndOfBuffer);
            BroadcastTransmitter.insertPaddingRecord(buffer, recordOffset, toEndOfBuffer);
            currentTail += (long)toEndOfBuffer;
            recordOffset = 0;
        } else {
            this.signalTailIntent(buffer, newTail);
        }
        buffer.putInt(RecordDescriptor.lengthOffset(recordOffset), recordLength);
        buffer.putInt(RecordDescriptor.typeOffset(recordOffset), msgTypeId);
        buffer.putBytes(RecordDescriptor.msgOffset(recordOffset), srcBuffer, srcIndex, length);
        buffer.putLongRelease(this.latestCounterIndex, currentTail);
        buffer.putLongRelease(this.tailCounterIndex, currentTail + (long)recordLengthAligned);
    }

    private void signalTailIntent(AtomicBuffer buffer, long newTail) {
        buffer.putLongRelease(this.tailIntentCountIndex, newTail);
        VarHandle.releaseFence();
    }

    private static void insertPaddingRecord(AtomicBuffer buffer, int recordOffset, int length) {
        buffer.putInt(RecordDescriptor.lengthOffset(recordOffset), length);
        buffer.putInt(RecordDescriptor.typeOffset(recordOffset), -1);
    }

    private void checkMessageLength(int length) {
        if (length > this.maxMsgLength) {
            throw new IllegalArgumentException("encoded message exceeds maxMsgLength of " + this.maxMsgLength + ", length=" + length);
        }
    }
}

