/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.errors;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.agrona.BitUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.EpochClock;

public final class DistinctErrorLog {
    public static final int LENGTH_OFFSET = 0;
    public static final int OBSERVATION_COUNT_OFFSET = 4;
    public static final int LAST_OBSERVATION_TIMESTAMP_OFFSET = 8;
    public static final int FIRST_OBSERVATION_TIMESTAMP_OFFSET = 16;
    public static final int ENCODED_ERROR_OFFSET = 24;
    public static final int RECORD_ALIGNMENT = 8;
    static final DistinctObservation INSUFFICIENT_SPACE = new DistinctObservation(null, 0);
    private final EpochClock clock;
    private final AtomicBuffer buffer;
    private final Charset charset;
    private DistinctObservation[] distinctObservations = new DistinctObservation[0];
    int nextOffset = 0;

    public DistinctErrorLog(AtomicBuffer buffer, EpochClock clock) {
        this(buffer, clock, StandardCharsets.UTF_8);
    }

    public DistinctErrorLog(AtomicBuffer buffer, EpochClock clock, Charset charset) {
        buffer.verifyAlignment();
        this.clock = clock;
        this.buffer = buffer;
        this.charset = charset;
    }

    public AtomicBuffer buffer() {
        return this.buffer;
    }

    public Charset charset() {
        return this.charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean record(Throwable exception) {
        DistinctObservation distinctObservation;
        long timestampMs = this.clock.time();
        DistinctErrorLog distinctErrorLog = this;
        synchronized (distinctErrorLog) {
            distinctObservation = DistinctErrorLog.find(this.distinctObservations, exception);
            if (null == distinctObservation && INSUFFICIENT_SPACE == (distinctObservation = this.newObservation(timestampMs, exception))) {
                return false;
            }
        }
        int offset = distinctObservation.offset;
        this.buffer.getAndAddInt(offset + 4, 1);
        this.buffer.putLongRelease(offset + 8, timestampMs);
        return true;
    }

    private static DistinctObservation find(DistinctObservation[] existingObservations, Throwable exception) {
        DistinctObservation existingObservation = null;
        for (DistinctObservation o : existingObservations) {
            if (!DistinctErrorLog.equals(o.throwable, exception)) continue;
            existingObservation = o;
            break;
        }
        return existingObservation;
    }

    private static boolean equals(Throwable lhs, Throwable rhs) {
        do {
            if (lhs == rhs) {
                return true;
            }
            if (lhs.getClass() != rhs.getClass() || !Objects.equals(lhs.getMessage(), rhs.getMessage()) || !DistinctErrorLog.equals(lhs.getStackTrace(), rhs.getStackTrace())) break;
            lhs = lhs.getCause();
            rhs = rhs.getCause();
            if (null != lhs || null != rhs) continue;
            return true;
        } while (null != lhs && null != rhs);
        return false;
    }

    private static boolean equals(StackTraceElement[] lhsStackTrace, StackTraceElement[] rhsStackTrace) {
        if (lhsStackTrace.length != rhsStackTrace.length) {
            return false;
        }
        int length = lhsStackTrace.length;
        for (int i = 0; i < length; ++i) {
            StackTraceElement lhs = lhsStackTrace[i];
            StackTraceElement rhs = rhsStackTrace[i];
            if (lhs.getLineNumber() == rhs.getLineNumber() && lhs.getClassName().equals(rhs.getClassName()) && Objects.equals(lhs.getMethodName(), rhs.getMethodName()) && Objects.equals(lhs.getFileName(), rhs.getFileName())) continue;
            return false;
        }
        return true;
    }

    DistinctObservation newObservation(long timestampMs, Throwable exception) {
        int offset = this.nextOffset;
        if (offset < 0) {
            return INSUFFICIENT_SPACE;
        }
        int remainingCapacity = this.buffer.capacity() - 24 - offset;
        if (remainingCapacity <= 0) {
            return INSUFFICIENT_SPACE;
        }
        byte[] encodedError = this.encodedError(exception);
        if (remainingCapacity - encodedError.length < 0) {
            return INSUFFICIENT_SPACE;
        }
        int length = 24 + encodedError.length;
        this.buffer.putBytes(offset + 24, encodedError);
        this.buffer.putLong(offset + 16, timestampMs);
        this.nextOffset = BitUtil.align(offset + length, 8);
        DistinctObservation distinctObservation = new DistinctObservation(exception, offset);
        this.distinctObservations = DistinctErrorLog.prepend(this.distinctObservations, distinctObservation);
        this.buffer.putIntRelease(offset + 0, length);
        return distinctObservation;
    }

    byte[] encodedError(Throwable observation) {
        StringWriter stringWriter = new StringWriter();
        observation.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString().getBytes(this.charset);
    }

    private static DistinctObservation[] prepend(DistinctObservation[] observations, DistinctObservation observation) {
        int length = observations.length;
        DistinctObservation[] newObservations = new DistinctObservation[length + 1];
        newObservations[0] = observation;
        System.arraycopy(observations, 0, newObservations, 1, length);
        return newObservations;
    }

    record DistinctObservation(Throwable throwable, int offset) {
    }
}

